#!/usr/bin/perl

# (c) 2000 Randolph Chung <tausq@debian.org>, GPLv2

# TODO: do something for i18n.... language passed in as a command line param

use strict;
use File::Basename;
# Enable/Disable debugging here
my $opt_d = 0;

my $linux = $ARGV[0];

die "No kernel source given" unless $linux;
die "No Makefile in kernel source found" unless -f "$linux/Makefile";
warn "I: Will parse kernel Makefiles under \"$linux\".\n";
if(open(fh, "<$linux/Makefile") && grep(/PATCHLEVEL.*=.*6/, <fh>)) {
   warn "I: Using Kernel 2.6 extraction method.\n";
   main26() || die "Failed to extract description data!\n";
   exit;
}

my $makefiles = `find $linux -name 'Makefile' -print0`;
my $confighelp = "/usr/src/linux/Documentation/Configure.help";
if ( ! -r $confighelp ) {
# Hmm... can we use the one under $linux?
	warn "I: The main $confighelp file cannot be used, using the one from $linux instead\n";
	$confighelp = $linux."/Documentation/Configure.help";
}
if ( ! -r $confighelp ) {
	die "Cannot read the Documentation's help from $confighelp\n";
}


my (%objs, $f, $lastline, $obj, $tmp);

foreach $f (split(/\000/, $makefiles)) {
  open (F, "<$f") || die "open $f: $!";
  print STDERR "Reading modules from Makefile $f\n" if $opt_d;
  while (<F>) {
    #print ">> $_";
    chomp;
    if (/^obj\-\$\((CONFIG_.+?)\)\s+\+?=\s+([^#]*\.o).*$/) {
    # matches:  obj-$(CONFIG_AZTCD)             += aztcd.o # comment
      my $cfg = $1;
      foreach (split(/\s+/,$2)) {
        push(@{$objs{$cfg}},$_) if ($_ !~ /[\$\\]/);
	printf STDERR "%s - %s\n", $cfg, $_ if ($_ !~ /[\$\\]/) && $opt_d;
      }
      $lastline = $_;
      next;
    }

    $tmp = "$lastline $_";
    
    if ($tmp =~ /(CONFIG_.+?)\).*?OBJS\s+\+?=\s+([^\.]+?\.o)\s*/) {
      # matches most lines 
      push(@{$objs{$1}}, $2);
    } elsif ($tmp =~ /(CONFIG_.+?)\).*?DIRS.+?=\s+(\S+)/) {
      # matches stuff in net
      push(@{$objs{$1}},"$2.o");
    }
    $lastline = $_;
  }
}

$lastline = undef;
open (H, "<$confighelp") || die $!;
while (<H>) {
  chomp;
  if (/^(CONFIG_.+?)$/) {
    foreach $obj (@{$objs{$1}}) {
      print sprintf("%s=\"%s\"\n", xlat_objname($obj), $lastline);
    }
  }

  $lastline = $_;
  $lastline=~s/`/'/g;
  $lastline=~s/"/'/g;
}
close H;

sub xlat_objname {
  my $obj = shift;

  $obj =~ s/\.[co]$//;
  $obj =~ s/[-,\+]/_/g;
  $obj =~ s/.*\/(.+)/$1/;
  return "summary_$obj";
}

sub main26 {
   open(fi, "find $linux | grep Kconfig\$ |") || die "find failed" ;
   Kconfig: foreach(<fi>) {
      my %dstrings;
      my $VARNAME;
      open(kc, "<$_") || die "Failed to open $_";
      open(mk, "<".dirname($_)."/Makefile") || next Kconfig;
      while(<kc>) {
         if(/^config\ (\S+)\n/) {
            $VARNAME="CONFIG_$1";
         }
         if(/^\W*tristate\ "(.+)"/) {
            $dstrings{$VARNAME}=$1;
         }
      }
      while(<mk>) {
         if(/obj-..(\w+).*=\s*(\w+)\.o/) {
            if(defined($dstrings{$1})) {
               print "summary_$2=\"$dstrings{$1}\"\n";
            }
         }
      }
      close(kc);
      close(mk);
   }
   return 1;
}
