/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: parse.c,v 1.11 2003/04/18 18:40:41 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

#if 0
#define DEBUG_PCRE 1
#endif

int parse_record_pcre(mconfig *ext_conf, mlogrec *record, buffer *b) {
#define N 100 + 1
	const char **list;
	int ovector[3 * N], n;
#ifdef DEBUG_PCRE
	int i;
#endif

	config_input *conf = ext_conf->plugin_conf;
	mlogrec_web *recweb = NULL;
	mlogrec_web_extclf *recext = NULL;
	
	if (record->ext_type != M_RECORD_TYPE_WEB) {
		if (record->ext_type != M_RECORD_TYPE_UNSET) {
			mrecord_free_ext(record);
		}
		
		record->ext_type = M_RECORD_TYPE_WEB;
		record->ext = mrecord_init_web();
	}

	recweb = record->ext;
	
	if (recweb == NULL) return M_RECORD_HARD_ERROR;


	recext = mrecord_init_web_extclf();

	recweb->ext_type = M_RECORD_TYPE_WEB_EXTCLF;
	recweb->ext = recext;

	if (recweb == NULL) return -1;

	if ((n = pcre_exec(conf->match_qtss, conf->match_qtss_extra, b->ptr, b->used - 1, 0, 0, ovector, 3 * N)) < 0) {
		if (n == PCRE_ERROR_NOMATCH) {
			fprintf(stderr, "%s.%d: string doesn't match: %s\n", __FILE__, __LINE__, b->ptr);
		} else {
			fprintf(stderr, "%s.%d: execution error while matching: %d\n", __FILE__, __LINE__, n);
		}
		return -1;
	}
#undef  N

	/*
	 * taken from http://www.apple.com/quicktime/authoring/qtss/pgs/qt18.htm
	 *
	 * 1 - client IP address
	 *   195.42.198.4
	 * 2 - date / time of access
	 *   2001-01-12 15:02:33
	 * 3 - resolved dns of the client
	 *   -
	 * 4 - requested file
	 *   /diabetes/SDF_056.h.mov
	 * 5 - (unix)timestamp of start time
	 *   979308124
	 * 6 - duration of the session(s) in whole seconds
	 *   29
	 * 7 - [not used at this time]
	 *   1
	 * 8 - status code
	 *   200
	 * 9 - unique player ID
	 *   195.42.198.4
	 * 10- qtss version
	 *   4.1.1
	 * 11- player language (two letter country code)
	 *   -
	 * 12- user agent
	 *   QTS%20(qtver=4.1.1;os=Windows%20NT%204.0Service%20Pack%206)
	 * 13- referring URL
	 *   --
	 * 14- [not used at this time]
	 *   -
	 * 15- os version
	 *   Windows%20NT%204.0Service%20Pac
	 * 16- [not used at this time]
	 *   -
	 * 17- type of cpu
	 *   -
	 * 18- file length(s) in whole seconds
	 *   555
	 * 19- file size (bytes)
	 *   2183273
	 * 20- bytes per second
	 *   31464
	 * 21- protocol (RTP)
	 *   RTP
	 * 22- protocol (TCP/UDP)
	 *   TCP
	 * 23- audio codec name
	 *   -
	 * 24- video codec name
	 *   X-SorensonVideo/90000
	 * 25- [not used at this time]
	 *   -
	 * 26- bytes sent by server to the client
	 *   131843
	 * 27- bytes received by the client
	 *   0
	 * 28- packets sent by server
	 *   463
	 * 29- packets received by the client
	 *   0
	 * 30- packets lost by the client
	 *   0
	 * 31- packets lost at the network layer
	 *   0
	 * 32- continuous packets lost at the network layer
	 *   0
	 * 33- packets resent
	 * 34- packets resent successfully; recovered in the client layer
	 * 35- packets recovered via udp resend
	 * 36- buffercount
	 *   1
	 * 37- seconds buffered
	 *   3
	 * 38- quality measurement (percent)
	 *   100
	 * 39- server ip
	 *   213.131.156.9
	 * 40- server name
	 *   qtss.eyebeep.com
	 * 41- total client connections at the time of access
	 *   1
	 * 42- percent cpu utilization at the time of access
	 *   0
	 * 43- [not used at this time]
	 *   -
	 * 44- ??
	 *   -
	 *
	 */

	if (n == 45) {
		pcre_get_substring_list(b->ptr, ovector, n, &list);

		record->timestamp = strtol(list[5], NULL, 10);

		buffer_strcpy(recweb->req_url, (char *)list[4]);

		/* 21/22 */
		buffer_strcpy(recweb->req_protocol, (char *)list[21]);

		buffer_strcpy(recweb->req_host_ip, (char *)list[1]);

		recweb->req_status = strtol(list[8], NULL,10);
		recweb->xfersize = strtol(list[26], NULL,10);

		buffer_strcpy(recext->ref_url, (char *)list[13]);

		buffer_strcpy(recext->req_useragent, (char *)list[12]);

		buffer_strcpy(recext->req_useros, (char *)list[15]);

		buffer_strcpy(recext->srv_host, (char *)list[40]);

		recext->duration = strtol(list[6], NULL, 10);

#ifdef DEBUG_PCRE
		for (i = 0; i < n; i++) {
			printf("%d: %s\n", i, list[i]);
		}
#endif
		free(list);
	}

	return 0;

}

int mplugins_input_qtss_get_next_record(mconfig *ext_conf, mlogrec *record) {
	int ret = 0;
	config_input *conf = ext_conf->plugin_conf;

	if (record == NULL) return M_RECORD_HARD_ERROR;

	/* fill the line buffer */
	if (NULL == mgets(&(conf->inputfile), conf->buf)) return M_RECORD_EOF;
	
	ret = parse_record_pcre   (ext_conf, record, conf->buf);
	
	if (ret == M_RECORD_CORRUPT) {
		M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_WARNINGS,
			 "affected Record: %s\n",
			 conf->buf->ptr
			 );
	}
	return ret;
}
