/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: mconfig.h,v 1.39 2003/01/04 16:16:49 ostborn Exp $
*/

#ifndef _M_CONFIG_H_
#define _M_CONFIG_H_

#include "config.h"
#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#ifdef HAVE_LIBADNS
#include <adns.h>
#endif

#include "mhash.h"

#include "mdebug.h"

#define M_CONFIG_TYPE_STRING		0
#define M_CONFIG_TYPE_INT		1
#define M_CONFIG_TYPE_SUBSTITUTE	2
#define M_CONFIG_TYPE_MATCH		3
#define M_CONFIG_TYPE_COLTRIPPL		4
#define M_CONFIG_TYPE_CHAR		5
#define M_CONFIG_TYPE_STRING_LIST	6

#define M_CONFIG_VALUE_IGNORE		1
#define M_CONFIG_VALUE_OVERWRITE	2
#define M_CONFIG_VALUE_APPEND		3

typedef struct {
	char *string;	/* name of the entry */
	int type;	/* type of the value (M_CONFIG_TYPE...)*/
	int value_def;	/* how to handle an field with the same key (append, overwrite, ignore) */
	void *dest;	/* where to put the result into */
} mconfig_values;

typedef struct {
	mlist *loadplugins;
	mlist *include;
	mlist *includepath;
	
	mlist *cmdlineoptions;

	char *statedir;
	char *configfile;

	int incremental;

	int debug_level;
	int show_options;

	int compress_mode;

	int gen_report_threshold;
	int enable_resolver;
	int debug_resolver;

	int read_ahead_limit;

	char *version;

	mhash *variables;

#ifdef HAVE_LIBADNS
	adns_state *adns;
	mhash	*query_hash;
#endif

	/* magic handler for the currently used plugin */
	void *plugin_conf;

	/* list of plugins */
	void *plugins;
	int plugin_count;
} mconfig;

mconfig* mconfig_init();
int mconfig_read(mconfig *conf, const char *fn);
int mconfig_free(mconfig *);

int mconfig_parse_section(mconfig *conf, const char *cf, const char *section, const mconfig_values config_values[]);
FILE *mfopen (mconfig *ext_conf, const char *filename, const char *rights);
char *mconfig_get_value(mconfig *ext_conf, const char *value);

#endif
