/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pictures_vhosts.c,v 1.9 2003/01/06 11:18:15 ostborn Exp $
*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "config.h"
#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"

#define IM_FILENAME	"vhosts_"
#define IM_FILEEXT	".png"

char *create_pic_vhost(mconfig *ext_conf, mstate *state) {
#ifdef HAVE_LIBGD
	int i = 0;
	char filename[255];
	config_output *conf = ext_conf->plugin_conf;
	mlist *l, *vhost_list = mlist_init(), *p;
	mstate_web *staweb = state->ext;
	double max_bahr;

	static char href[255] = "";

	int col_count;

	mgraph * graph = malloc(sizeof(mgraph));

	p = conf->col_vhostcircle;

	if (!p) {
		fprintf(stderr, "%s.%d: No colors for the circle found!!\n", __FILE__, __LINE__);
		return NULL;
	}

	/* parse the colors for the vhosts pie */
	col_count = 0;

	for (; p && p->data; p = p->next) {
		mdata *data = p->data;
		
		if (is_htmltripple(data->key)) {
			col_count++;
		} else {
			fprintf(stderr, "%s.%d: RGB-tripple %s is invalid. not used for the vhosts pie.\n", __FILE__, __LINE__, data->key);
		}
	}

	if (col_count < 2) {
		fprintf(stderr, "%s.%d: Less then 2 colors for the circle found!!\n", __FILE__, __LINE__);

		return NULL;
	}

	mhash_unfold_sorted_limited(staweb->vhost_hash, vhost_list, 50);

	max_bahr = mhash_sumup(staweb->vhost_hash);

	memset(graph, 0, sizeof(mgraph));

	graph->name = malloc(strlen(_("Vhosts")) + strlen(get_month_string(state->month,0)) + 4 + 2 + 1);
	sprintf(graph->name, "%s %s %04d",
		_("Vhosts"),
		get_month_string(state->month,0),
		state->year
		);

	graph->max_x = 1;
	graph->max_z = 0;
	l = vhost_list;
	while (l) {
		mdata *data = l->data;

		if (data == NULL) {
			l = l->next;
			continue;
		}

		if( mdata_get_count(data) / max_bahr < 0.01 || graph->max_z >= 9)
			break;

		graph->max_z++;
		l = l->next;
	}
	graph->filename = NULL;
	graph->height = 0;
	graph->width  = 0;
	graph->pair_names = NULL;

	if (graph->max_z == 0) {
		/* nothing to draw */
		return NULL;
	}

	graph->pairs = malloc(sizeof(mgraph_array *) * graph->max_z);
	for (i = 0; i < graph->max_z; i++) {
		graph->pairs[i] = malloc(sizeof(mgraph_array));
		graph->pairs[i]->values = malloc(sizeof(double) * graph->max_x);
	}

	l = vhost_list; p = conf->col_vhostcircle;
	for (i = 0; i < graph->max_z; i++, l = l->next, p = p->next) {
		if (p == NULL) p = conf->col_vhostcircle;
		
		graph->pairs[i]->values[0] = mdata_get_count(l->data);
		graph->pairs[i]->color = mdata_get_key(p->data, state);
		graph->pairs[i]->name = mdata_get_key(l->data, state);
	}

	sprintf(filename, "%s/%s%04d%02d%s",
		conf->outputdir,
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT);

	graph->filename = filename;

	create_pie(ext_conf, graph);

	sprintf(href, "<img src=\"%s%04d%02d%s\" alt=\"%s\" width=\"%d\" height=\"%d\">\n",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT,
		_("Vhosts"), graph->width, graph->height);

	for (i = 0; i < graph->max_z; i++) {
		free(graph->pairs[i]->values);
		free(graph->pairs[i]);
	}

	mlist_free(vhost_list);
	free(graph->pairs);
	free(graph->name);
	free(graph);

	return href;
#else
	return NULL;
#endif
}

