/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: generate.c,v 1.24 2002/10/23 15:05:37 le_zas Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "mconfig.h"
#include "mstate.h"
#include "mlocale.h"
#include "mhash.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mplugins.h"

#include "plugin_config.h"

int mlist_sumup(mlist *l) {
	int c = 0;
	if (!l) return 0;

	while (l) {
		if (l->data) {
			c += mdata_get_count(l->data);
		}
		l = l->next;
	}

	return c;
}

long mhash_sumup(mhash *h) {
	int i, c = 0;
	if (!h) return 0;

	for ( i = 0; i < h->size; i++) {
		c += mlist_sumup(h->data[i]->list);
	}

	return c;
}

mlist * get_next_element(mhash *h) {
	mlist *ret = NULL;
	int max = 0, i;

	for ( i = 0; i < h->size; i++) {
		mlist *l = h->data[i]->list;
		while (l) {
			if (l->data) {
				mdata *data = l->data;

				if ( mdata_get_count(data) > max) {
					max = mdata_get_count(data);
					ret = l;
				}
			}
			l = l->next;
		}
	}

	if (ret) {
		mdata_set_count(ret->data, -mdata_get_count(ret->data));
	}

	return ret;
}

int cleanup_elements(mhash *h) {
	int i;
	for ( i = 0; i < h->size; i++) {
		mlist *l = h->data[i]->list;
		while (l) {
			if (l->data) {
				mdata *data = l->data;

				mdata_set_count(data, -mdata_get_count(data));

			}
			l = l->next;
		}
	}

	return 0;
}

int show_visit_path (mconfig *ext_conf, FILE *f, mhash *h, int count) {
	int i = 0;
	mlist *l;
	long sum;

	if (!h) return 0;

	sum = mhash_sumup(h);

	while ((l = get_next_element(h)) && i < count) {
		if (l->data) {
			mdata *data = l->data;
			int c = -mdata_get_count(data);

			i++;

			fprintf(f,"%2d %8d %6.2f %s\n", i, c, c * 100.0 / sum, data->key);
		}
	}

	cleanup_elements(h);

	return 0;
}

int mplugins_output_text_generate_monthly_output(mconfig *ext_conf, mstate *state, const char *subpath) {
	FILE *f = NULL;
	char filename[255];
	config_output *conf = ext_conf->plugin_conf;
	mstate_mail *stamail = NULL;
	marray_mail sum;
	int i,j;

	if (state == NULL) return -1;
	if (state->ext == NULL) return -1;
	if (state->ext_type != M_STATE_TYPE_MAIL) return -1;

	stamail = state->ext;

	if (subpath) {
		sprintf(filename, "%s/%s/",
			conf->outputdir ? conf->outputdir : ".",
			subpath);
		mkdir(filename, 0755);
	}

	sprintf(filename, "%s%s%s/index-%04d%02d.txt",
		conf->outputdir ? conf->outputdir : ".",
		subpath ? "/" : "",
		subpath ? subpath : "",
		state->year, state->month
		);

	if (!(f = fopen(filename, "w"))) {
		return -1;
	}

	sum.incoming_mails = 0;
	sum.outgoing_mails = 0;
	sum.incoming_bytes = 0;
	sum.outgoing_bytes = 0;

	fprintf(f, "Oo. mailstats for %s.oO\n\n", conf->hostname);

	fprintf(f, ".-= mailcount and traffic by day =-.\n");
	fprintf(f," %5s %10s %10s %10s %10s\n",
		"hour",
		"mail-in",
		"mail-out",
		"bytes-in",
		"bytes-out");
	for ( i = 0; i < 24; i++) {
		fprintf(f," %5d %10ld %10ld %10ld %10ld\n",
			i,
			stamail->hours[i].incoming_mails,
			stamail->hours[i].outgoing_mails,
			stamail->hours[i].incoming_bytes,
			stamail->hours[i].outgoing_bytes
			);
		sum.incoming_mails += stamail->hours[i].incoming_mails;
		sum.outgoing_mails += stamail->hours[i].outgoing_mails;
		sum.incoming_bytes += stamail->hours[i].incoming_bytes;
		sum.outgoing_bytes += stamail->hours[i].outgoing_bytes;
	}

	fprintf(f," %5s %10ld %10ld %10ld %10ld\n",
		"sum",
		sum.incoming_mails,
		sum.outgoing_mails,
		sum.incoming_bytes,
		sum.outgoing_bytes
		);

	fprintf(f, "\n.-= mailcount and traffic by hour =-.\n");
	sum.incoming_mails = 0;
	sum.outgoing_mails = 0;
	sum.incoming_bytes = 0;
	sum.outgoing_bytes = 0;
	fprintf(f," %5s %10s %10s %10s %10s\n",
		"day",
		"mail-in",
		"mail-out",
		"bytes-in",
		"bytes-out");
	for ( i = 0; i < 31; i++) {
		fprintf(f," %5d %10ld %10ld %10ld %10ld\n",
			i,
			stamail->days[i].incoming_mails,
			stamail->days[i].outgoing_mails,
			stamail->days[i].incoming_bytes,
			stamail->days[i].outgoing_bytes
			);
		sum.incoming_mails += stamail->days[i].incoming_mails;
		sum.outgoing_mails += stamail->days[i].outgoing_mails;
		sum.incoming_bytes += stamail->days[i].incoming_bytes;
		sum.outgoing_bytes += stamail->days[i].outgoing_bytes;
	}

	fprintf(f," %5s %10ld %10ld %10ld %10ld\n",
		"sum",
		sum.incoming_mails,
		sum.outgoing_mails,
		sum.incoming_bytes,
		sum.outgoing_bytes
		);

	fprintf(f, "\n.-= mails by sender =-.\n");
	show_visit_path (ext_conf, f, stamail->sender, 20);

	fprintf(f, "\n.-= mails by receipient =-.\n");
	show_visit_path (ext_conf, f, stamail->receipient, 20);

	fprintf(f, "\n.-= queuepolution =-.\n");
	fprintf(f, "%s %s %s %s %s %s %s %s\n",
		"day", "day",
		"local-cur", "local-max",
		"remote-cur", "remote-cur",
		"deliver-cur", "queue-cur");
	for (i = 0; i < 31; i++) {
		for (j = 0; j < 24; j++) {
			if (stamail->qstat[i][j].count) {
				fprintf(f, "%5d %3d %9.0f %9.0f %10.0f %10.0f %11.0f %9.0f\n",
					i+1,
					j,
					stamail->qstat[i][j].local_cur / stamail->qstat[i][j].count,
					stamail->qstat[i][j].local_max / stamail->qstat[i][j].count,
					stamail->qstat[i][j].remote_cur / stamail->qstat[i][j].count,
					stamail->qstat[i][j].remote_max / stamail->qstat[i][j].count,
					stamail->qstat[i][j].deliver_cur / stamail->qstat[i][j].count,
					stamail->qstat[i][j].queue_cur / stamail->qstat[i][j].count
					);
			}
		}
	}

	fclose(f);

	return 0;

}

int mplugins_output_generate_history_output(mconfig *ext_conf, mlist *history, const char *subpath) {

	return 0;
}
