/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: pictures_hour.c,v 1.15 2002/10/23 15:05:39 le_zas Exp $
*/
#include <stdio.h>
#include <stdlib.h>

#include "config.h"

#ifdef HAVE_LIBGD
#ifdef HAVE_GD_GD_H
#include <gd/gd.h>
#include <gd/gdfonts.h>
#else
#include <gd.h>
#include <gdfonts.h>
#endif
#endif

#include "mconfig.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mlocale.h"
#include "misc.h"

#include "pictures.h"
#include "generate.h"
/* calculating the box
**
** +------------------------------+
** |+----------------------------+|
** ||                            ||
** ||#                           ||
** ||##  #    (1)                ||
** ||## ##                       ||
** ||#####                       ||
** ||#####                       ||
** |+----------------------------+|
** +------------------------------+
**
*/

#define IM_BARS		 24

#define IM_HEIGHT	200
#define IM_CELLSPACING	  4

/* gdSmallFont */
#define IM_FONT_HEIGHT	 13
#define IM_FONT_WIDTH	  6

#define IM_LAB1_Y1	IM_HEIGHT - IM_FONT_HEIGHT - IM_CELLSPACING

#define IM_BOX1_BAR_WIDTH	 10
#define IM_BOX1_BAR_SHIFT	  2
#define IM_BOX1_BAR_SPACE	 10

#define IM_BOX1_X1	IM_CELLSPACING * 2 + IM_FONT_HEIGHT
#define IM_BOX1_Y1	IM_CELLSPACING * 2 + IM_FONT_HEIGHT
#define IM_BOX1_X2	IM_BOX1_X1 + IM_BARS * (IM_BOX1_BAR_WIDTH + IM_BOX1_BAR_SPACE)
#define IM_BOX1_Y2	IM_LAB1_Y1 - 2 * IM_CELLSPACING - 1

#define IM_WIDTH	IM_BOX1_X2 + IM_CELLSPACING * 2 + IM_FONT_HEIGHT

#define IM_FILENAME	"hourly_usage_"
#define IM_FILEEXT	".png"

char *create_pic_24_hour(mconfig *ext_conf, mstate *state, const char *subpath) {
#ifdef HAVE_LIBGD
	data_WebHistory max;
	int i = IM_BARS;
	gdImage *im;
	FILE *f;
	char filename[255];
	rgb_tripple rgb;
	int x1, y1, x2, y2;
	char int2str[20]; /* 20 is a guess only !! */
	config_output *conf = ext_conf->plugin_conf;
	mstate_web *staweb = state->ext;

	static char href[255] = "";

	int col_border, col_backgnd,
		col_pages, col_files,
		col_visits, col_border_sh,
		col_hits;

	max.hits	= 0;
	max.files	= 0;
	max.pages	= 0;
	max.visits	= 0;
	max.hosts	= 0;
	max.xfersize	= 0;

#define	SET_MAX(x) if (staweb->hours[i].x > max.x) max.x = staweb->hours[i].x
	for ( i = 0; i < IM_BARS; i++) {
		SET_MAX(hits);
		SET_MAX(files);
		SET_MAX(pages);
		SET_MAX(visits);
		SET_MAX(hosts);
		SET_MAX(xfersize);
	}
#undef SET_MAX

	im = gdImageCreate( IM_WIDTH + 1,IM_HEIGHT + 1 );


	col_border	= gdImageColorAllocate(im, 0x00, 0x00, 0x00);

	html3torgb3(conf->col_shadow, &rgb);
	col_border_sh	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

	html3torgb3(conf->col_backgnd, &rgb);
	col_backgnd	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_hits, &rgb);
	col_hits	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_files, &rgb);
	col_files	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_pages, &rgb);
	col_pages	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);
	html3torgb3(conf->col_visits, &rgb);
	col_visits	= gdImageColorAllocate(im, rgb.r, rgb.g, rgb.b);

/* background */
	gdImageFilledRectangle(im, 0, 0, IM_WIDTH-1, IM_HEIGHT-1, col_backgnd);
/* surrounding border */
	gdImageRectangle( im, 1, 1, IM_WIDTH-1, IM_HEIGHT-1, col_border );
	gdImageRectangle( im, 0, 0, IM_WIDTH, IM_HEIGHT, col_border_sh );



/* upward strings - max hits */
	sprintf(int2str, "%li", max.hits);
	x1 = IM_CELLSPACING;
	y1 = IM_BOX1_Y1 + strlen(int2str) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1, y1, int2str, col_border);

/* upward strings - 'pages/files/hits' */
	x1 = IM_WIDTH - IM_CELLSPACING - IM_FONT_HEIGHT;
	y1 = IM_BOX1_Y1 + strlen(_("Hits")) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, _("Hits"), col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, _("Hits"), col_hits);

	y1 += IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, "/", col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, "/", col_border);

	y1 += strlen(_("Files")) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, _("Files"), col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, _("Files"), col_files);

	y1 += IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, "/", col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, "/", col_border);

	y1 += strlen(_("Pages")) * IM_FONT_WIDTH;
	gdImageStringUp(im, gdFontSmall, x1+1, y1+1, _("Pages"), col_border_sh);
	gdImageStringUp(im, gdFontSmall, x1, y1, _("Pages"), col_pages);

/* header */
	x1 = IM_BOX1_X1;
	y1 = IM_CELLSPACING;
	gdImageString(im, gdFontSmall, x1, y1, _("Hourly usage for "), col_border);

	x1 += strlen(_("Hourly usage for ")) * IM_FONT_WIDTH;
	gdImageString(im, gdFontSmall, x1, y1, get_month_string(state->month,0), col_border);

	x1 += strlen(get_month_string(state->month,0)) * IM_FONT_WIDTH;
	sprintf(int2str, " %4i",state->year);
	gdImageString(im, gdFontSmall, x1, y1, int2str, col_border);

/* border for BOX1 */
	gdImageRectangle(im,
		IM_BOX1_X1 - IM_CELLSPACING,
		IM_BOX1_Y1 - IM_CELLSPACING,
		IM_BOX1_X2 + IM_CELLSPACING,
		IM_BOX1_Y2 + IM_CELLSPACING,
		col_border);
	gdImageRectangle(im,
		IM_BOX1_X1 - IM_CELLSPACING + 1,
		IM_BOX1_Y1 - IM_CELLSPACING + 1,
		IM_BOX1_X2 + IM_CELLSPACING + 1,
		IM_BOX1_Y2 + IM_CELLSPACING + 1,
		col_border_sh);

	for ( i = 0; i < IM_BARS; i++) {
		/* Box 1 */

		if (max.hits) {
			int y2b = IM_BOX1_Y2;
			int y1b = IM_BOX1_Y1;

			x1 = IM_BOX1_X1 + i * (IM_BOX1_BAR_SPACE + IM_BOX1_BAR_WIDTH);
			x2 = x1 + IM_BOX1_BAR_WIDTH;

			y2 = y2b;
			y1 = y2 - ((double)staweb->hours[i].hits / max.hits) * (y2b - y1b - 1);

			if (y1 != y2) {
				gdImageFilledRectangle(im, x1, y1, x2, y2, col_hits);
				gdImageRectangle(im, x1, y1, x2, y2, col_border);
			}

			x1 += IM_BOX1_BAR_SHIFT;
			x2 += IM_BOX1_BAR_SHIFT;

			y1 = y2 - ((double)staweb->hours[i].files / max.hits) * (y2b - y1b - 1);

			if (y1 != y2) {
				gdImageFilledRectangle(im, x1, y1, x2, y2, col_files);
				gdImageRectangle(im, x1, y1, x2, y2, col_border);
			}

			x1 += IM_BOX1_BAR_SHIFT;
			x2 += IM_BOX1_BAR_SHIFT;

			y1 = y2 - ((double)staweb->hours[i].pages / max.hits) * (y2b - y1b - 1);

			if (y1 != y2) {
				gdImageFilledRectangle(im, x1, y1, x2, y2, col_pages);
				gdImageRectangle(im, x1, y1, x2, y2, col_border);
			}
		}

		x1 = IM_BOX1_X1 + i * (IM_BOX1_BAR_SPACE + IM_BOX1_BAR_WIDTH);
		y1 = IM_LAB1_Y1;

		sprintf(int2str, "%02i", i);

		gdImageString(im, gdFontSmall, x1, y1, int2str, col_border);
	}

	sprintf(filename, "%s%s%s/%s%04d%02d%s",
		conf->outputdir ? conf->outputdir : ".",
		subpath ? "/" : "",
		subpath ? subpath : "",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT);

	if ((f = fopen (filename, "wb"))) {
		gdImagePng(im, f);

		fclose(f);
	}

	gdImageDestroy(im);

	sprintf(href, "<center><img src=\"%s%04i%02i%s\" alt=\"%s\" width=%i height=%i></center>\n",
		IM_FILENAME,
		state->year, state->month,
		IM_FILEEXT,
		_("Hourly usage"), IM_WIDTH+1, IM_HEIGHT+1);

	return href;
#else
	return NULL;
#endif
}

