/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.reusables;

import java.awt.Font;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class FontSetter {

	public static void setFont(JComponent pComponent, int size) {
		pComponent.setFont(new Font("Arial", Font.BOLD, size));
	}
	
	public static void adjustFont(JFrame pMainFarme) {
		Object[] objs = UIManager.getLookAndFeel().getDefaults().keySet().toArray();
		for (int i = 0; i < objs.length; i++) {
			if (objs[i].toString().toUpperCase().indexOf(".FONT") != -1) {
				Font font = UIManager.getFont(objs[i]);
				font = new Font("Arial", Font.PLAIN, 13);
				UIManager.put(objs[i], new FontUIResource(font));
			}
		}
		SwingUtilities.updateComponentTreeUI(pMainFarme);
		pMainFarme.repaint();
	}
	
}
