/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.reusables;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

import monajat.doa.Doa;
import monajat.util.LoacationSetter;
import monajat.util.PropertyManager;
import monajat.util.Language_util.LanguageResource;
import monajat.util.Language_util.OreintationHelper;
import sun.awt.VerticalBagLayout;

public class MonajatWindow extends JWindow implements MouseListener {

	private static final long serialVersionUID = 1L;

	private int MaximumWidth;
	
	private JLabel aClose;
	
	private JLabel aFreez;
	
	private Timer aTimer;
	
	public MonajatWindow(Doa doa) {
		JPanel aPanel = new JPanel();
		aPanel.setLayout(new GridLayout(1, 3));
		aClose = new JLabel(LanguageResource.getString("Close"));
		aClose.addMouseListener(this);
		FontSetter.setFont(aClose, 13);
		aClose.setHorizontalAlignment(SwingConstants.CENTER);
		aPanel.setBackground(Color.ORANGE);
		aFreez = new JLabel(LanguageResource.getString("Freeze"));
		aFreez.addMouseListener(this);
		FontSetter.setFont(aFreez, 13);
		aFreez.setHorizontalAlignment(SwingConstants.CENTER);
		JLabel name = new JLabel(LanguageResource.getString("Monajat"));
		FontSetter.setFont(name, 13);
		name.setHorizontalAlignment(SwingConstants.CENTER);
		aPanel.add(aFreez);
		aPanel.add(name);
		aPanel.add(aClose);
		int showFor = 5;
		try {
			showFor = Integer.parseInt(PropertyManager.getProperty("show_for"));
		} catch (NumberFormatException e) {
			showFor = 5;
		}
		aTimer = new Timer(showFor * 1000, new timerActionListener());
		aTimer.start();
		setLayout(new VerticalBagLayout());
		this.add(OreintationHelper.setJComponentOreintation(aPanel));
		this.setBackground(Color.DARK_GRAY);
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(doa.getMDoaContent().size() + 4, 1));
		mainPanel.setBackground(new Color(64, 64, 64));
		mainPanel.add(new JLabel(""));
		for (String string : doa.getMDoaContent()) {
			JLabel aLabel = new JLabel(string);
			FontSetter.setFont(aLabel, 16);
			FontMetrics aComponent = aLabel.getFontMetrics(aLabel.getFont());
			int textWidth = SwingUtilities.computeStringWidth(aComponent, aLabel.getText());
			MaximumWidth = Math.max(MaximumWidth, textWidth);
			aLabel.setHorizontalAlignment(SwingConstants.CENTER);
			aLabel.setForeground(Color.WHITE);
			mainPanel.add(aLabel);
		}
		mainPanel.add(new JLabel(""));
		JLabel aLabel = new JLabel(doa.getMDescription());
		FontSetter.setFont(aLabel, 16);
		aLabel.setHorizontalAlignment(SwingConstants.CENTER);
		aLabel.setForeground(Color.WHITE);
		FontMetrics aComponent = aLabel.getFontMetrics(aLabel.getFont());
		int textWidth = SwingUtilities.computeStringWidth(aComponent, aLabel.getText());
		MaximumWidth = Math.max(MaximumWidth, textWidth);
		mainPanel.add(aLabel);
		mainPanel.add(new JLabel(""));
		if (isAlwaysOnTopSupported()) {
			this.setAlwaysOnTop(true);
		}
		this.add(mainPanel);
		this.setSize(MaximumWidth + 20, (int) (20 * (doa.getMDoaContent().size() + 4)));
		this.setLocation(LoacationSetter.calculateLocationOnScreen(getWidth(), getHeight()));
		this.setVisible(true);
	}
	
	class timerActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			dispose();
		}
	}
	
	public void mouseClicked(MouseEvent e) {
		if (e.getSource() == aClose) {
			this.dispose();
		} else {
			aTimer.stop();
		}
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {
	}

	public void mousePressed(MouseEvent e) {
	}

	public void mouseReleased(MouseEvent e) {
	}

}
