type rc4_key
external rc4_key : string -> rc4_key = "ml_RC4_set_key"
val rc4 : rc4_key -> string -> string

external sha1 : string -> string = "ml_SHA1"

type -'a rsa_key
type priv_rsa_key = [ `PRIVATE ] rsa_key
type pub_rsa_key  = [ `PUBLIC ]  rsa_key

external decode_rsa_pubkey  : string -> pub_rsa_key  = "ml_d2i_RSA_PUBKEY"
external decode_rsa_privkey : string -> priv_rsa_key = "ml_d2i_PKCS8_RSA_PrivateKey"

val rsa_sha1_sign   : priv_rsa_key -> string -> string
val rsa_sha1_verify : pub_rsa_key  -> string -> string -> bool
