# copyright (C) 1997-2004 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: canvicon.tcl,v 1.10 2004/01/01 11:39:06 jfontain Exp $


class canvasWindowManager {

    class icon {

        set (image) [image create photo -data {
            R0lGODlhGAAYAMIAAPgA+AAAANjc2Hh8ePj8+AAAAAAAAAAAACH5BAEAAAAALAAAAAAYABgAAAN3CLrcviHKSWsEQYihO+8bqAVDFoKfJwqkmWrvCbZDbd94
            3hIhzw8+AQEoLLaERB8nuCwSdr1iEhnk0XJY7FEGE8VYpS7Ku9rGzuVSdn2DNn/VqTU8jDujPvddLgeT2GxmZGMigoQqhWFci18tFo8WAwCAlA+WlwkAOw==
        }]

        proc icon {this canvas title command {disabled 0}} {                                   ;# command is invoked on double click
            # use an empty image as an origin marker with only 2 coordinates
            set origin [$canvas create image 0 0 -tags icon($this)]
            set image [$canvas create image 0 0 -image $(image) -anchor n -tags icon($this)]
            set text [$canvas create text\
                0 [expr {[image height $(image)] + 1}] -anchor n -text $title -font $font::(smallNormal) -tags icon($this)\
            ]                                                                                                   ;# place title below
            foreach {left top right bottom} [$canvas bbox icon($this)] {}
            set x [expr {round(($right - $left) / 2.0)}]
            $canvas move $image $x 0
            $canvas move $text $x 0
            if {!$disabled} {
                $canvas bind icon($this) <Double-Button-1> "uplevel #0 $command"
                $canvas bind icon($this) <ButtonPress-1> "canvasWindowManager::icon::select $this %x %y"
                $canvas bind icon($this) <Button1-Motion> "canvasWindowManager::icon::move $this %x %y"
            }
            set ($this,moved) 0                                            ;# whether the icon was moved by the user in its lifetime
            set ($this,canvas) $canvas
        }

        proc ~icon {this} {
            $($this,canvas) delete icon($this)
        }

        proc select {this x y} {
            set (xLast) $x
            set (yLast) $y
        }

        proc move {this x y} {
            set width [winfo width $($this,canvas)]
            set height [winfo height $($this,canvas)]
            if {$x < 0} {set x 0}                                                                 ;# stay inside visible canvas area
            if {$y < 0} {set y 0}
            if {$x > $width} {set x $width}
            if {$y > $height} {set y $height}
            $($this,canvas) move icon($this) [expr {$x - $(xLast)}] [expr {$y - $(yLast)}]
            set (xLast) $x
            set (yLast) $y
            set ($this,moved) 1
        }

    }

}
