# copyright (C) 1997-2004 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: entrychk.tcl,v 2.8 2004/01/01 11:39:06 jfontain Exp $


proc setupEntryValidation {path scripts {mode key}} {
    if {[llength $scripts] == 0} return
    $path configure -validate $mode -invalidcommand bell
    foreach script $scripts {
        if {[info exists command]} {
            append command &&
        } else {
            set command "expr \{"
        }
        append command "\[$script\]"
    }
    append command \}
    $path configure -validatecommand $command
}

proc checkUnsignedInteger {string} {
    set string [string trimleft $string 0]                                                             ;# possibly remove leading 0s
    set double $string.0         ;# used instead of double() which gives: double(2147483648) = -2147483648.0 instead of 2147483648.0
    return [expr {[regexp {^[\d]*$} $string] && [string is integer $string] && ($double <= $global::integerMaximum)}]
}

proc checkMaximumLength {length string} {
    return [expr {[string length $string] <= $length}]
}
