# copyright (C) 1997-2004 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

# $Id: help.tcl,v 2.28 2004/01/01 11:39:06 jfontain Exp $

namespace eval help {

    variable nameAndVersion \
"moodss
Modular Object Oriented Dynamic SpreadSheet
version $global::applicationVersion"

    variable description {
Copyright  1997-2004 Jean-Luc Fontaine (jfontain@free.fr). All rights reserved.

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License version 2 as published by the Free Software Foundation (at http://www.gnu.org).

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.


This software uses the following extensions:

    - the BLT library by George Howlett
    - the tkTable widget by Jeffrey Hobbs
    - the MIME/SMTP library (part of tcllib) by Marshall Rose
    - the BWidget widget set
    - the tclXML and tclDOM libraries from Zveno
    - the Tcl HTML library from Sun Microsystems
    - the stooop OO (part of tcllib) extension by me
    - the scwoop widget library by me
    - the tkpiechart widget by me
    - the SQLite library (included in the moodss rpm package)

The tclXML and tclDOM libraries by Zveno are made available under the following license terms:

Copyright  1998-2002 Zveno Pty Ltd (http://www.zveno.com/).
Zveno makes this software available free of charge for any purpose. Copies may be made of this software but all of this notice must be included on any copy.
The software was developed for research purposes only and Zveno does not warrant that it is error free or fit for any purpose.  Zveno disclaims any liability for all claims, expenses, losses, damages and costs any user may incur as a result of using, copying or modifying this software.

The Tcl HTML library developped by Sun Microsystems is made available under the following license terms:

Sun Microsystems, Inc.  The following terms apply to all files associated with the software unless explicitly disclaimed in individual files.
The authors hereby grant permission to use, copy, modify, distribute, and license this software and its documentation for any purpose, provided that existing copyright notices are retained in all copies and that this notice is included verbatim in any distributions. No written agreement, license, or royalty fee is required for any of the authorized uses. Modifications to this software may be copyrighted by their authors and need not follow the licensing terms described here, provided that the new terms are clearly indicated on the first page of each file where they apply.
IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT. THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
RESTRICTED RIGHTS: Use, duplication or disclosure by the government is subject to the restrictions as set forth in subparagraph (c) (1) (ii) of the Rights in Technical Data and Computer Software Clause as DFARS 252.227-7013 and FAR 52.227-19.
    }

}

proc aboutDialogBox {} {
    set dialog [new dialogBox . -buttons x -default x -title {moodss: About} -x [winfo pointerx .] -y [winfo pointery .]]
    set frame [frame $widget::($dialog,path).frame]
    set text [new scroll text $frame -horizontal 0]
    composite::configure $dialog -deletecommand "delete $text"                       ;# delete objects not managed by the dialog box
    $composite::($text,scrolled,path) insert end $help::description
    $composite::($text,scrolled,path) configure -state disabled -borderwidth 0 -font $font::(mediumNormal) -wrap word -height 20\
        -padx 10 -cursor {}                                                                                 ;# hide insertion cursor
    grid columnconfigure $frame 0 -weight 1
    grid rowconfigure $frame 0 -weight 0
    grid rowconfigure $frame 1 -weight 0
    grid rowconfigure $frame 2 -weight 1
    grid [label $frame.name -text $help::nameAndVersion] -row 0
    grid [frame $frame.separator -relief sunken -borderwidth 1 -height 2] -row 1 -sticky ew
    grid $widget::($text,path) -row 2 -sticky nsew
    dialogBox::display $dialog $frame
}

proc linkedHelpWidgetTip {path} {
    return [new widgetTip\
        -path $path\
        -text {display the relevant section in the general help window (may take some time if the window is not yet opened)}\
    ]
}
