/*
 * libmoocallstack XS binding
 * 
 * Copyright 2002-2003 by Joey Hess <joey@mooix.net>
 * under the terms of the modified BSD license given in full in the file
 * COPYRIGHT.
 */   

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <moocallstack.h>

typedef struct callstack * Mooix_CallStack;
typedef callstack_iter * Mooix_CallStack_Iter;

MODULE = Mooix::CallStack::Iter PACKAGE = Mooix::CallStack::Iter PREFIX = callstack_iter_

PROTOTYPES: ENABLE

Mooix_CallStack_Iter
callstack_iter_start()

uid_t
callstack_iter_next(Mooix_CallStack_Iter iter)

void
callstack_iter_DESTROY(Mooix_CallStack_Iter iter)
CODE:
	callstack_iter_end(iter);

MODULE = Mooix::CallStack PACKAGE = Mooix::CallStack PREFIX = callstack_

PROTOTYPES: ENABLE

int
callstack_is_subset(Mooix_CallStack subset, Mooix_CallStack superset)

int
callstack_dedup(Mooix_CallStack stack)

Mooix_CallStack
callstack_extend(Mooix_CallStack stack, Mooix_CallStack extention)

char *
callstack_file(uid_t uid)

void
callstack_free(Mooix_CallStack stack)

Mooix_CallStack
callstack_invert(Mooix_CallStack stack)

Mooix_CallStack
callstack_load(const char * filename, int onlytop=0)

Mooix_CallStack
callstack_fromfd(FILE *in, int onlytop=0)
	
Mooix_CallStack
callstack_push(Mooix_CallStack stack, int objectfd, char * method)

=note

Would be better if callstack_push above could take undef for stack.
It can in C, but XS adds too much type checking.

It really also needs to take a filehandle and convert that to a fd number.

=cut
	
Mooix_CallStack
callstack_copy(Mooix_CallStack stack)

Mooix_CallStack
callstack_new(char * object, char * method)
CODE:
	int i = open(object, O_RDONLY);
	RETVAL = callstack_push(NULL, i, method);
	close(i);
	
void
callstack_dump(Mooix_CallStack stack, FILE * out)
	
int
callstack_save(uid_t dest, Mooix_CallStack stack)

int
callstack_size(Mooix_CallStack stack)

int
callstack_unlink(uid_t uid)

=note

Field accessors

=cut

dev_t
callstack_dev(Mooix_CallStack stack, dev_t val = NO_INIT)
PROTOTYPE: $$;$
CODE:
	if (items > 1)
		stack->dev = val;
	RETVAL = stack->dev;
OUTPUT:
	RETVAL

ino_t
callstack_inode(Mooix_CallStack stack, ino_t val = NO_INIT)
PROTOTYPE: $$;$
CODE:
	if (items > 1)
		stack->inode = val;
	RETVAL = stack->inode;
OUTPUT:
	RETVAL

char *
callstack_method(Mooix_CallStack stack, char * val = NO_INIT)
PROTOTYPE: $$;$
CODE:
	if (items > 1)
		stack->method = val;
	RETVAL = stack->method;
OUTPUT:
	RETVAL

int
callstack_boundry(Mooix_CallStack stack, int val = NO_INIT)
PROTOTYPE: $$;$ 
CODE:
	if (items > 1)
		stack->boundry = val ? 1 : 0;
	RETVAL = stack->boundry;
OUTPUT:
	RETVAL

Mooix_CallStack
callstack_next(Mooix_CallStack stack, Mooix_CallStack val = NO_INIT)
PROTOTYPE: $$;$
CODE:
	if (items > 1)
		stack->next = val;
	RETVAL = stack->next;
OUTPUT:
	RETVAL

