#!/usr/bin/perl

=head1 NAME

Mooix::Root - easy access to mooix core objects

=head1 SYNOPSIS

 use Mooix::Root;
 $Mooix::Root->system->sessionmanager->avatars->list;
 
=head1 DESCRIPTION

This module makes it very easy to get at core mooix objects, no matter
where the moo's tree of system objects might be installed. It simply
makes a $Mooix::Root object, which corresponds to mooix:/var/lib/mooix or
wherever the root of the object tree is. Note: That location is set at
build time, for reasons of speed.

=cut

package Mooix::Root;
use Mooix::Thing;
my $mooroot = "/var/lib/mooix"; # MOOROOT SET AT BUILD TIME
$Mooix::Root = Mooix::Thing->get($mooroot);
