"""debug.py
This module implements debugging functions.

This file is part of the Python 2.2.1+ binding for mooix
Copyright (c)2002,2003 Nicholas D. Borko.  All Rights Reserved.
The author can be reached at nick@dd.revealed.net

The Python binding for mooix is free software; you can redistribute
it and/or modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

The Python binding for mooix is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with mooix; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA."""

import os.path

# set this to get copious debugging information
DEBUG = False

if DEBUG:

    import inspect, os, sys

    os.environ['MOOIX_DEBUG'] = "5"
    def debug(msg):
        """debug(message)

        message: string

        Produce debugging information on stderr."""

        frame = inspect.stack()[1]
        sys.stderr.write('[%12s,%12s:%4d] %s\n' %
                         (frame[3], os.path.basename(frame[1]), frame[2], msg))

else:

    def debug(msg): pass

__all__ = [ 'debug' ]
