/* Demo program, cat out the given stack. */

#include <stdio.h>
#include <stdlib.h>
#include "moocallstack.h"

int main (int argc, char **argv) {
	char *fn;
	struct callstack *stack;
	
	if (argc == 1) {
		/* Useful when testing with fuzz. */
		stack = callstack_fromfd(stdin, 0);
	}
	else if (argc == 2) {
		stack = callstack_load(argv[1], 0);
	}
	else {
		fprintf(stderr, "Usage: %s file\n", argv[0]);
		exit(1);
	}
	
	callstack_dump(stack, stdout);
	exit(0);
}
