/*
 * Used by real.h and real.c. This is not C code.
 *
 * Copyright 2001-2003 by Joey Hess <joey@mooix.net>
 * under the terms of the modified BSD license given in full in the
 * file COPYRIGHT.
 *    
 */ 

/* mips is screwy and for some reason trying to call the RTLD_NEXT Function
 * calls the one provided by this library for an infinite loop. This is a
 * hack around that problem. */
#if defined(GENERATE_FUNCTIONS) && #cpu (mips)
#warning Using MIPS SYS_open syscall workaround
#include <unistd.h>
#include <sys/syscall.h>
int real_open (const char *name, int flags, mode_t mode) {
	return syscall(SYS_open, name, flags, mode);
}
#else
func(-1, int, open, const char *name, int flags, mode_t mode)
args(name, flags, mode)
#endif
func(NULL, FILE *, fopen, const char *path, const char *mode)
args(path, mode)
func(-1, mode_t, umask, mode_t themask)
args(themask)
func(-1, int, chdir, const char *path)
args(path)
func(-1, int, fchdir, int fd)
args(fd)
func(-1, int, unlink, const char *pathname)
args(pathname)
func(-1, int, symlink, const char *oldpath, const char *newpath)
args(oldpath, newpath)
func(-1, int, mkdir, const char *pathname, mode_t mode)
args(pathname, mode)
func(-1, int, rmdir, const char *pathname)
args(pathname)
func(-1, int, chmod, char *path, mode_t mode)
args(path, mode)
func(-1, int, rename, const char *oldpath, const char *newpath)
args(oldpath, newpath)
func(-1, int, kill, pid_t pid, int sig)
args(pid, sig)
func(-1, int, fork)
args()
func(-1, int, execve, const char *filename, char * const argv[], char * const envp[])
args(filename, argv, envp)
#include <sys/types.h>
#include <sys/socket.h>
func(-1, int, connect, int sockfd, const struct sockaddr *serv_addr, socklen_t addrlen)
args(sockfd, serv_addr, addrlen)
