#ifndef __MOOIX_H
#define __MOOIX_H

/* A list of command types. */
enum command_type {
	/* These commands must be run by connecting to the main moo daemon. */
	command_execv,
	command_kill,
	command_destroy,
	/* These commands are run by connecting to a subsidiary moo daemon. */
	command_open,
	command_unlink,
	command_symlink,
	command_mkdir,
	command_rmdir,
	command_chmod,
	command_rename,
	command_connect,
	/* Must be last. */
	command_last
};

/* Structure used to hold command data. */
struct command_t {
	unsigned int len;
	enum command_type type;
	unsigned int argc;
	char **argv;
	char *buf; /* argv points to bits of this buffer */
};

/* Structure used to hold command result codes. */
struct result_t {
	int err;
	int ret;
};

/* Magic inherited fd; points to object directory. */
#define THISFD 42

#endif /* __MOOIX_H */
