/* Only autolook if moved to a different room. */

#include <moomethod.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

int main () {
	param *p;
	object *loc, *oldloc = NULL, *tmploc;
	int bufsize = 0, dirlen = 0;
	char *dir = NULL;
	char *buf;
	char *verb_params[2];
	double hp;
	char *hp_s;
	FILE *f;
	
	methinit();
	
	while ((p = getparam())) {
		if (strcmp(p->name, "oldloc") == 0) {
			oldloc = derefobj(p->value);
		}
		else {
			freeparam(p);
		}
	}
	
	/* Check hitpoints; don't autolook if unconcious. */
	hp_s = getfield(fieldfile(getobj("."), "hitpoints"));
	hp = strtod(hp_s, NULL);
	if (hp <= 0) {
		exit(0);
	}
	
	loc = getobj("location");
	tmploc = getobj("location/location");
	if (oldloc && tmploc) {
		while (tmploc && statobj(tmploc)) {
			if (objcmp(oldloc, tmploc) == 0)
				exit(0); /* optimization */
			
			if (! dir) {
				dirlen = strlen(tmploc->dir);
				bufsize = dirlen + 4 * strlen("/location");
				dir = malloc(bufsize);
				strcpy(dir, tmploc->dir);
			}
			
			dirlen += strlen("/location");
			if (dirlen >= bufsize) {
				bufsize *= 2;
				dir = realloc(dir, bufsize);
			}
			strcat(dir, "/location");
		
			tmploc = getobj(dir);
		}

		free(dir);
		dir=NULL;
		dirlen=0;
	}
	
	while (oldloc && statobj(oldloc)) {
		if (objcmp(loc, oldloc) == 0)
			exit(0);
		
		if (! dir) {
			dirlen = strlen(oldloc->dir);
			bufsize = dirlen + 4 * strlen("/location");
			dir = malloc(bufsize);
			strcpy(dir, oldloc->dir);
		}
		
		dirlen += strlen("/location");
		if (dirlen >= bufsize) {
			bufsize *= 2;
			dir = realloc(dir, bufsize);
		}
		strcat(dir, "/location");
		
		oldloc = getobj(dir);
	}
	
	buf = malloc(strlen("mooix:") + strlen(getenv("THIS")) + 1);
	strcpy(buf, "mooix:");
	strcat(buf, getenv("THIS"));
	verb_params[0] = "avatar";
	verb_params[1] = buf;
	verb_params[2] = NULL;
	f = runmethod(loc, "look_verb", verb_params);
	fgetvalue(f);
	
	exit(0);
}
