#include <string.h>
#include <sys/file.h>
#include <stdio.h>
#include <stdlib.h>
#include <moomethod.h>

int main (int argc, char **argv) {
	param *p;
	FILE *f;
	object *obj = NULL, *owner;
	char *field, *s;
	double ownermass, objmass, maxweight;
	
	methinit();
	while ((p = getparam())) {
		if (strcmp(p->name, "object") == 0) {
			obj = derefobj(p->value);
		}
	}
	
	if (! obj) {
		fprintf(stderr, "object field required\n");
		exit(1);
	}

	/* See if this object is too heavy to pick up. */
	owner = getobj("owner");
	if ((field = fieldfile(owner, "maxweight")) && 
	    (s = getfield(field)) &&
	    (maxweight = atof(s)) &&
	    
            (field = fieldfile(obj, ".mass")) &&
	    (s = getfield(field)) &&
	    (objmass = atof(s))) {
			ownermass = 0;
			if ((field = fieldfile(owner, ".mass")) &&
			    (s = getfield(field))) {
				ownermass = atof(s);
			if (objmass + ownermass > maxweight) {
				/* Yes, too heavy. */
				exit(0);
			}
		}
	}

	f = fopen("list", "a");
	if (! f) {
		perror("open list");
		exit(1);
	}

	/* lock to guard against races */
	if (flock(fileno(f), LOCK_EX) != 0) {
		perror("flock");
		exit(1);
	}

	fprintf(f, "mooix:%s\n", obj->dir);
	fclose(f);
	
	printf("mooix:%s\n", obj->dir);
	exit(0);
}
