#include <sys/types.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <moomethod.h>
#include <moocallstack.h>

int main (int argc, char **argv) {
	param *p;
	int sig = 0;
	signed int id = 0;
	char *method = NULL;
	
	methinit();
	while ((p = getparam())) {
		if (strcmp(p->name, "with") == 0) {
			sig = atoi(p->value);
			freeparam(p);
		}
		else if (strcmp(p->name, "id") == 0) {
			/* libmooproxy wants a negative number to do a
			 * per-uid kill */
			id = -1 * atoi(p->value);
			freeparam(p);
		}
		else if (strcmp(p->name, "method") == 0) {
			method = p->value;
		}
		else {
			freeparam(p);
		}
	}
	
	/* Tell libmooproxy to proxy the kills. */
	setenv("MOOIX_NONSTANDARD", "1", 1);

	if (method) {
		/* Scan the callstacks for a matching method. */
		struct callstack *s;
		uid_t uid;
		char *p;
		int num_found = 0;
		callstack_iter *i = callstack_iter_start();
		while ((uid = callstack_iter_next(i))) {
			s = callstack_load(callstack_file(uid), 0); /* only top */
			if (s) {
				/* Find basename of method. */
				p = strrchr(s->method, '/');
				if (p)
					p++;
				else
					p = s->method;

				if (strcmp(p, method) == 0) {
					if (kill(-1 * uid, sig) == 0)
						num_found++;
				}
			}
		}
		callstack_iter_end(i);
		printf("%i\n", num_found);;
	}
	else {
		printf("%i\n", (kill(id, sig) == 0));
	}
	return(0);
}
