/* Clear the screen. */

#include <sys/file.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <moomethod.h>

int main (int argc, char **argv) {
	int tty;
	
	methinit();

	/* The tty is locked for read and write, since clear might do both. */
	if ((tty = open("tty", O_RDWR)) == -1) {
		perror("open tty for write");
		exit(1);
	}
	if (flock(tty, LOCK_EX) != 0) {
		perror("flock tty");
		exit(1);
	}
	
	/* Reconnect tty to stdin and stdout. */
	dup2(tty, 0);
	dup2(tty, 1);
	
	/* Set terminal type from term field. */
	setenv("TERM", getfield("term"), 1);
	
	/* Actual screen clearing here. I specify the full patch because
	 * it'd suck if this program accidentially re-execed itself. */
	system("/usr/bin/clear");
	exit(0);
}
