#!/usr/bin/perl -T
# This is a helper program used by the moo's password command to actually
# change the password of a user. It expects a unix username as its sole
# parameter; and talks with whoever calls it in a machine-readable way.

# This is set when run inside the moo, and perl's taint code chokes on
# stuff Mooix::Thing does if it's set.
BEGIN { delete $ENV{THIS} };
# Make %ENV safer
delete @ENV{qw(IFS CDPATH ENV BASH_ENV)};   

use warnings;
use strict;
use Mooix::Thing;
use Mooix::Conf;
use Authen::PAM;

sub abort ($) {
	print STDERR shift()."\n";
	exit 2;
}

my $user = shift;
if (@ARGV || ! $user) {
	abort "exactly one argument, please";
}

if ($user =~ /^(\Q$Mooix::Conf::field{moouserprefix}\E[a-z0-9]+)$/) {
	# detaint
	$user = $1;
}
else {
	abort "not a moo username";
}

$|=1;

sub convers {
	my @res;
	while (@_) {
		my $code = shift;
		my $msg = shift;
		my $ans = "";

		if ($code == PAM_PROMPT_ECHO_ON) {
			print "prompt: $msg\n";
		}
		elsif ($code == PAM_PROMPT_ECHO_OFF) {
			print "password: $msg\n";
		}
		else {
			print "write: $msg\n";
		}
		$ans = <>;
		chomp $ans;
		push @res, PAM_SUCCESS, $ans;
	}
	push @res, PAM_SUCCESS;
	return @res;
}

my $pamh = new Authen::PAM('passwd', $user, \&convers);
my $res = $pamh->pam_chauthtok;
if ($res != PAM_SUCCESS()) {
	exit 1;
}
exit 0;
