/*
 * Moo method runner. Allows the entry user to run methods from outside the
 * moo. The key to this very simple program is linking directly with
 * libmooproxy.so. Thus, the exec() call is actually proxied into mood.
 *
 * Previous version of this program included a full duplicate of the
 * proxied exec mood communication code; this is much much better. :-)
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include "libmooproxy.h"

char *findmethod (char *methname) {
	FILE *searcher;
	char *ret = malloc(1024 * sizeof(char));
	char *command = malloc(sizeof(char) * (11 + strlen(methname)));
	sprintf(command, "findfield %s", methname);
	searcher = popen(command, "r");
	ret = fgets(ret, 1024, searcher);
	if (ret && strlen(ret) > 0)
		ret[strlen(ret) - 1] = '\0'; /* chomp */
	pclose(searcher);
	return ret;
}

int main (int argc, char **argv) {
	char *method;
	int i;

	if (argc < 2) {
		fprintf(stderr, "Usage: runmeth method [params]\n");
		exit(1);
	}
	
	method = findmethod(argv[1]);
	if (method == NULL) {
		fprintf(stderr, "runmeth: method not found\n");
		exit(1);
	}
	
	/* Shift arguments left one, so they can be NULL-terminated for
	 * execv call. */
	for (i = 0; i < argc - 1; i++) {
		argv[i] = argv[i + 1];
	}
	argv[argc - 1] = NULL;
	
	/* If the wrong user is trying to connect, mood rather rudly hangs
	 * up before libmooproxy is done talking to it, which results in a
	 * sigpipe. Ignoring the sigpipe lets libmooproxy set errno
	 * properly, so the user can see what went wrong. */
	signal(SIGPIPE, SIG_IGN);
	/* Letting a ctrl-c kill this process is bad because the method run
	 * can continue running, and reading from stdin, which is very
	 * confusing. */
	signal(SIGINT, SIG_IGN);
	/* Force proxying on so this exec gets proxied. */
	mooix_proxy_enable(1);
	execv(method, argv); /* proxied via mood */
	perror("runmeth");
	exit(1);
}
