Summary: Powerful modular monitoring service
Name: moomps
Version: 4.6
Release: 0.fdr.1
Epoch: 0
Group: Applications/System
Source: http://download.sourceforge.net/moodss/moomps-4.6.tar.bz2
URL: http://moodss.sourceforge.net/
License: GPL
BuildArchitectures: noarch
BuildRoot: %_tmppath/%name-%version-%release-root-%(%__id_u -n)
BuildRequires: tcl >= 0:8.3.1, %{_includedir}/tcl.h
Requires: moodss >= 0:19.7, tclx >= 0:8.2

%description
moomps (Modular Object Oriented Multi-Purpose Service) is a modular
monitoring daemon which sends alert emails or execute scripts when
predefined thresholds are crossed. It is also possible to store data
cell values history over time in a database (MySQL or ODBC). Uses
configuration files created by moodss so that any number of modules
can be used.

%prep
%setup -q

%build
%__make

%install
rm -rf $RPM_BUILD_ROOT
%__make ROOTDIR=$RPM_BUILD_ROOT install

%files
%defattr(-,root,root,-)
%doc documentation/COPYRIGHT documentation/moomps*.htm
%doc %_mandir/man1/moomps.*
%_sbindir/moomps
%dir %attr(0755,moomps,root) %_sysconfdir/moomps
%config(noreplace) %attr(0600,moomps,moomps) %_sysconfdir/moomps/rc
%config(noreplace) %_initrddir/moomps

%pre
# if not present, add moomps user, without home directory (even when upgrading):
if ! %_sbindir/usermod -l moomps moomps 2>/dev/null; then
    %_sbindir/useradd -M moomps -d %_sysconfdir/moomps -c 'moodss service'\
        -s '/sbin/nologin'
fi

%preun
if [ $1 = 0 ]; then                                               # uninstalling
    chkconfig --del moomps
    echo -n "(may fail if not running) "
    service moomps stop || :           # ignore error when daemon is not running
fi

%post
if [ $1 = 1 ]; then                                                 # installing
    chkconfig --add moomps
fi

%postun
if [ $1 = 0 ]; then                                               # uninstalling
    %_sbindir/userdel moomps
    rm -f %_var/run/moomps.pid %_sysconfdir/moomps/moomps.pid
else                                                                 # upgrading
    service moomps condrestart || :
fi

%clean
rm -rf $RPM_BUILD_ROOT


%changelog

* Tue Feb 22 2005 Jean-Luc Fontaine <jfontain@free.fr> 0:4.6-0.fdr.1
- 4.5 release
- in statistics table, added standard deviation column

* Sun Jan 2 2005 Jean-Luc Fontaine <jfontain@free.fr> 0:4.5-0.fdr.1
- 4.5 version

* Fri Dec 17 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:4.4-0.fdr.1
- 4.4 release

* Sun Nov 14 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:4.3-0.fdr.1
- 4.3 release

* Sun Oct 31 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:4.2.2-0.fdr.1
- removed program variable in init moomps script as rpmlint reported
  incoherent-subsys error
- capitalized summary

* Sat Oct 30 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:4.2.1-0.fdr.1
- restored compatibility with Tcl 8.3 core

* Sat Oct 23 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:4.2-0.fdr.1
- 4.2 version
- updated summary and description

* Sun Oct 17 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:4.1-0.fdr.1
- 4.1 version

* Tue Aug 17 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:4.0-0.fdr.1
- 4.0 version

* Sun May 30 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:3.2-0.fdr.1
- 3.2 version

* Sun Apr 25 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:3.1-0.fdr.1
- 3.1 version

* Sun Mar 14 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:3.0-0.fdr.1
- 3.0 version

* Thu Feb 12 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:2.20-0.fdr.1
- 2.20 version

* Sun Feb 8 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:2.19-0.fdr.1
- 2.19 version

* Sun Jan 11 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:2.18-0.fdr.2
- in build requirements, work around tcl-devel and tk-devel packages non
  existence in RH 8.0 and 9

* Sun Jan 11 2004 Jean-Luc Fontaine <jfontain@free.fr> 0:2.18-0.fdr.1
- 2.18 version

* Sun Dec 28 2003 Jean-Luc Fontaine <jfontain@free.fr> 0:2.17-0.fdr.1
- 2.17 version

* Wed Dec 24 2003 Jean-Luc Fontaine <jfontain@free.fr> 0:2.16-0.fdr.1
- 2.16 version

* Sat Nov 22 2003 Jean-Luc Fontaine <jfontain@free.fr> 0:2.15-0.fdr.1
- 2.15 version

* Sat Nov 15 2003 Jean-Luc Fontaine <jfontain@free.fr> 0:2.14-0.fdr.2
- require moodss (needed for its modules)
- conditional restart of daemon when upgrading

* Tue Nov 11 2003 Jean-Luc Fontaine <jfontain@free.fr> 0:2.14-0.fdr.1
- moved here from moodss spec file
