/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * usercontrol.h:
 *
 * Copyright 2007 Novell, Inc. (http://www.novell.com)
 *
 * See the LICENSE file included with the distribution for details.
 * 
 */

#ifndef __MOON_USERCONTROL_H__
#define __MOON_USERCONTROL_H__

#include <glib.h>

G_BEGIN_DECLS

#include "control.h"

//
// UserControl
//
/* @SilverlightVersion="2" */
/* @ContentProperty="Content" */
/* @Namespace=System.Windows.Controls */
class UserControl : public Control {
protected:
	virtual ~UserControl ();
	
public:
	/* @PropertyType=UIElement,ManagedAccess=Protected */
	static DependencyProperty *ContentProperty;
	
 	/* @GenerateCBinding,GeneratePInvoke */
	UserControl ();
	
	virtual Type::Kind GetObjectType () { return Type::USERCONTROL; }
	
	virtual void OnPropertyChanged (PropertyChangedEventArgs *args);
};

UIElement *user_control_get_content (UserControl *user_control);

G_END_DECLS

#endif /* __MOON_USERCONTROL_H__ */
