# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

"""
Test the wmd Resource provider
"""

from twisted.trial.unittest import TestCase, SkipTest

from elisa.core import common
from elisa.core.media_uri import MediaUri
try:
    from elisa.plugins.wmd.wmd_resource import WMDResource
except ImportError:
    WMDResource = None

from elisa.plugins.base.models.device import DevicesModel

class WMDMixin(object):
    """
    Base class that sets up the resource provider and patches the application
    and the bus
    """

    def setUp(self):
        if WMDResource is None:
            self._platform_check()

        self.supported_protocols = ('file', 'cdda', 'ipod')

        def created(resource):
            self.resource = resource

        # patch the application:
        class Dummy(object):pass

        class DummyBus(object):
            def __init__(self):
                self.messages = []
            def register(*args):
                pass
            def send_message(self, msg, sender):
                self.messages.append( msg )

        self.bus = DummyBus()

        self.app = common.application
        common.application = Dummy()
        common.application.bus = self.bus

        return WMDResource.create({}).addCallback(created)

    def _platform_check(self):
        import platform
        if platform.system().lower() != 'Windows':
            raise SkipTest("This test is only working on Windows")

    def tearDown(self):
        common.application = self.app
        return self.resource.clean()

class TestVolumeParsing(WMDMixin, TestCase):
    """
    Test the volume recognition system.

    These tests contain also print statements to display the detected devices because it is not
    predictable which hardware setup the test computer has.
    """

    def test_unfiltered(self):
        """
        test if all devices are found
        """
        # XXX: plug a usb hard disk in the test machine and see if it is displayed
        uri = MediaUri("volumes://localhost")
        model, dfr = self.resource.get(uri, None)
        self.assertTrue(isinstance(model, DevicesModel))
        for m in model.devices:
            self.assertTrue(m.protocol in self.supported_protocols)
            self.assertEqual(len(m.mount_point), 1)
            self.assertNotEqual(m.label, "")
            print "Found volume '%s' in '%s:' with protocol '%s'." % \
                                    (m.label, m.mount_point, m.protocol)

    def test_filtered(self):
        """
        test to find all devices with cdda
        """
        uri = MediaUri("volumes://localhost/?filter=cdda")
        model, dfr = self.resource.get(uri, None)
        self.assertTrue(isinstance(model, DevicesModel))
        for m in model.devices:
            self.assertTrue(m.protocol in self.supported_protocols)
            self.assertEqual(len(m.mount_point), 1)
            self.assertNotEqual(m.label, "")
            print "Found volume '%s' in '%s:' with protocol '%s'." % \
                                    (m.label, m.mount_point, m.protocol)
