/*
 *  interface.cpp
 *  
 *
 *  Created by Pat Schloss on 8/14/08.
 *  Copyright 2008 Patrick D. Schloss. All rights reserved.
 *
 */
 
#include "mothur.h"
#include "engine.hpp"
#include "mothurout.h"
#include "currentfile.h"

/**************************************************************************************************/

CommandFactory* CommandFactory::_uniqueInstance = 0;
MothurOut* MothurOut::_uniqueInstance = 0;
CurrentFile* CurrentFile::instance = 0;
/***********************************************************************/
volatile int ctrlc_pressed = 0;
void ctrlc_handler ( int sig ) {
	MothurOut* m = MothurOut::getInstance();
    ctrlc_pressed = 1;
	m->setControl_pressed(ctrlc_pressed);
	
	if (m->getExecuting()) { //if mid command quit execution, else quit mothur
		m->mothurOutEndLine(); m->mothurOut("quitting command...");  m->mothurOutEndLine();
	}else{
		m->mothurOut("quitting mothur");  m->mothurOutEndLine();
		exit(1);
	}
}
/***********************************************************************/
int main(int argc, char *argv[]){
	MothurOut* m = MothurOut::getInstance();
	try {
        CurrentFile* current = CurrentFile::getInstance();
        Utils util;
        bool createLogFile = true;
        
		signal(SIGINT, ctrlc_handler );
				
		#if defined NON_WINDOWS
			system("clear");
		#else
			system("CLS");
		#endif
		
		#ifdef MOTHUR_FILES
			string temp = MOTHUR_FILES; 
		
			//add / to name if needed
			string lastChar = temp.substr(temp.length()-1);
			if (lastChar != PATH_SEPARATOR) { temp += PATH_SEPARATOR; }
		
			temp = util.getFullPathName(temp);
			current->setDefaultPath(temp);
		#endif
        
        #ifdef LOGFILE_NAME
            string logfilename = LOGFILE_NAME;
            logfilename = util.getFullPathName(logfilename);
        
            m->appendLogBuffer("Using Static Logfile " + logfilename +  "\n");
        
            m->setLogFileName(logfilename, false);
            m->mothurOut("\n");
        #endif
        
        string releaseDate = "";
        #ifdef RELEASE_DATE
            releaseDate = RELEASE_DATE;
        #else
            string year, month, day;
            util.getCurrentDate(year, month, day);
            releaseDate = month + "/" + day + "/" + year;
        #endif
        
		//get releaseDate from Make
		 
		string mothurVersion = VERSION; 
		current->setReleaseDate(releaseDate);
		current->setVersion(mothurVersion);
		
		//will make the gui output "pretty"
		bool outputHeader = true;
		if (argc>1) {
            if (argc > 2) { //is one of these -q for quiet mode?
                if (argc > 3) { m->appendLogBuffer("[ERROR]: mothur only allows command inputs and the -q command line options.\n  i.e. ./mothur \"#summary.seqs(fasta=final.fasta);\" -q\n or ./mothur -q \"#summary.seqs(fasta=final.fasta);\"\n"); return 0; }
                else {
                    string argv1 = argv[1];
                    string argv2 = argv[2];
                    if ((argv1 == "--quiet") || (argv1 == "-q")) {
                        m->setQuietMode(true);
                        argv[1] = argv[2];
                    }else if ((argv2 == "--quiet") || (argv2 == "-q")) {
                         m->setQuietMode(true);
                    }else {
                        m->appendLogBuffer("[ERROR]: mothur only allows command inputs and the -q command line options.\n");
                        m->appendLogBuffer("[ERROR]: Unrecognized options: " + argv1 + " " + argv2 + "\n");
                        return 0;
                    }
                }
            }
		}
		
		if (outputHeader)  {
			//version
			#if defined NON_WINDOWS
				#if defined (__APPLE__) || (__MACH__)
					m->appendLogBuffer("Mac version\n\n");
				#else
					m->appendLogBuffer("Linux version\n\n");
				#endif
			#else
				m->appendLogBuffer("Windows version\n\n");
			#endif		
			
			#ifdef USE_READLINE
				m->appendLogBuffer("Using ReadLine\n\n");
			#endif
            
            #ifdef USE_BOOST
                m->appendLogBuffer("Using Boost\n\n");
            #endif
			
			#ifdef MOTHUR_FILES
				m->appendLogBuffer("Using default file location " + temp + "\n\n");
			#endif
			
			#ifdef BIT_VERSION
				m->appendLogBuffer("Running 64Bit Version\n\n");
			#else
				m->appendLogBuffer("Running 32Bit Version\n\n");
			#endif
			
			//header
			m->appendLogBuffer("mothur v." + mothurVersion + "\n");
			m->appendLogBuffer("Last updated: " + releaseDate + "\n");
			m->appendLogBuffer("by\n");
			m->appendLogBuffer("Patrick D. Schloss\n\n");
			m->appendLogBuffer("Department of Microbiology & Immunology\n\n");
			m->appendLogBuffer("University of Michigan\n");
			m->appendLogBuffer("http://www.mothur.org\n\n");
			m->appendLogBuffer("When using, please cite:\n");
			m->appendLogBuffer("Schloss, P.D., et al., Introducing mothur: Open-source, platform-independent, community-supported software for describing and comparing microbial communities. Appl Environ Microbiol, 2009. 75(23):7537-41.\n\n");
			m->appendLogBuffer("Distributed under the GNU General Public License\n\n");
			m->appendLogBuffer("Type 'help()' for information on the commands that are available\n\n");
			m->appendLogBuffer("For questions and analysis support, please visit our forum at https://www.mothur.org/forum\n\n");
			m->appendLogBuffer("Type 'quit()' to exit program\n\n");
		}
		
		m->setRandomSeed( (unsigned)time( NULL ) );
		
		Engine* mothur = NULL;
		bool bail = 0;
		string input;
 
		if(argc>1){
			input = argv[1];
			if (input[0] == '#') {
				m->appendLogBuffer("Script Mode\n\n");
				mothur = new ScriptEngine(argv[0], argv[1]);
			}else if ((input == "--version") || (input == "-v")) {
                createLogFile = false;
                string OS = "";
                //version
                #if defined NON_WINDOWS
                #if defined (__APPLE__) || (__MACH__)
                OS = "Mac ";
                #else
                OS = "Linux ";
                #endif
                
                #else
                OS = "Windows ";
                #endif
                
                #ifdef BIT_VERSION
                OS += "64Bit Version";
                #else
                OS += "32Bit Version";
                #endif
                
				cout << (OS + "\nMothur version=" + mothurVersion + "\nRelease Date=" + releaseDate + "\n\n");
				return 0;
                
            }else if ((input == "--help") || (input == "-h")) {
                createLogFile = false;
                m->appendLogBuffer("Script Mode\n\n");

                char* temp = new char[16];
                *temp = '\0'; strncat(temp, "#help();quit();", 15);
                
                argv[1] = temp;
                mothur = new ScriptEngine(argv[0], argv[1]);
			}else{
				m->appendLogBuffer("Batch Mode\n\n");
                mothur = new BatchEngine(argv[0], argv[1]);
			}
		}else{
			m->appendLogBuffer("Interactive Mode\n\n");
            mothur = new InteractEngine(argv[0]);
		}
		
		while(bail == 0)	{	bail = mothur->getInput();	}
		
		string newlogFileName = mothur->getLogFileName();
		        
        if (!createLogFile) { util.mothurRemove(newlogFileName); }
				
		if (mothur != NULL) { delete mothur; }
        
        int returnCode = 0;
        if (m->getNumErrors() != 0) { returnCode = 1; }
        m->closeLog();
        
		return returnCode;
	}
	catch(exception& e) {
		m->errorOut(e, "mothur", "main");
		exit(1);
	}
}

/**************************************************************************************************/

