/**********************************************************************
 *
 * ffmpeg.c
 *
 * This software is distributed under the GNU Public License version 2
 * See also the file 'COPYING'.
 *
 **********************************************************************/


#include <stdio.h>
#include <malloc.h>
#include <string.h>

#ifdef HAVE_FFMPEG

#include "ffmpeg.h"

void ffmpeg_init(void)
{
	avcodec_init();
	register_avcodec(&mpeg1video_encoder);
}

struct ffmpeg *ffmpeg_open(char *filename, unsigned char *y, unsigned char *u, unsigned char *v, int width, int height, int rate, int bps)
{
	AVCodec *codec;
	AVCodecContext *c;
	AVFrame *picture;
  
	struct ffmpeg *ffmpeg;
  
	if ((ffmpeg = malloc(sizeof(struct ffmpeg))) == NULL) return NULL;
	memset(ffmpeg, 0, sizeof(*ffmpeg));

	/* find the mpeg1 video encoder */
	codec = avcodec_find_encoder(CODEC_ID_MPEG1VIDEO);
	if (!codec) return NULL;

//	c = &ffmpeg->codec_context;
	c = avcodec_alloc_context();
	ffmpeg->c=c;
	picture = avcodec_alloc_frame();
	ffmpeg->picture=picture;

	/* put default values */
//	memset(c, 0, sizeof(*c));
//	avcodec_get_context_defaults(c);

	/* put sample parameters */
	c->bit_rate = bps; /* bit per second */

	/* resolution must be a multiple of two */
	c->width  = width;  
	c->height = height;

	/* frames per second */
	c->frame_rate = rate * FRAME_RATE_BASE;  /* default rate is only 5 frames per second */
	c->gop_size = 10; /* emit one intra frame every ten frames */
//	c->qmin = 3;
//	c->max_qdiff = 3;
//	c->qblur = 0.5;
//	c->qcompress = 0.5;
//	c->get_psnr = 0;
//	c->bit_rate_tolerance = bps;
//	c->me_method = 0;
///	c->flags = 0;
///	c->quality = 0;

	/* open it */
	if (avcodec_open(c, codec) < 0) {
		return NULL;
	}    
    
	if (!(ffmpeg->f = fopen(filename, "ab"))) {
		return NULL;
	}    
	/* alloc image and output buffer */

	ffmpeg->outbuf_size = width * height * 10; // large outbuf_buf
	if ((ffmpeg->outbuf = (UINT8*) malloc(ffmpeg->outbuf_size)) == NULL) return NULL;

	ffmpeg->picture->data[0] = y;
	ffmpeg->picture->data[1] = u;
	ffmpeg->picture->data[2] = v;
	ffmpeg->picture->linesize[0] = c->width;
	ffmpeg->picture->linesize[1] = c->width / 2;
	ffmpeg->picture->linesize[2] = c->width / 2;

	return ffmpeg;
}

void ffmpeg_close(struct ffmpeg *ffmpeg)
{
	/* add sequence end code to have a real mpeg file */
	ffmpeg->outbuf[0] = 0x00;
	ffmpeg->outbuf[1] = 0x00;
	ffmpeg->outbuf[2] = 0x01;
	ffmpeg->outbuf[3] = 0xb7;
	fwrite(ffmpeg->outbuf, 1, 4, ffmpeg->f);
	fclose(ffmpeg->f);
	free(ffmpeg->outbuf);
	avcodec_close(ffmpeg->c);
	free(ffmpeg->c);
	free(ffmpeg->picture);
	free(ffmpeg);
}

void ffmpeg_put_image(struct ffmpeg *ffmpeg) 
{
	int out_size;

	out_size = avcodec_encode_video(
	    ffmpeg->c, 
	    ffmpeg->outbuf, 
	    ffmpeg->outbuf_size, 
	    ffmpeg->picture);

	fwrite(ffmpeg->outbuf, 1, out_size, ffmpeg->f);
}

#endif /* HAVE_FFMPEG */
