/* 
 * Motion Eye video4linux application
 *
 * Copyright (C) 2001-2002 Stelian Pop <stelian@popies.net>
 *
 * Copyright (C) 2001-2002 Alcve <www.alcove.com>
 *
 * Copyright (C) 2000 Andrew Tridgell <tridge@valinux.com>
 *
 * Earlier work by Werner Almesberger, Paul `Rusty' Russell and Paul Mackerras.
 * 
 * Some parts borrowed from various video4linux drivers, especially
 * bttv-driver.c and zoran.c, see original files for credits.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MOTIONEYE_H_
#define _MOTIONEYE_H_

typedef unsigned char u8;
typedef unsigned u32;
typedef unsigned short u16;

/* extern prototypes */

void yuv_convert(u8 *buf, u8 *rgb, int xsize, int ysize);
void display_rgb(u8 *rgb, int width, int height, char *name);

void avi_start(int fd);
void avi_add(int fd, u8 *buf, int size);
void avi_end(int fd, int width, int height, int fps);

#endif
