/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <string.h>
#include <stdio.h> 

#include <qstring.h>
#include <qtextbrowser.h>
#include <qaction.h>
#include <qstatusbar.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <qwidgetstack.h>
#include <qlistview.h>
#include <qtoolbar.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qsettings.h>
#include <qurloperator.h>

#include "form1.h"
#include "phoneman.h"
#include "custmsg.h"
#include "frmfilemanager.h"
#include "frmseemeditor.h"
#include "frmjava.h"
#include "frmconfig.h"
#include "appconfig.h"

Form1::Form1(QWidget *parent, const char *name)
		: Form1_base(parent, name)
{
	qDebug("Form1");
	
	myCfg= new appConfig(this,"myCfg");
	phone=new PhoneMan(this, "phone");
	wasMode=0;
	enableAutoConnect=1;	
	
	tmpURL=new QUrlOperator("file:/tmp/");
	tmpURL->mkdir("moto4lin");
	
	connect(phone, SIGNAL(postMsg(int, const QString& )), this, SLOT(onPostMsg(int, const QString& )));
	connect(phone, SIGNAL(statusChanged(int)), this, SLOT(onStatusChanged(int)));
	connect(phone, SIGNAL(modeChanged(int)), this, SLOT(onModeChanged(int)));
	connect(phone, SIGNAL(nfoDriveName(const QString& )), this, SLOT(onNfoDriveName(const QString& )));
	connect(phone, SIGNAL(nfoFileCount(int )), this, SLOT(onNfoFileCount(int )));
	connect(phone, SIGNAL(nfoFreeSpace(long )), this, SLOT(onNfoFreeSpace(long )));
	connect(phone, SIGNAL(nfoPhoneModel(const QString& )), this, SLOT(onNfoPhoneModel(const QString& )));
	connect(phone, SIGNAL(nfoProgress(int )), this, SLOT(onNfoProgress(int )));
	// 	connect(phone, SIGNAL(), this, SLOT());
	// 	connect(phone, SIGNAL(), this, SLOT());
	// 	connect(phone, SIGNAL(), this, SLOT());
	// 	connect(phone, SIGNAL(), this, SLOT());
	fileManager=new frmFileManager(this, phone, myCfg, "file Manager");
	wgMode->addWidget(fileManager,1);

	seemEditor=new frmSeemEditor(this, phone, "seem Editor");
	wgMode->addWidget(seemEditor, 2);
	
	java=new frmJava(this, phone, myCfg, "Java Manager");
	wgMode->addWidget(java, 3);

	lblStatus=new QLabel(statusBar(), "Status");
	statusBar()->addWidget(lblStatus,1);

	lblMode=new QLabel(statusBar(), "Mode");
	statusBar()->addWidget(lblMode,1);

	lblPhoneModel=new QLabel(statusBar(),"Model:");
	statusBar()->addWidget(lblPhoneModel,1);

	lblDriveName=new QLabel(statusBar(),"Drive:");
	statusBar()->addWidget(lblDriveName,1);

	lblFileCount=new QLabel(statusBar(),"FileCount");
	statusBar()->addWidget(lblFileCount,1);

	lblFreeSpace=new QLabel(statusBar(),"Free:");
	statusBar()->addWidget(lblFreeSpace,1);


	progressBar=new QProgressBar(this,"progressBar");
	progressBar->setMaximumHeight(lblPhoneModel->height());
	progressBar->setProgress(0);
	progressBar->setTotalSteps(0);

	statusBar()->addWidget(progressBar,1);

	loadConfig();
	
	updateStatus();
	connect_tmp=0;

	setWorkMode(MODE_FILEMANAGER);
	setCaption("moto4lin CVS");
}

Form1::~Form1()
{
	myCfg->saveConfig();
}

void Form1::onPostMsg(int style, const QString &s)
{
	QString msg;
	switch (style)
	{
		case MSGSTYLE_DEBUG: msg=QString("<FONT COLOR=GRAY><B>[debug]</B> %1</FONT>").arg(s); break;
		case MSGSTYLE_ERROR: msg=QString("<FONT COLOR=RED><B>[error]</B> %1</FONT>").arg(s); break;
		case MSGSTYLE_INFO: msg=QString("<FONT COLOR=BLUE><B>[info]</B> %1</FONT>").arg(s); break;
		default: msg=QString("<FONT COLOR=BLACK> %1</FONT>").arg(s);

	}
	txtLog->append(msg);
}

void Form1::doactConnect(bool t)
{
	qDebug("doActConnect");

	if (connect_tmp) return;

	int st=phone->getState();
	if ((t && (st!=CONNECT_NONE)) || (!t && (st==CONNECT_NONE))) return;

	if (st==CONNECT_NONE)
		phone->openPhone();
	else
		phone->closePhone();

	connect_tmp=1;
	actConnect->setOn(st!=CONNECT_NONE);
	connect_tmp=0;
	// 	if (!t) actDisconnect->setOn(1);
}

void Form1::onStatusChanged(int status)
{
	// 	progressBar->setTotalSteps(100);
	connect_tmp=1;
	actConnect->setOn(status!=CONNECT_NONE);
	connect_tmp=0;
	updateStatus();
}

void Form1::onModeChanged(int mode)
{
	QString s;
	switch (mode)
	{
		case PHONE_NONE: s="NONE"; break;
		case PHONE_AT: s="AT"; break;
		case PHONE_P2K: s="P2K"; break;
	}
	lblMode->setText(tr("Mode: %1").arg(s));
	if ((mode!=PHONE_NONE) && (!wasMode) && (myCfg->cfgAutoConnect) && (enableAutoConnect)) 
		phone->openPhone();
	wasMode=mode;
}

void Form1::updateStatus()
{
	QString s;
	int st=phone->getState();
	if (st==CONNECT_NONE)
		s=tr("disconnected");
	else
		s=tr("connected");
	lblStatus->setText(tr("Status: %1").arg(s));
	if (st==CONNECT_NONE)
	{
		onNfoDriveName("n/a");
		onNfoFileCount(-1);
		onNfoFreeSpace(-1);
		onNfoPhoneModel("n/a");
	}
	else
		phone->getInfo((myCfg->cfgLoadList) ? 1 : 0);
}

void Form1::onNfoPhoneModel(const QString &s)
{
	lblPhoneModel->setText(tr("Model: %1").arg(s));
}

void Form1::onNfoDriveName(const QString &s)
{
	lblDriveName->setText(tr("Drive: %1").arg(s));
}

void Form1::onNfoFileCount(int cnt)
{
	QString s;
	if (cnt>=0) s=QString("%1").arg(cnt); else s="n/a";
	lblFileCount->setText(tr("Files: %1").arg(s));
}

void Form1::onNfoFreeSpace(long space)
{
	QString s;
	if (space>=0) s=tr("%1 kb").arg(space/1024); else s="n/a";
	lblFreeSpace->setText(tr("Free Space: %1").arg(s));
}

void Form1::onNfoProgress(int pb)
{
	if (pb<0)
	{
		progressBar->setTotalSteps(0);
	}
	else
	{
		progressBar->setProgress(pb, 100);
	}
}

void Form1::doactReboot()
{
	phone->rebootPhone();
}

void Form1::doactSuspend()
{
	phone->suspendPhone();
}

void Form1::setWorkMode(int mode)
{
	wgMode->raiseWidget(mode);
}

void Form1::setModeFileManager(bool m)
{
	if (!m) return;
	setWorkMode(MODE_FILEMANAGER);
}

void Form1::setModeSeemEditor(bool m)
{
	if (!m) return;
	setWorkMode(MODE_SEEMEDITOR);
}

void Form1::setModeJava(bool m)
{
	if (!m) return;
	setWorkMode(MODE_JAVA);
}

void Form1::doactAbout()
{
	QMessageBox::about(this, "About moto4lin", "<B>moto4lin CVS</B><BR><BR>"
	                   "Copyright (C) 2005 by Dmitry Nezhevenko (dionua@users.sf.net)<BR><BR>"
	                   "Thanks to Vilko for P2k Protocol description"
	                  );
}

void Form1::doactAboutQT()
{
	QMessageBox::aboutQt(this);
}

void Form1::loadConfig()
{
	myCfg->loadConfig();
	phone->setDevice(myCfg->cfgACMdevice);
	phone->setATconfig(myCfg->cfgATvendor, myCfg->cfgATproduct);
	phone->setP2kconfig(myCfg->cfgP2Kvendor, myCfg->cfgP2Kproduct);
}

void Form1::doactPreferences()
{
	frmConfig f1(phone, this, "frmConfig");
	
	
	/*char cfgACMdevice[256];
	unsigned int cfgATvendor;
	unsigned int cfgATproduct;
	unsigned int cfgP2Kvendor;
	unsigned int cfgP2Kproduct;
	char cfgAutoConnect;
	char cfgAutoUpdateFileList;
	char cfgAutoExpandDirTree;*/
	
	f1.txtACMdev->setText(QString(myCfg->cfgACMdevice));
	f1.txtATvendor->setText(QString("%1").arg(myCfg->cfgATvendor,0,16).rightJustify(4,'0'));
	f1.txtATproduct->setText(QString("%1").arg(myCfg->cfgATproduct,0,16).rightJustify(4,'0'));
	f1.txtP2Kvendor->setText(QString("%1").arg(myCfg->cfgP2Kvendor,0,16).rightJustify(4,'0'));
	f1.txtP2Kproduct->setText(QString("%1").arg(myCfg->cfgP2Kproduct,0,16).rightJustify(4,'0'));
	
	f1.chkAutoConnect->setChecked(myCfg->cfgAutoConnect);
	f1.chkAutoUpdateFileList->setChecked(myCfg->cfgAutoUpdateFileList);
	f1.chkAutoExpandTree->setChecked(myCfg->cfgAutoExpandDirTree);
	f1.chkGoLastFolder->setChecked(myCfg->cfgGoLastFolder);
	f1.chkLoadList->setChecked(myCfg->cfgLoadList);
	
	enableAutoConnect=0;
	if (!f1.exec())
	{	
		enableAutoConnect=1;
		return;
	}
	
	strcpy(myCfg->cfgACMdevice,f1.txtACMdev->text().latin1());	
	myCfg->cfgATvendor=f1.txtATvendor->text().toUInt(0,16);
	myCfg->cfgATproduct=f1.txtATproduct->text().toUInt(0,16);
	myCfg->cfgP2Kvendor=f1.txtP2Kvendor->text().toUInt(0,16);
	myCfg->cfgP2Kproduct=f1.txtP2Kproduct->text().toUInt(0,16);
	
	myCfg->cfgAutoConnect=f1.chkAutoConnect->isChecked();
	myCfg->cfgAutoUpdateFileList=f1.chkAutoUpdateFileList->isChecked();
	myCfg->cfgAutoExpandDirTree=f1.chkAutoExpandTree->isChecked();
	myCfg->cfgGoLastFolder=f1.chkGoLastFolder->isChecked();
	myCfg->cfgLoadList=f1.chkLoadList->isChecked();
	myCfg->saveConfig();
	loadConfig();
	enableAutoConnect=1;
}
