/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef JAVAMANIFEST_H
#define JAVAMANIFEST_H

#include <qobject.h>

/* Example of MANIFEST FILE
 Manifest-Version: 1.0
 MicroEdition-Configuration: CLDC-1.0
 MIDlet-Name: JBenchmark2
 MIDlet-Icon: /JBenchmark2/JBenchmark.png
 MIDlet-Info-URL: http://wap.jbenchmark.com
 MIDlet-Vendor: Kishonti LP
 MIDlet-1:  JBenchmark2, , JBenchmark2.JBenchmark2
 MIDlet-Version: 2.0.4
 MicroEdition-Profile: MIDP-2.0
 MIDlet-Description: Graphical java benchmark for mobile devices
*/


class JavaManifest : public QObject
{
public:
    JavaManifest(const QByteArray& info, QObject *parent = 0, const char *name = 0);
    ~JavaManifest();

    QString getMidletName();
    QString getMidletCaption();
    QString getMidletIcon();
    QString getMidletVendor();
	QString getStartupClass();
	QString getMidletVersion();
private:
	QByteArray arr;
	
	QString getField(const QString& name);
};

#endif
