/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/*
This class implement phone interface with signals and slots
*/
 

#ifndef PHONEMAN_H
#define PHONEMAN_H

#include <stdlib.h>

#include <qobject.h>
#include <qptrlist.h>


#include "p2kproc.h"
#include "custmsg.h"

class QCustomEvent;


/**
@author Dmitry Nezhevenko
*/

class QString;

class PhoneMan : public QObject
{
	Q_OBJECT
public:
	PhoneMan(QObject *parent = 0, const char *name = 0);
	~PhoneMan();
	
	void customEvent(QCustomEvent *);	
	void switchToP2K(char * st);
	void openPhone();
	void closePhone();
	void rebootPhone();
	void suspendPhone();
	void getInfo(int what);
	int getState();
	void getFileList();
	void downloadFiles(P2kFile * lst, int cnt, const char * dir);
	void uploadFiles(P2kFile * lst, int cnt, const char * dir1, const char * dir2);
	void deleteFiles(P2kFile * lst, int cnt);
	void changeAttr(P2kFile * lst, int cnt);
	void readSeem(int x, int y, unsigned char * buf, int *size);
	void writeSeem(int x, int y, unsigned char * buf, int size);
	void backupSeem(int x1, int y1, int x2, int y2, unsigned char * dir);
	void createDirectory(const char *dir);
	void removeDirectory(const char *dir);
	void search(const char *request);
	
	void setATconfig (unsigned int vendor, unsigned int product);
	void setP2kconfig (unsigned int vendor, unsigned int product);
	void setDevice(char * cmd);
	int getDevList(devInfo * lst, int cnt);

private:
	P2kProc * proc;

signals:
	void statusChanged(int status);
	void modeChanged(int mode);
	void postMsg(int type, const QString &s);
	void postProgress(int value);
	void nfoPhoneModel(const QString &s);
	void nfoDriveName(const QString &s);
	void nfoFileCount(int cnt);
	void nfoFreeSpace(long space);
	void nfoProgress(int pg);
	void nfoFileList(P2kFile * lst, int count);
	void seemReadComplete();
	void seemWriteComplete();
	void nfoComplete(int act, const QString &s);
};

#endif
