//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QLabel>
#include <QtGui/QDialog>
#include <QtGui/QPushButton>
#include <QtGui/QIcon>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include "aboutprogramdialog.h"
#include "const.h"

AboutProgramDialog::AboutProgramDialog(QWidget *parent) : QDialog(parent) {
	iconLabel = new QLabel;
	iconLabel->setPixmap(QPixmap(PROGRAM_ICON_PATH));
		
	textLabel = new QLabel;
	textLabel->setWordWrap(true);
	
	closeButton = new QPushButton(tr("Close"));
	connect(closeButton,SIGNAL(clicked()),this,SLOT(hide()));
	
	textLabel->setText(tr("%4MountManager%5 - is a Linux program, which is used to make mounting of partitions,%3flash cards, removable disks and other storage devices easier.%3%3%4Version:%5 %1%3%3%4Authors:%5%3%2Developer - Tikhonov Sergey%3%2Idea - Ivashko Evgeny%3%3%4Helpers:%5%3%2Documentation - Litovchenko Vasiliy%3%2Program code - Nasyrov Renat, Devaev Maxim%3%2Web - Fomkin Vladimir%3%2Testers - Ivashko Evgeny, Kolbin Yaroslav").arg(VERSION).arg("&nbsp;&nbsp;&nbsp;&nbsp;").arg("<br>").arg("<b>").arg("</b>"));
			
	setWindowTitle(tr("About the program"));
	
	topLayout = new QHBoxLayout;
	topLayout->addStretch();
	topLayout->addWidget(iconLabel);
	topLayout->addStretch();
	
	bottomLayout = new QHBoxLayout;
	bottomLayout->addStretch();
	bottomLayout->addWidget(closeButton);
	bottomLayout->addStretch();
	
	mainLayout = new QVBoxLayout;
	mainLayout->addLayout(topLayout);
	mainLayout->addWidget(textLabel);
	mainLayout->addLayout(bottomLayout);
	mainLayout->addStretch();
	
	setLayout(mainLayout);
	setFixedSize(sizeHint());
}

AboutProgramDialog::~AboutProgramDialog() {
	delete iconLabel;
	delete textLabel;
	delete closeButton;
	
	delete topLayout;
	delete bottomLayout;
	delete mainLayout;
}
