//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QWidgetAction>
#include <QFrame>
#include <QHBoxLayout>
#include <QFont>
#include <QLabel>
#include <QStyle>
#include <QIcon>
#include "menu.h"

Menu::Menu(bool useSpecialHeader) {
	// Init
	headerAction = 0;
	headerActionFrame = 0;
	headerLabel = 0;
	iconLabel = 0;
	// Create header action if useSpecialHeader == true
	if (useSpecialHeader) {
		headerAction = new QWidgetAction(this);
		headerAction->setEnabled(false);
	
		headerActionFrame = new QFrame;
		headerActionFrame->setFrameShape(QFrame::Box);
	
		headerAction->setDefaultWidget(headerActionFrame);
	
		QHBoxLayout *headerActionFrameLayout = new QHBoxLayout();
		headerActionFrameLayout->setMargin(3);
		headerActionFrameLayout->setSpacing(3);
		headerActionFrame->setLayout(headerActionFrameLayout);

		iconLabel = new QLabel;
		headerLabel = new QLabel;
		
		iconSize = style()->pixelMetric(QStyle::PM_SmallIconSize);
		headerActionFrameLayout->insertWidget(-1,iconLabel,0);
		headerActionFrameLayout->insertWidget(-1,headerLabel,20);
		QFont font = headerLabel->font();
		font.setBold(true);
		headerLabel->setFont(font);
	
	
		addAction(headerAction);
	}
}

Menu::~Menu() {
	if (headerAction != 0) {
		delete headerLabel;
		delete iconLabel;
		delete headerActionFrame;
		delete headerAction;
	}
}

void Menu::setHeaderText(const QString &headerText) {
	if (headerLabel != 0)
		headerLabel->setText(headerText);
}

void Menu::setHeaderIcon(const QIcon &icon) {
	if (iconLabel != 0)
		iconLabel->setPixmap(icon.pixmap(iconSize,iconSize));
}