//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef USBMANAGER_H
#define USBMANAGER_H

#include <QDialog>
#include <QList>

class TreeWidget;
class QLineEdit;
class QGroupBox;
class QComboBox;
class ChooseMountPointWidget;
class QCheckBox;
class PopupWindow;
class QPushButton;
class InfoButton;
class QTableWidget;
class QSplitter;
class QTableWidgetItem;
class UsbManagerFsOptionsDialog;
class UsbManagerFsCellWidget;
class QTreeWidgetItem;
class QAction;
class DiskDevice;
class VolumeWidget;

class UsbManager : public QDialog
{
	Q_OBJECT
	private slots:
		void addFileSystem(const QString &fileSystem = QString(),const QString &options = QString());
		void removeFileSystem();
		void currentFileSystemChanged(int row,int column);
		void addRule();
		void rulesChangedSlot();
		void removeRule();
		void editRule();
		void fillRuleParts();
		void setFilter(const QString& filter);
		void saveRuleAs();
	public slots:
		void setDeviceAutomount(DiskDevice *deviceItem,VolumeWidget *volumeWidget);
		void addDeviceAutomountRule(DiskDevice *deviceItem,VolumeWidget *volumeWidget);
	signals:
		void rulesChanged();
	private:
		// Define what dialog is doint now. May be creating rule for device
		bool isCreatingDeviceRuleNow;
		DiskDevice *currentDevice;

		QStringList allRules;
		QList<QTreeWidgetItem *> removedRulesItems;
		QList<QTreeWidgetItem *> rulesItems;
		
		// Special dialog for every row in optionsForFileSystems table
		QList<UsbManagerFsOptionsDialog *> dialogs;
		QList<UsbManagerFsCellWidget *> cells;
		
		QSplitter *splitter;
		
		QGroupBox *deviceDefinitionBox;
		QLineEdit *deviceName;
		QLineEdit *vendorName;
		QLineEdit *modelName;
		QLineEdit *busName;
		QLineEdit *subsystemName;

		QTableWidget *optionsForFileSystems;
		
		QGroupBox *autoMountSettingsBox;
		QComboBox *fileSystem;
		QLineEdit *options;
		ChooseMountPointWidget *mountPointWidget;
		QCheckBox *createAndRemoveMountPoint;
		
		QGroupBox *otherRuleSettingsBox;
		QComboBox *groupName;
		QComboBox *ownerName;
		QLineEdit *oneMoreDeviceName;
		
		TreeWidget *treeWidget;
		QAction *removeRuleAction;
		QAction *editRuleAction;
		QLineEdit *rulesFilter;

		QPushButton *closeCancelButton;
		QPushButton *addRuleButton;
		QPushButton *editRuleButton;
		QPushButton *saveAsRuleButton;
		QPushButton *addFileSystemButton;
		QPushButton *removeFileSystemButton;

		InfoButton *informationButton;
		InfoButton *busInfoButton;
		InfoButton *deviceNameInfoButton;
		InfoButton *vendorInfoButton;
		InfoButton *modelInfoButton;
		InfoButton *fileSystemInfoButton;
		InfoButton *optionsInfoButton;
		InfoButton *mountPointInfoButton;
		InfoButton *subsystemInfoButton;
		InfoButton *groupInfoButton;
		InfoButton *optionsForFileSystemsInfoButton;
		InfoButton *setOneMoreDeviceNameInfoButton;
		InfoButton *ownerInfoButton;

		QString deviceDefinitionRuleString();
		QString rule();
		void createTreeWidgetItems();
		void init();
	public:
		UsbManager(PopupWindow *popupWindow,QWidget *parent = 0);
		~UsbManager();
	protected:
		void closeEvent(QCloseEvent *);
		
};


#endif
