#!/usr/bin/python


import os, glob, sys, gzip, re, traceback, string, commands

from commands import getstatusoutput

from optparse import OptionParser

#default configuration

config_file = '/etc/mountpy.conf'
#device prefix 
device_prefix = '/dev'

probe_devices = [
'sd[a-z]',
'sd[a-z][1-9]',
'fd[0-1]',
'cdrom',
]

blacklist_devices = [
#'fd[0-1]'
]

default_options = 'users,noatime,sync,dirsync'

# ('filesystem_name', 'filesystem_options')
fs_options = {
'vfat': default_options+',uid=%(uid)s,gid=%(gid)s,utf8',
'msdos': default_options+',uid=%(uid)s,gid=%(gid)s,utf8',
'iso9660': 'users,ro,utf8,unhide',
'ntfs': 'users,ro,nls=utf8,uid=%(uid)s,gid=%(gid)s',
'auto': default_options
}

try_filesystems = ['vfat','msdos','iso9660','ntfs','auto']

mount_command = '/bin/mount'
umount_command = '/bin/umount'

do_sync = True

device_map = {

}

mntdir = '/media/'

# end of default options

VERSION='0.3'

if not os.path.isfile(config_file):
    print "Missing configuration file", config_file
    sys.exit()
    
execfile(config_file)


#safety checks
if ( not os.path.isabs(mntdir) or
     len(os.path.normpath(mntdir))<2  # empty or root /
     ):
    print "mntdir is set to %s" % `mntdir`
    print "This looks insane to me, refusing to continue"
    print "Please edit /etc/mountpy.conf"
    print "If you have no idea what this means, contact your system administrator."
    print "If you have no idea what this means and YOU are "
    print "an administrator, go read some basic literature about UNIX"
    print "and then try again."
    sys.exit()
     
colours = {
            'none'       :    "",
            'default'    :    "\033[0m",
            'bold'       :    "\033[1m",
            'underline'  :    "\033[4m",
            'blink'      :    "\033[5m",
            'reverse'    :    "\033[7m",
            'concealed'  :    "\033[8m",

            'black'      :    "\033[30m",
            'red'        :    "\033[31m",
            'green'      :    "\033[32m",
            'yellow'     :    "\033[33m",
            'blue'       :    "\033[34m",
            'magenta'    :    "\033[35m",
            'cyan'       :    "\033[36m",
            'white'      :    "\033[37m",

            'on_black'   :    "\033[40m",
            'on_red'     :    "\033[41m",
            'on_green'   :    "\033[42m",
            'on_yellow'  :    "\033[43m",
            'on_blue'    :    "\033[44m",
            'on_magenta' :    "\033[45m",
            'on_cyan'    :    "\033[46m",
            'on_white'   :    "\033[47m",

            'beep'       :    "\007",
            }

alert_colour = colours['red']+colours['bold']
info_colour = colours['green']
default_colour = colours['default']


def alert(*text):
    sys.stdout.write(alert_colour)
    sys.stdout.write(' '.join(text))
    sys.stdout.write(' '*20)
    sys.stdout.write('\n')
    sys.stdout.write(default_colour)
    sys.stdout.flush()

def info(*text):
    sys.stdout.write(info_colour)
    sys.stdout.write(' '.join(text))
    sys.stdout.write(' '*20)
    sys.stdout.write('\n')
    sys.stdout.write(default_colour)
    sys.stdout.flush()

def debug(*text):
    sys.stdout.write(' '.join(text))
    sys.stdout.write(' '*20)
    sys.stdout.write('\n')

def msg(*text):
    sys.stdout.write(' '.join(text))
    sys.stdout.write(' '*20)
    sys.stdout.write('\r')
    sys.stdout.flush()

def sync_it():
    os.system('/bin/sync &')

def safe_rmdir(path):
    "remove directory, but do some safety checks before"
    if ( (os.path.isdir(path) or os.path.islink(path)) and 
         os.path.isabs(path) and 
         not os.path.ismount(path) and
         path.startswith(mntdir) and
         path == os.path.normpath(path) and
         path.startswith(mntdir)
          ):

        if os.path.islink(path):
            os.remove(path)
        else:
            os.rmdir(path)
    else:
        raise IOError, "Trying to remove suspicious directory: "+`path`
    
def get_all_devices(list_to_probe):
    r = []
    for i in list_to_probe:
        path = os.path.join(device_prefix, i)
        for j in glob.glob(path):
            r.append(j)
    return r

def check_device(device):
    "check if device exists at all"
    try:
        os.open(device, os.O_RDONLY)
    except OSError:
        return False
    return True
    
def try_mount(device, fs):
    mountpoint = os.path.join(mntdir, os.path.split(device)[1])
    if os.path.exists(mountpoint):
        verbose(mountpoint + " already exists")
        if os.path.ismount(mountpoint):
            verbose(mountpoint + " is already mounted - skipping")
            return
    else:
        os.makedirs(mountpoint)
    d = {'uid':uid, 'gid':gid}
    mount_options = fs_options.get(fs, default_options) % d
    command = '%s "%s" "%s" -o %s' % (mount_command, device, mountpoint, mount_options)
    status, output = getstatusoutput(command)
    if status == 0:
        return True
    else:
        verbose("%s %s" %(status, output))
        safe_rmdir(mountpoint)
        return False

def try_umount(device):
    mountpoint = os.path.join(mntdir, os.path.split(device)[1])
    if os.path.islink(mountpoint):
        verbose(mountpoint + " is a symlink - removing")
        safe_rmdir(mountpoint)
        return None
    if not os.path.exists(mountpoint):
        verbose(mountpoint + " does not exists")
        return None
    if not os.path.ismount(mountpoint):
        verbose(mountpoint + " is not mounted - removing")
        safe_rmdir(mountpoint)
        return None
    command = '%s "%s"' % (umount_command, mountpoint)
    status, output = getstatusoutput(command)
    if status == 0:
        safe_rmdir(mountpoint)
        return True
    else:
        alert("Could not umount %s, reason: %s\n" %(device, output))
        return False # could not umount

    
def verbose(text, verbosity = 1):
    if options.verbosity >= verbosity:
        debug(text)

parser = OptionParser(usage="usage: %prog [options] arg")
parser.add_option("-u", "--umount",
      action="store_const", const='umount', dest="action", default="mount",
      help="Umount")
parser.add_option("-m", "--mount",
      action="store_const", const='mount', dest="action", default="mount",
      help="Mount")

parser.add_option("-v", "--verbose",
      action="count", dest="verbosity",
      default=0,
      help="Increase verbosity")

      
      
(options, args) = parser.parse_args()


if options.verbosity > 0:
    verbose("Action " + options.action)

if len(args)==0:
    verbose("Will try all possible devices")
    if options.action == 'mount':
        devices = get_all_devices(probe_devices)
    elif options.action == 'umount':
        devices = os.listdir(mntdir)
    else:
        raise
else:
    devices = get_all_devices(args)

blacklist_devices = get_all_devices(blacklist_devices)


processed = [] # list of succesfully mounted/umounted devices
unsuccessful = [] # list of devices that could not have been umounted

uid = os.getuid()
gid = os.getgid()
euid = os.geteuid()

verbose("Detected UID %s, GID %s, EUID %s" % (uid, gid, euid))

if euid != 0:
    info("Not running setuid root, but trying anyway")

os.setuid(0)


for device in devices:
    if device in blacklist_devices:
        verbose("Blacklisted "+ device, 2)
        continue
    if options.action == "mount":
        msg("Checking", device)
        if not check_device(device):
            verbose("Device not present "+ device, 2)
            continue
        for fs in try_filesystems:
            verbose("Trying to mount " + device +' '+fs, 2)
            msg("Trying to mount", device, fs)
            r = try_mount(device, fs)
            if r:
                info("Mounted", device)
                processed.append(device)
                break
    elif options.action == "umount":
        verbose("Trying to umount " + device, 2)
        msg("Trying to umount", device)
        r = try_umount(device)
        if r:
            info("Umounted", device)
            processed.append(device)
        if r==False:
            unsuccessful.append(device)
            
if options.action == "mount": 
    if processed:
        info('List of mounted devices: ', ' '.join(processed))
    else:
        info('Found nothing to mount')
    
if options.action == "umount":
    if processed:
        info('List of umounted devices: ', ' '.join(processed))
    if unsuccessful:
        sync_it()
        alert('WARNING: these devices remained mounted: ', ' '.join(unsuccessful))
    if not processed and not unsuccessful:
        info('Found nothing to umount')
