/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgStorage = {
  processURL : function (url, docLoc) {
    url = url.substr(10);
    var parts = url.split("/");
    // check whether command is valid
    switch (parts[0]) {
      case "addmapping":
        this.importMapping(parts, docLoc);
        break;
      default:
        var msg = mgGetString("unknownCommand");
        msg = msg.replace(/%COMMAND%/, parts[0]);
        alert(msg);
    }
  },

  importMapping : function (parts, docLoc) {
    if (mgCommon.checkWindowOpen("chrome://mozgest/content/pref/mappings.xul"))
      return;

    var validCode = false;
    var code = "";
    var appearance = null;

    var gestureRegExp = /^(\*{0,1}[1379DLUR]+){1}(;\*{0,1}[1379DLUR]+){0,1}$/;
    if (parts[2].match(/^:[0-2][0-2\+\-]$/)) {
      validCode = true;
      code = parts[2];
    }
    else if (gestureRegExp.exec(parts[2])) {
      validCode = true;
      code = RegExp.$1;
      appearance = RegExp.$2.substr(1);
      var cC = mgCommon.compactCode;
      if (cC(code) != code || (appearance && cC(appearance) != code))
        validCode = false;
    }

    if (!validCode) {
      alert(mgGetString("invalidCode"));
      return;
    }

    var func = null;
    var name = null;
    var custom = null;
    var check = 0;

    if (parts[3] == "custom") {
      name = decodeURIComponent(parts[4]);
      custom = unescape(parts[5]);
      check = this.checkFunc(parts[1], null);
    }
    else {
      check = this.checkFunc(parts[1], parts[3]);
      func = parts[3];
    }

    if (check == -1) {
      this.msg = mgGetString("unknownWindowType");
      this.msg = this.msg.replace(/%WINDOWTYPE%/, parts[1]);
      alert(this.msg);
      return;
    }
    if (check == -2) {
      this.msg = mgGetString("unknownFunction");
      this.msg = this.msg.replace(/%FUNCTION%/, parts[3]);
      alert(this.msg);
      return;
    }

    _mgMS.importLocation = docLoc;
    _mgMS.importWinType = parts[1];
    _mgMS.importCode = code;
    _mgMS.importAppearance = appearance;
    _mgMS.importName = name;
    _mgMS.importFunc = func;
    _mgMS.importCustom = custom;

    mgCommon.openDialog("chrome://mozgest/content/pref/mappings.xul",
                        ["Import", parts[1], code]);
  },

  checkFunc : function(winType, aFunc) {
    var retVal = 0;

    if (!((winType in _mgMS.supportedWindows) || winType == "window"))
      return -1;

    if (aFunc) {
      if (!(aFunc in _mgMS.functions[winType]) &&
          !(aFunc in _mgMS.functions["window"]))
        return -2;
    }

    return retVal;
  }
}

//Import mousegestures.rdf

var importer = {
  RDF : Components.classes["@mozilla.org/rdf/rdf-service;1"]
                  .getService(Components.interfaces.nsIRDFService),

  NS : "http://optimoz.mozdev.org/gestures-rdf#",

  actTemp : new Array(),

  initImport : function() {
    var retVal = false;
    try {
      var wTypeArray = new Array("browser", "viewsource", "window", "messenger");

      var dirService   = Components.classes['@mozilla.org/file/directory_service;1']
                                   .getService(Components.interfaces.nsIProperties);
      var mappingsFile = dirService.get('ProfD', Components.interfaces.nsILocalFile);
      mappingsFile.append("mousegestures.rdf");

      var ioService  = Components.classes["@mozilla.org/network/io-service;1"]
                                 .getService(Components.interfaces.nsIIOService);
      var mgFileSpec = ioService.newFileURI(mappingsFile).spec

      var dsource = this.RDF.GetDataSourceBlocking(mgFileSpec);
      // if dsource is corrupted, we don't receive the error,
      // although it is in the console. so let us test...
      var lastTest = dsource.GetAllResources();

      if (!lastTest.hasMoreElements())
        throw("MozGest: Stopping import! Something is wrong with mousegestures.rdf\n");

      for (var x = 0; x < wTypeArray.length; x++)
        this.importRDFGestures(dsource, wTypeArray[x]);
    }
    catch (e) {
      retVal = e;
    }

    return retVal;
  },

  importRDFGestures : function(dsource, winType) {
    var mappingsContainer =  Components.classes['@mozilla.org/rdf/container;1'].createInstance()
                             .QueryInterface(Components.interfaces.nsIRDFContainer);

    var rootnode = this.RDF.GetResource("urn:mozgest:mappings:" + winType);

    try {
      mappingsContainer.Init(dsource, rootnode);
    }
    catch (e) {
      // no existing mappings
      return;
    }

    var enumerator = mappingsContainer.GetElements();

    if (!enumerator.hasMoreElements())
      return;

    this.actTemp[winType] = new Array();

    while (enumerator.hasMoreElements()) {
      var mapping = enumerator.getNext()
                    .QueryInterface(Components.interfaces.nsIRDFResource);

      var code = this.getProperty(dsource, mapping, "code");

      if (code == "UUUUUU")
        continue;

      var func = this.getProperty(dsource, mapping, "function");
      var custom = this.getProperty(dsource, mapping, "custom");
      var bmOpenIn = this.getProperty(dsource, mapping, "bmOpenIn");
      var count = Math.abs(this.getProperty(dsource, mapping, "count")) || 0;
      var type = null;
      var name = null;

      if (custom) {
        type = "1";
        func = custom;
        name = this.getProperty(dsource, mapping, "name");
      }
      if (bmOpenIn)
        type = "2" + bmOpenIn;

      this.actTemp[winType][code] = {type:type, name:name, func:func, count:count};
    }
    return;
  },

  getProperty : function (dsource, obj, propName) {
    var literal = dsource.GetTarget(obj, this.RDF.GetResource(this.NS + propName), true);
    if (literal)
      return literal.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
    else
      return null;
  }
}