/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Andy Edmonds <aedmonds@mindspring.com>
 *  Benjamin K. Stuhl <tiriath@yahoo.com>
 *  Brent Schartung <bschartung@gmail.com>
 *  David Illsley <illsleydc@bigfoot.com>
 *  Dorando <mozilla@dorando.at>
 *  HJ van Rantwijk <bugs4HJ@netscape.net>
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Martin.T.Kutschker <Martin.T.Kutschker@blackbox.net>
 *  Pavol Vaskovic <pali@pali.sk>
 *  Pekka Aleksi Knuutila <aleksi.knuutila@edu.lahti.fi>
 *  Scott R. Turner <srt@aero.org>
 *  Tim Williamson <chsman@hotmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//----------------------
//-- Global variables --
//----------------------
var mgStatusPopup;
var mgContext = null;
var mgContextVis = false;
var mgPopupBox;
var mgContent = null;
var mgString; // array holding localized stroke names
var gestureInProgress = false;
var globalOnLink = false; // array that holds a list of all the links traversed during gesture
var globalOnImage = false; // string containing an image href or false
var globalSrcEvent = false; // event which started the active gesture.

var mgState = {
  gestureStartTime : 0 ,
  gestureDone : false,
  rockerAborted : false,
  previousSelection : null,
  oX : 0, oY : 0,
  gridMoves : new Array(),
  gesture : new Array(),
  localizedGesture : new Array(),
  lastGestureTime : 0,
  lastMoveTime : 0,
  gestureTimeout : null,
  statusTimer : null,
  allowContext : false,
  autoScrollAborted : false,
  history : new Array(),
  rockerCode : "",
  linkTemp : null
};

var mgObserver = {
  mgPrefTimeout   : null,
  obs             : Components.classes["@mozilla.org/observer-service;1"]
                    .getService(Components.interfaces.nsIObserverService),

  createEvt : function(what, data) {
    var mData = data.split("|");
    var evt = document.createEvent("MouseEvents");
    evt.initMouseEvent(what, 1, 1, window, 1,
                       mData[1], mData[2], 0, 0, 0, 0, 0, 0, mData[0], window);

    return evt;
  },

  observe : function(subject, topic, data) {
    // when MozGest pref was changed, we reinitialize
    // (except when sidebar settings changed)
    // use a timeout to avoid multiple inits if more than
    // one pref was changed. Not bullet proof.
    if (topic.indexOf("nsPref") == 0) {
      if (data.indexOf("sideBar") == 0 || data == "selectedTabIndex" ||
          data == "importFrom" || data == "firstStart")
        return;

      clearTimeout(mgObserver.mgPrefTimeout);
      mgObserver.mgPrefTimeout = setTimeout(mozgestInit, 200);
    }

    if (topic == "mozgestGetBaseWin") {
      if (mgCommon.winWatcher.activeWindow != window)
        return;

      mgMouseService.setBaseWin(mgGetBaseWin());
    }

    if (topic == "mozgestButtonUp") {
      if (mgCommon.winWatcher.activeWindow != window)
        return;

      try {
        mgEndGesture(this.createEvt("mouseup", data), true);
      }
      catch (e) {}
    }

    if (topic == "mozgestButtonDown") {
      if (mgCommon.winWatcher.activeWindow != window)
        return;

      try {
        if (navigator.platform != "Win32" &&
            this.createEvt("mousedown", data).button == mgPrefs.mousebutton)
          mgContext.hidePopup();
      }
      catch (e) {}

    }

    if (topic == "mozgestRockerDown") {
      if (mgCommon.winWatcher.activeWindow != window)
        return;

      try {
        mgStartGesture(this.createEvt("mousedown", data));
      }
      catch (e) {}
    }
  },

  register : function() {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2)
           .addObserver("", this, false);

    if (mgMouseEvents) {
      this.obs.addObserver(this, "mozgestGetBaseWin", false);
      this.obs.addObserver(this, "mozgestRockerDown", false);
      this.obs.addObserver(this, "mozgestButtonUp", false);
      this.obs.addObserver(this, "mozgestButtonDown", false);
    }
  },

  unregister : function() {
    mgPrefs.prefs.QueryInterface(Components.interfaces.nsIPrefBranch2)
           .removeObserver("", this);

    if (mgMouseEvents) {
      this.obs.removeObserver(this, "mozgestGetBaseWin");
      this.obs.removeObserver(this, "mozgestRockerDown");
      this.obs.removeObserver(this, "mozgestButtonUp");
      this.obs.removeObserver(this, "mozgestButtonDown");
    }
  }
}

//--------------------------------
//-- Startup/shutdown functions --
//--------------------------------
function mgStartup(e) {
  window.removeEventListener("load", mgStartup, false);
  mgComponentLoader.initMouseService(true);
  mgInitNotification();

  // Hack! get our keyset
  var mgKeySet = document.getElementById("openMozgestSettings");
  if (!mgKeySet) {
    mgKeySet = document.getElementsByAttribute("id", "openMozgestSettings")[0].parentNode;
    document.documentElement.appendChild(mgKeySet);
  }

  //this comes from windowTypes.js
  mgWindowTypes.init();
  mgWindowType = mgWindowTypes.getWindowType(document.location);

  if (mgWindowType) {
    mgCommon.dump("MozGest: ---- Startup ----\n");
    mgObserver.register();
    window.addEventListener("unload", function () {mgObserver.unregister()}, false);
    mgLoadStrings();
    mozgestInit();
  }
}

function mozgestInit() {
  mgPrefs.init();
  // turn gestures recognition on/off
  if (mgPrefs.get(mgWindowType))
    mgAddWindowWatch();
  else
    mgRemoveWindowWatch();

  try {
    mgPrefs.prefs.getBoolPref("firstStart");
  }
  catch (e) {
    mgPrefs.prefs.setBoolPref("firstStart", true);
    mgPrefs.prefs.setIntPref("selectedTabIndex", 3);
    setTimeout("mgCommon.openDialog('chrome://mozgest/content/pref/pref-mozgest.xul')", 500);
  }
}

function mgLoadStrings() {
  // load localized strings and cache often used strings
  mgString = new Array();
  mgString["R"] = mgGetString("a.right");
  mgString["L"] = mgGetString("a.left");
  mgString["U"] = mgGetString("a.up");
  mgString["D"] = mgGetString("a.down");
  mgString["1"] = mgGetString("a.d1");
  mgString["3"] = mgGetString("a.d3");
  mgString["7"] = mgGetString("a.d7");
  mgString["9"] = mgGetString("a.d9");
  mgString["gesture"] = mgGetString("g.gesture");
}

function mgAddWindowWatch() {
  mgCommon.dump("MozGest: ---- Get Contentarea ---\n");

  if (document.documentElement.getAttribute("windowtype") == "navigator:browser")
    mgContent = mgGetContentArea().mPanelContainer;
  else
    mgContent = mgGetContentArea();

  mgRemoveWindowWatch();
  mgCommon.dump("MozGest: Adding Listeners\n");

  mgContent.addEventListener("mousedown", mgStartGesture, false);
  mgContent.addEventListener("draggesture", mgOnDragGestureEvent, true);

  if (mgPrefs.enableWheelRockers)
    mgContent.addEventListener("DOMMouseScroll", mgMousewheelHandler, false);

  window.addEventListener("mouseup", mgEndGesture, false);
  window.addEventListener("keydown", mgAllowContextByKeyPress, true);
  window.addEventListener("mousemove", mgProcessCoordinates, true);
  mgContent.addEventListener("contextmenu", mgContextMenuListener, true);
  mgContent.addEventListener("click", mgOnClickHandler, true);
  mgContent.addEventListener("dblclick", mgOnClickHandler, true);

  if (navigator.platform != "Win32")
    window.addEventListener("popupshowing", mgAutoScrollHandler, true);
}

function mgInitNotification() {
  if (!document.getElementById("mgStatusPopup")) {
    var mgSet = document.createElement("popupset");
    mgStatusPopup = document.createElement("tooltip");
    mgStatusPopup.id = "mgStatusPopup";
    mgStatusPopup.setAttribute("onpopuphidden", "this.hidden=true;setTimeout('mgStatusPopup.hidden=false',0)");
    var mgStatusLabel = document.createElement("label");
    mgStatusLabel.id = "mgStatusLabel";
    mgStatusLabel.setAttribute("crop", "end");
    mgStatusLabel.setAttribute("flex", "1");
    mgStatusPopup.appendChild(mgStatusLabel);
    mgSet.appendChild(mgStatusPopup);
    document.documentElement.appendChild(mgSet);
    window.addEventListener("blur", function () {
                                     if (mgPrefs["status.enabled"])
                                       mgStatusPopup.hidePopup()
                                    }, true);
  }
}

function mgRemoveWindowWatch() {
  mgCommon.dump("MozGest: Removing Listeners\n");
  mgContent.removeEventListener("mousedown", mgStartGesture, false);
  mgContent.removeEventListener("draggesture", mgOnDragGestureEvent, true);
  mgContent.removeEventListener("DOMMouseScroll", mgMousewheelHandler, false);
  mgContent.removeEventListener("contextmenu", mgContextMenuListener, true);
  window.removeEventListener("mouseup", mgEndGesture, false);
  window.removeEventListener("keydown", mgAllowContextByKeyPress, true);
  window.removeEventListener("mousemove", mgProcessCoordinates, true);
  mgContent.removeEventListener("click", mgOnClickHandler, true);
  mgContent.removeEventListener("dblclick", mgOnClickHandler, true);
  window.removeEventListener("popupshowing", mgAutoScrollHandler, true);
}

//-----------------------
//-- Integration hooks --
//-----------------------
// (everything needed for co-existing with or disabling regular app functions)

function mgContextMenuListener(e) {
  if (mgAppInfo.geckoVersion.substring(0,3) > 1.8) {
    if (!mgState.allowContext) {
      e.preventDefault();
      e.stopPropagation();
    }
  }

  addEventListener("popupshowing", mgDisableContextMenu, true);
  setTimeout("removeEventListener('popupshowing', mgDisableContextMenu, true)", 5);
}

function mgDisableContextMenu(e) {
  mgContext=e.originalTarget;

  if (!mgState.allowContext)
    e.preventDefault();
}

function mgAllowContextByKeyPress(e) {
  if (!gestureInProgress) {
    mgState.allowContext = true;
    mgState.gestureDone = false;
  }
}

function mgAutoScrollHandler(e) {
  if (e.target.id=="autoscroller") {
    mgContext=e.originalTarget;
    if (!e.target.hasAttribute("mozgestWasHere")) {
      e.target.addEventListener("mousedown", function(e) {mgStartGesture(e, true)}, true);
      e.target.setAttribute("mozgestWasHere", true);
    }
  }
}

function mgOnClickHandler(e) {
  if (mgState.gestureDone) {
    mgCommon.dump("MozGest: Stopping " + e.type + " event caused by last gesture.\n");
    e.preventDefault();
    e.stopPropagation();
    return false;
  }

  var node = e.originalTarget;

  if (!node.getAttribute || !node.hasAttribute("href"))
    return null;

  var tagname = node.nodeName.toLowerCase();
  var href = node.getAttribute("href");

  if (tagname == "a" && href.indexOf("mozgest://") == 0 && e.button < 2) {
    mgCommon.dump("MozGest: Link click " + href + "\n");
    mgStorage.processURL(href, node.ownerDocument.location);
    e.stopPropagation();
    e.preventDefault();
  }
  return null;
}

function mgOnDragGestureEvent(e) {
  var draggedElement = e.originalTarget.nodeName.toUpperCase();
  if (gestureInProgress && draggedElement != "HTML") {
    if (mgState.lastMoveTime-mgState.gestureStartTime > mgPrefs.dragdropDelay) {
      mgCommon.dump("MozGest: '" + draggedElement
           + "' drag encountered, canceling gesture\n");
      mgEndGesture("drag");
    } else {
      mgCommon.dump("MozGest: canceling '" + draggedElement
           + "' drag event, continuing gesture\n");
      e.stopPropagation();
    }
  }
  if (mgState.gestureDone)
    e.stopPropagation();
}

//---------------------------------
//-- The gesture recognizer core --
//---------------------------------
function mgProcessCoordinates(e) {
  if (e.screenX < mgState.oX -25 || e.screenX > mgState.oX +25 ||
      e.screenY < mgState.oY -25 || e.screenY > mgState.oY +25)
    mgState.rockerAborted = true;

  if (!gestureInProgress)
    return;

  var now = (new Date).getTime();

  if (mgPrefs.mousebutton == 1 && !mgState.autoScrollAborted &&
      (e.screenX != mgState.oX || e.screenY != mgState.oY)) {
     mgState.autoScrollAborted = true;
     if (mgStopAutoScroll())
       return;
  }

  if (!mgPrefs.enableStrokes)
    return;

  var g = mgState.gesture.join("");
  if (mgPrefs.gestureCondition == "e.button==0" && (g == "L" || g == "R")
      && (now - mgState.gestureStartTime) > mgPrefs.lmbGestureLimit) {
    mgEndGesture(null);
  }

  var x_dir = e.screenX - mgState.oX;
  var y_dir = e.screenY - mgState.oY;
  var x = Math.abs(x_dir);
  var y = Math.abs(y_dir);

  if (x >= mgPrefs.grid/2 || y >= mgPrefs.grid/2) { // process each half-grid
    // diagonal movement:
    // mgPrefs.diagonalTolerance = 75 means that a movement is recognized as diagonal when
    // x/y or y/x is between 0.25 and 1
    if ( mgPrefs.diagonalTolerance != 0 && ( (x/y >= (1-mgPrefs.diagonalTolerance/100) && x/y <= 1)
        || (y/x >= (1-mgPrefs.diagonalTolerance/100) && y/x <= 1) ) ) {

      if (x_dir < 0 && y_dir > 0)
        mgPush("1");
      else if (x_dir > 0 && y_dir > 0)
        mgPush("3");
      else if (x_dir < 0 && y_dir < 0)
        mgPush("7");
      else if (x_dir > 0 && y_dir < 0)
        mgPush("9");
    }
    // horizontal move:
    else if (x > y) {
      if (x_dir > 0)
        mgPush("R");
      else if (x_dir < 0)
        mgPush("L");
    }
    // vertical move:
    else if (x < y) {
      if (y_dir > 0)
        mgPush("D");
      else if (y_dir < 0)
        mgPush("U");
    }

    mgShowStatus(mgState.gesture.join(""));
    mgState.lastGestureTime = now;

    if (mgState.gestureTimeout)
      window.clearTimeout(mgState.gestureTimeout);

    mgState.gestureTimeout = window.setTimeout("mgEndGesture(null);", mgPrefs.delay);

    mgState.oX = e.screenX;
    mgState.oY = e.screenY;
  }
  mgState.lastMoveTime = now;
  mgExamineHoveredElement(e.originalTarget);
}

function mgPush(code) {
  mgState.gridMoves.push(code);
  if (mgState.gridMoves.length == 2) {
    if (mgState.gridMoves[0] == mgState.gridMoves[1] || mgState.gesture.length == 0)
      mgDoPush(mgState.gridMoves.pop());

    mgState.gridMoves.length = 0;
  }
}

function mgDoPush(code) {
  if (mgState.gesture[mgState.gesture.length-1] != code) {
    mgState.gesture.push(code);
    mgState.localizedGesture.push(mgString[code]);
  }
  if (mgState.gesture.length == 1)
    mgResetRocker();
}

function mgExamineHoveredElement(node, inContentCheck) {
  var imgNode = node;
  var CI = Components.interfaces;

  if (inContentCheck) {
    if (mgMouseEvents && mgState.rockerCode.length > 1)
      return true;

    globalOnLink = globalOnImage = false;
    var checkNode = node;

    for (checkNode; checkNode; checkNode = checkNode.parentNode) {
      var n = checkNode.nodeName.toLowerCase();

      if (n == "scrollbar" || n == "select" ||
          n == "input" || n == "textarea" ||
          n == "textbox" || n == "object" || n == "embed")
        return false;
    }
  }

  for (node; node; node = node.parentNode) {
    if (node instanceof CI.nsIDOMHTMLAnchorElement ||
        node instanceof CI.nsIDOMHTMLAreaElement ||
        node instanceof CI.nsIDOMHTMLLinkElement) {

      if (!globalOnLink) {
        globalOnLink = new Array();
        mgState.linkTemp = new Array();
      }

      if (!(node.href in mgState.linkTemp)) {
        mgState.linkTemp[node.href] = node.href;
        globalOnLink.push(node);
        mgCommon.dump("Mozgest: hovered link '" + node.href + "'\n");
      }
      break;
    }
  }

  for (imgNode; imgNode; imgNode = imgNode.parentNode) {
    if (!globalOnImage && imgNode instanceof CI.nsIDOMHTMLImageElement) {
      globalOnImage = imgNode;
      mgCommon.dump("Mozgest: found image.\n");
      break;
    }
  }
  return true;
}

function mgStartGesture(e, isPopup) {
  mgReleaseRocker(e);
  mgState.allowContext = false;
  mgState.gestureDone = false;
  mgState.oX = e.screenX;
  mgState.oY = e.screenY;

  if (mgExamineHoveredElement(e.originalTarget, true) && !mgCheckForRocker(e) && !isPopup) {
    globalSrcEvent = e;

    if (!gestureInProgress && mgPrefs.enableStrokes && eval(mgPrefs.gestureCondition)) {
      // check if it's possible to draw trails
      if (mgPrefs["trails.enabled"] && mgNativeTrails)
        mgMouseService.initTrails(mgGetBaseWin(), mgPrefs["trails.width"], mgPrefs["trails.interval"],
                                  mgPrefs.grid, mgPrefs["trails.color"].substring(1));

      gestureInProgress = true;
      mgState.gestureStartTime = mgState.lastGestureTime = (new Date).getTime();
      mgState.lastMoveTime = mgState.gesture.length = mgState.localizedGesture.length = 0;;

      var sel = mgGetSelection();
      if (mgPrefs.mousebutton == 0 && sel && sel.rangeCount > 0)
        mgState.previousSelection = sel.getRangeAt(0);
    }
  }
}

function mgEndGesture(e, synth) {
  mgReleaseRocker(e);
  mgState.rockerAborted = false;
  mgState.autoScrollAborted = false;
  clearTimeout(mgState.statusTimer);

  if (gestureInProgress) {
    gestureInProgress = mgState.gestureStartTime = false;

    if (mgNativeTrails)
      mgMouseService.stopTrails();

    window.clearTimeout(mgState.gestureTimeout);

    // check if we've been called via a timeout; see mgProcessCoordinates()
    if (e == null) {
      mgCommon.dump("gesture timeouted\n");

      if (mgPrefs["status.enabled"])
        mgStatusPopup.firstChild.value = mgGetString("g.aborted");

      mgState.gestureDone = true;
    }
    else if (mgState.gesture.join("") != "") {
      mgState.gestureDone = true;
      window.setTimeout(mgFireGesture, 0, mgState.gesture.join(""));
    }
  }

  if (mgPrefs["status.enabled"])
    mgState.statusTimer = setTimeout("mgStatusPopup.hidePopup();", mgPrefs["status.timeout"]);

  if (!synth && e && !mgState.gestureDone && (e.button == 2 ||
      (navigator.platform.indexOf("Mac") == 0 && e.button == 0 && e.ctrlKey))) {
    mgState.allowContext = true;
    //==================== contextmenu on mousedown =============================
    if (navigator.platform != "Win32") {
      var ctBox = mgContent.boxObject;

      if (e.screenY >= ctBox.screenY &&
          e.screenY <= ctBox.screenY + ctBox.height &&
          e.screenX >= ctBox.screenX &&
          e.screenX <= ctBox.screenX + ctBox.width) {

        document.popupNode = e.target;

        if (mgAppInfo.geckoVersion.substring(0,3) > 1.8) {
          var ev = e.view.document.createEvent ('MouseEvents');
          ev.initMouseEvent('contextmenu', true, true, e.view, 1, e.screenX, e.screenY,
                            e.pageX, e.pageY, 0, 0, 0, 0, 2, null);

          e.originalTarget.dispatchEvent(ev);

          if (gContextMenu) {
            try {
              gContextMenu.setTarget(document.popupNode, e.rangeParent, e.rangeOffset);
              gContextMenu.initItems();
            }
            catch (e) {}
          }
          return;
        }

        var mgPopupBox = mgContext.boxObject
                     .QueryInterface(Components.interfaces.nsIPopupBoxObject);

        if (mgContextVis)
          return;

        if (e.target.ownerDocument && e.target.ownerDocument == document)
          return;

        if (!mgContext.hasAttribute("mozgestWasHere")) {
          mgContext.addEventListener("popupshown", mgObserveContext, true);
          mgContext.addEventListener("popuphidden", mgObserveContext, true);
          mgContext.setAttribute("mozgestWasHere", true);
        }

        try {
          mgPopupBox.showPopup(mgContext.ownerDocument.documentElement, mgContext,
                               e.clientX, e.clientY, "context", "bottomleft", "topleft");
        }
        catch (e) {}
      }
    }
  }
}

function mgObserveContext(e) {
  if (e.type == "popupshown") {
    if (e.target == mgContext)
      mgContextVis = true;
  }
  else if (e.target == mgContext)
    mgContextVis = false;
}

function mgGetBaseWin() {
  var mgDocShell = mgGetContentArea().docShell;
  return mgDocShell.QueryInterface(Components.interfaces.nsIBaseWindow);
}

function mgShowStatus(code, isRocker, byTimer) {
  if (mgPrefs["status.enabled"]) {
    clearTimeout(mgState.statusTimer);
    var statusText = mgString["gesture"] + " " +
                     ((isRocker) ? (code + ((byTimer) ? unescape("%u221E") : "")) : mgState.localizedGesture);
    var nameTemp = mgGetMapping(code)[1];

    if (nameTemp)
      statusText += " (" + nameTemp + ")";

    mgStatusPopup.firstChild.setAttribute("value", statusText);
    mgStatusPopup.showPopup(document.documentElement, -1 , -1, "tooltip", "topleft", "bottomleft");
  }
}

function mgGetMapping(code) {
  var aM = _mgMS.activeMappings;
  var mapping = false;
  var name = false;

  if (code in aM[mgWindowType])
    mapping = aM[mgWindowType][code];
  else if (code in aM["window"])
    mapping = aM["window"][code];

  if (mapping) {
    if (mapping.name)
      name = decodeURIComponent(mapping.name);
    else
      name = mgGetString(mapping.func);
  }

  return [mapping, name];
}