var mgDefaultMappings =
{
  mappings : {
     browser     : new Array(),
     viewsource  : new Array(),
     window      : new Array(),
     messenger   : new Array(),
     mailcompose : new Array()
  },

  /* ============================================================================
     func: is important!
     func can be: built-in-function, script-code, keyboard-shortcut, bookmark-id
     ============================================================================
     x[mapping] = {func:xxx, type:xxx, name:xxx, count:xxx, cat:xxx}
       type = 0  -> normal gesture
                    func is predefined (no name)
                    note: 0 will never be stored
       type = 1  -> custom gesture
                    func is a JavaScript snippet (evaled)
       type = 2  -> keyboard gesture
                    func is a mixture of ctrl|alt|shift|meta and keyCode|charcode
                    and will be fired to document.documentElement
       type = 9x -> bookmark gesture
                    func is a unique bookmark id
                    90 -> current Window
                    91 -> new Window
                    92 -> current Tab
                    93 -> new Tab
                    94 -> Sidebar
     ============================================================================
     cat: The category of the gesture
       0: Miscellaneous (everything that is not 1-6)
       1: Navigation (e.g. back)
       2: Tabbed Browsing (e.g. mgB_OpenTab)
       3: Window Management (e.g. mgW_CloseWin)
       4: Zooming, Scrolling, DOM-Manipulation (e.g. mgB_ZoomIn)
       5: Links and Bookmarks (e.g. mgB_LinksInWindows)
       6: Message Management (e.g. mgM_NextMessage, only TB and SM)
     ============================================================================ */

  init : function() {
    // "b" == browser
    var b = this.mappings.browser;
    b[":02"]   = {func: "mgB_Forward", cat: 1}
    b[":20"]   = {func: "mgB_Back", cat: 1}
    b[":12"]   = {func: "mgB_NextTab", cat: 2}
    b[":10"]   = {func: "mgB_PreviousTab", cat: 2}
    b[":2+"]   = {func: "mgB_NextTab", cat: 2}
    b[":2-"]   = {func: "mgB_PreviousTab", cat: 2}
    b["L"]     = {func: "mgB_Back", cat: 1}
    b["R"]     = {func: "mgB_Forward", cat: 1}
    b["LU"]    = {func: "mgB_Stop", cat: 1}
    b["DURD"]  = {func: "mgB_Home", cat: 1}
    b["D"]     = {func: "mgB_OpenNewDocument", cat: 3}
    b["U"]     = {func: "mgB_OpenTab", cat: 2}
    b["UR"]    = {func: "mgB_NextTab", cat: 2}
    b["UL"]    = {func: "mgB_PreviousTab", cat: 2}
    b["UD"]    = {func: "mgB_Reload", cat: 1}
    b["ULU"]   = {func: "mgB_UpDir", cat: 1}
    b["DR"]    = {func: "mgB_CloseTab", cat: 2}
    b["RD"]    = {func: "mgB_ViewPageInfo", cat: 3}
    b["LDRDL"] = {func: "mgB_ViewPageSource", cat: 3}
    b["DRDLU"] = {func: "mgB_AddBookmark", cat: 5}
    b["RUDR"]  = {func: "mgB_DoubleStackWin", cat: 3}
    b["9"]     = {func: "mgB_HideImage", cat: 4}
    b["3"]     = {func: "mgB_ZoomIn_DoubleImage", cat: 4}
    b["7"]     = {func: "mgB_ZoomOut_HalveImage", cat: 4}
    b["1"]     = {func: "mgB_ResetZoom", cat: 4}
    b["31"]    = {func: "mgB_ZoomIn", cat: 4}
    b["13"]    = {func: "mgB_ZoomOut", cat: 4}
    b["*RU"]   = {func: "mgB_LinksInWindows", cat: 5}
    b["*RUL"]  = {func: "mgB_LinksInTabs", cat: 5}

    //"vs" == viewsource
    var vs = this.mappings.viewsource;
    vs["3"]    = {func: "mgB_ZoomIn", cat:4}
    vs["7"]    = {func: "mgB_ZoomOut", cat: 4}
    vs["1"]    = {func: "mgB_ResetZoom", cat: 4}

    //"w" == generic (for all window types)
    var w = this.mappings.window;
    w["9L3"]   = {func: "mgW_Cut", cat: 0}
    w["93"]    = {func: "mgW_Copy", cat: 0}
    w["39"]    = {func: "mgW_Paste", cat: 0}
    w["DRD"]   = {func: "mgW_CloseWin", cat: 3}
    w["DL"]    = {func: "mgW_MinWin", cat: 3}
    w["RU"]    = {func: "mgW_RestMaxWin", cat: 3}
    w["U1"]    = {func: "mgW_ScrollUp", cat: 4}
    w["D7"]    = {func: "mgW_ScrollDown", cat: 4}
    w["R7"]    = {func: "mgW_ScrollRight", cat: 4}
    w["L9"]    = {func: "mgW_ScrollLeft", cat: 4}

    //"m" == messenger
    var m = this.mappings.messenger;
    m[":20"]   = {func: "mgM_PrevMessage", cat: 6}
    m[":02"]   = {func: "mgM_NextMessage", cat: 6}
    m["L"]     = {func: "mgM_PrevMessage", cat: 6}
    m["R"]     = {func: "mgM_NextMessage", cat: 6}
    m["DRU"]   = {func: "mgM_DeleteMessage", cat: 6}
    m["DUR"]   = {func: "mgM_ReplyMessage", cat: 6}
    m["DURL"]  = {func: "mgM_ForwardMessage", cat: 6}
    m["UD"]    = {func: "mgM_Reload", cat: 1}
    m["DURD"]  = {func: "mgM_Home", cat: 1}
    m["D"]     = {func: "mgM_NewMessage", cat: 6}
    m["*RUL"]  = {func: "mgM_OpenLinks", cat: 5}
    m["URD"]   = {func: "mgM_ViewSource", cat: 3}
    m["9"]     = {func: "mgB_HideImage", cat: 4}
    m["3"]     = {func: "mgB_ZoomIn_DoubleImage", cat: 4}
    m["7"]     = {func: "mgB_ZoomOut_HalveImage", cat: 4}
    m["1"]     = {func: "mgB_ResetZoom", cat: 4}
    m["31"]    = {func: "mgB_ZoomIn", cat: 4}
    m["13"]    = {func: "mgB_ZoomOut", cat: 4}

    //"mc" == mailcompose
    var mc     = this.mappings.mailcompose;
  },

  getMappings : function() {
    return this.mappings
  }
}

var mgDefaultFunctions =
{
  functions : {
     browser     : new Array(),
     viewsource  : new Array(),
     window      : new Array(),
     messenger   : new Array(),
     mailcompose : new Array()
  },

  init : function() {
    /* "b" == functions for browser
    ======================================================
    b["mgB_ResetZoom"] = ["B", "M", "VS"] -> this function
    will work in (B)rowser, (M)essenger and (V)iew(S)ource
    ====================================================== */
    var b = this.functions.browser;
    b["mgB_AddBookmark"] = ["B", "cat5"]
    b["mgB_Back"] = ["B", "cat1"]
    b["mgB_CloseDoc"] = ["B", "cat3"]
    b["mgB_CloseTab"] = ["B", "cat2"]
    b["mgB_DoubleImageSize"] = ["B", "M", "cat4"]
    b["mgB_DoubleStackWin"] = ["B", "cat3"]
    b["mgB_Forward"] = ["B", "cat1"]
    b["mgB_HalveImageSize"] = ["B", "M", "cat4"]
    b["mgB_HideImage"] = ["B", "M", "cat4"]
    b["mgB_Home"] = ["B", "cat1"]
    b["mgB_LinksInTabs"] = ["B", "cat5"]
    b["mgB_LinksInWindows"] = ["B", "cat5"]
    b["mgB_NextTab"] = ["B", "cat2"]
    b["mgB_OpenNewDocument"] = ["B", "cat3"]
    b["mgB_OpenTab"] = ["B", "cat2"]
    b["mgB_PreviousTab"] = ["B", "cat2"]
    b["mgB_Reload"] = ["B", "cat1"]
    b["mgB_ReloadSkipCache"] = ["B", "cat1"]
    b["mgB_ResetZoom"] = ["B", "M", "VS", "cat4"]
    b["mgB_Stop"] = ["B", "cat1"]
    b["mgB_UpDir"] = ["B", "cat1"]
    b["mgB_ViewPageInfo"] = ["B", "cat3"]
    b["mgB_ViewPageSource"] = ["B", "cat3"]
    b["mgB_ZoomIn"] = ["B", "M", "VS", "cat4"]
    b["mgB_ZoomIn_DoubleImage"] = ["B", "M", "cat4"]
    b["mgB_ZoomOut"] = ["B", "M", "VS", "cat4"]
    b["mgB_ZoomOut_HalveImage"] = ["B", "M", "cat4"]

    // "w" == functions for all window types (generic)
    var w = this.functions.window;
    w["mgW_CloseWin"] = ["W", "cat3"]
    w["mgW_Copy"] = ["W", "cat0"]
    w["mgW_Cut"] = ["W", "cat0"]
    w["mgW_MinWin"] = ["W", "cat3"]
    w["mgW_Paste"] = ["W", "cat0"]
    w["mgW_RestMaxWin"] = ["W", "cat3"]
    w["mgW_ScrollDown"] = ["W", "cat4"]
    w["mgW_ScrollUp"] = ["W", "cat4"]
    w["mgW_ScrollRight"] = ["W", "cat4"]
    w["mgW_ScrollLeft"] = ["W", "cat4"]

    // "m" == functions for messenger
    var m = this.functions.messenger;
    m["mgM_DeleteMessage"] = ["M", "cat6"]
    m["mgM_ForwardMessage"] = ["M", "cat6"]
    m["mgM_Home"] = ["M", "cat1"]
    m["mgM_NewMessage"] = ["M", "cat6"]
    m["mgM_NextMessage"] = ["M", "cat6"]
    m["mgM_NextUnreadMessage"] = ["M", "cat6"]
    m["mgM_OpenLinks"] = ["M", "cat5"]
    m["mgM_PrevMessage"] = ["M", "cat6"]
    m["mgM_PrevUnreadMessage"] = ["M", "cat6"]
    m["mgM_Reload"] = ["M", "cat1"]
    m["mgM_ReplyMessage"] = ["M", "cat6"]
    m["mgM_ViewSource"] = ["M", "cat3"]

    // "mc" == functions for mailcompose
    var mc = this.functions.mailcompose;
  },

  getFunctions : function() {
    return this.functions
  }
}

var mgDefaultPrefs = {
  prefs : new Array(),

  init : function() {
    var p = this.prefs

    // int [default, min, max]
    p["grid"] = [15, 4, 500]
    p["delay"] = [1000, 200, 10000]
    p["lmbGestureLimit"] = [500, 100, 10000]
    p["staticRockersDelay"] = [1000, 200, 10000]
    p["diagonalTolerance"] = [60, 0, 75]
    p["mousebutton"] = navigator.platform.indexOf("Mac") == 0 ? [0, 0, 2] : [2, 0, 2]
    p["trails.width"] = [4, 1, 100]
    p["trails.interval"] = [2, 1, 100]
    p["status.align"] = [0, 0, 3]
    p["status.timeout"] = [1000, 0, 5000]
    p["selectedTabIndex"] = [3, 0, 3]
    p["scrollBy"] = [200, 1, 1000000]

    // bool
    p["browser"] = [true]
    p["viewsource"] = [true]
    p["messenger"] = [true]
    p["mailcompose"] = [true]
    p["enableDump"] = [false]
    p["enableStrokes"] = [true]
    p["enableRockers"] = [true]
    p["staticRockers"] = [false]
    p["enableWheelRockers"] = [false]
    p["staticWheelRockers"] = [false]
    p["lefthanded"] = [false]
    p["modifier.ctrl"] = [false]
    p["modifier.alt"] = [false]
    p["modifier.shift"] = [false]
    p["modifier.meta"] = [false]
    p["trails.enabled"] = [false]
    p["status.isEnabled"] = [false]
    p["status.rockers.enabled"] = [false]
    p["sideBar.canvas"] = [true]
    p["sideBar.toolTip"] = [true]

    // char
    p["trails.color"] = ["#FF9900"]
    p["status.anchorElement"] = ["document.documentElement"]
    p["sideBar.sort"] = ["sortByUsage"]
    p["importFrom"] = ["www.mousegestures.org"]
  },

  getPref : function(pref) {
    if (pref in this.prefs)
      return this.prefs[pref];
    else
      return ["notFound"];
  }
}