// ***** BEGIN LICENSE BLOCK *****
// Version: MPL 1.1/GPL 2.0/LGPL 2.1
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// The Original Code is mozilla.org code.
//
// The Initial Developer of the Original Code is
// the Mozilla Organization.
// Portions created by the Initial Developer are Copyright (C) 1998-2002
// the Initial Developer. All Rights Reserved.
//
// Contributor(s):
//   Robert Kaiser <KaiRo@KaiRo.at>
//   Nagarjuna Venna (vnagarjuna@yahoo.com)
//
// Alternatively, the contents of this file may be used under the terms of
// either the GNU General Public License Version 2 or later (the "GPL"), or
// the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
// in which case the provisions of the GPL or the LGPL are applicable instead
// of those above. If you wish to allow use of your version of this file only
// under the terms of either the GPL or the LGPL, and not to allow others to
// use your version of this file under the terms of the MPL, indicate your
// decision by deleting the provisions above and replace them with the notice
// and other provisions required by the GPL or the LGPL. If you do not delete
// the provisions above, a recipient may use your version of this file under
// the terms of any one of the MPL, the GPL or the LGPL.
//
// ***** END LICENSE BLOCK *****


// --- strings specific to that single Language Pack ---
var prettyName = "Fran\u00e7ais";
var langcode = "fr";
var regioncode = "FR";
var version = "1.7.12";
// --- end pack-specific strings ---


// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired) {
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired) {
    logComment("Espace disque insuffisant\u00a0: " + dirPath);
    logComment("  requis\u00a0: " + spaceRequired + " Ko");
    logComment("  disponible\u00a0: " + spaceAvailable + " Ko");
    return(false);
  }

  return(true);
}

// this function converts an error number to the error code
function ErrCode(errornum)
{
    if (errornum == 0)  {
        errorstring = "SUCCESS";
    }
    else if (errornum == -200)  {
        errorstring = "BAD_PACKAGE_NAME";
    }
    else if (errornum == -201) {
        errorstring = "UNEXPECTED_ERROR";
    }
    else if (errornum == -202) {
        errorstring = "ACCESS_DENIED";
    }
    else if (errornum == -203) {
        errorstring = "TOO_MANY_CERTIFICATES";
    }
    else if (errornum == -204) {
        errorstring = "NO_INSTALL_SCRIPT";
    }
    else if (errornum == -205) {
        errorstring = "NO_CERTIFICATE";
    }
    else if (errornum == -206) {
        errorstring = "NO_MATCHING_CERTIFICATE";
    }
    else if (errornum == -207) {
        errorstring = "CANT_READ_ARCHIVE";
    }
    else if (errornum == -208) {
        errorstring = "INVALID_ARGUMENTS";
    }
    else if (errornum == -209) {
        errorstring = "ILLEGAL_RELATIVE_PATH";
    }
    else if (errornum == -210) {
        errorstring = "USER_CANCELLED";
    }
    else if (errornum == -211) {
        errorstring = "INSTALL_NOT_STARTED";
    }
    else if (errornum == -212) {
        errorstring = "SILENT_MODE_DENIED";
    }
    else if (errornum == -213) {
        errorstring = "NO_SUCH_COMPONENT";
    }
    else if (errornum == -214) {
        errorstring = "DOES_NOT_EXIST";
    }
    else if (errornum == -215) {
        errorstring = "READ_ONLY";
    }
    else if (errornum == -216) {
        errorstring = "IS_DIRECTORY";
    }
    else if (errornum == -217) {
        errorstring = "NETWORK_FILE_IS_IN_USE";
    }
    else if (errornum == -218) {
        errorstring = "APPLE_SINGLE_ERR";
    }
    else if (errornum == -219) {
        errorstring = "INVALID_PATH_ERR";
    }
    else if (errornum == -220) {
        errorstring = "PATCH_BAD_DIFF";
    }
    else if (errornum == -221) {
        errorstring = "PATCH_BAD_CHECKSUM_TARGET";
    }
    else if (errornum == -222) {
        errorstring = "PATCH_BAD_CHECKSUM_RESULT";
    }
    else if (errornum == -223) {
        errorstring = "UNINSTALL_FAILED";
    }
    else if (errornum == -224) {
        errorstring = "PACKAGE_FOLDER_NOT_SET";
    }
    else if (errornum == -225) {
        errorstring = "EXTRACTION_FAILED";
    }
    else if (errornum == -226) {
        errorstring = "FILENAME_ALREADY_USED";
    }
    else if (errornum == -227) {
        errorstring = "INSTALL_CANCELLED";
    }
    else if (errornum == -228) {
        errorstring = "DOWNLOAD_ERROR";
    }
    else if (errornum == -229) {
        errorstring = "SCRIPT_ERROR";
    }
    else if (errornum == -230) {
        errorstring = "ALREADY_EXISTS";
    }
    else if (errornum == -231) {
        errorstring = "IS_FILE";
    }
    else if (errornum == -232) {
        errorstring = "SOURCE_DOES_NOT_EXIST";
    }
    else if (errornum == -233) {
        errorstring = "SOURCE_IS_DIRECTORY";
    }
    else if (errornum == -234) {
        errorstring = "SOURCE_IS_FILE";
    }
    else if (errornum == -235) {
        errorstring = "INSUFFICIENT_DISK_SPACE";
    }
    else if (errornum == -236) {
        errorstring = "FILENAME_TOO_LONG";
    }
    else if (errornum == -237) {
        errorstring = "UNABLE_TO_LOCATE_LIB_FUNCTION";
    }
    else if (errornum == -238) {
        errorstring = "UNABLE_TO_LOAD_LIBRARY";
    }
    else if (errornum == -239) {
        errorstring = "CHROME_REGISTRY_ERROR";
    }
    else if (errornum == -240) {
        errorstring = "MALFORMED_INSTALL";
    }
    else if (errornum == -299) {
        errorstring = "OUT_OF_MEMORY";
    }
    else if (errornum == 999) {
        errorstring = "REBOOT_NEEDED";
    }
    else if (errornum == -5550) {
        errorstring = "GESTALT_UNKNOWN_ERROR";
    }
    else if (errornum == -5551) {
        errorstring = "GESTALT_INVALID_ARGUMENT";
    }
    else {
        errorstring = "Erreur #" + errornum;
    }

    return(errorstring);
}

// this function converts an error number to a string with code and number
function ErrWithCode(err)
{
  return(err + " (" + ErrCode(err) + ")");
}

// OS type detection - which platform?
function getPlatform() {
  var platformStr;
  var platformNode;

  if('platform' in Install) {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else if (!platformStr.search(/^OS\/2/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}

// *** start main install routine ***

var srDest = 4200;
var err;
var fProgram;
var platformNode;
var profileInstall = 0;
var alertstring;

platformNode = getPlatform();
logComment("Installation d'un pack de langue: type de la plateforme d\u00e9tect\u00e9 comme \u00e9tant: " + platformNode);

var chromeNode = langcode + "-" + regioncode;
var regName    = "locales/mozilla/" + chromeNode;
var chromeName = chromeNode + ".jar";
var regionFile = regioncode + ".jar";
var platformName = langcode + "-" + platformNode + ".jar";
var localeName = "locale/" + chromeNode + "/";
var regionName = "locale/" + regioncode + "/";

err = initInstall(prettyName, regName, version); 
logComment("initInstall: " + ErrWithCode(err));

var install_successprofile = "Installation de la langue fran\u00e7aise r\u00e9ussie dans le r\u00e9pertoire de votre profil. Elle ne sera disponible que pour le profil actuel.";
var install_successglobal = "Installation globale de la langue fran\u00e7aise r\u00e9ussie. Elle sera disponible pour tous les profils.";
var tell_reboot = "Vous devez RED\u00c9MARRER votre syst\u00e8me avant de pouvoir s\u00e9lectionner cette langue.";
var tell_restart = "Vous devez RED\u00c9MARRER Mozilla avant de pouvoir s\u00e9lectionner cette langue.";
var howto_switch = "Vous pouvez s\u00e9lectionner cette langue via Edit > Preferences (Cat\u00e9gorie: Appearance > Languages/Content).";
var install_failed = "L'installation a \u00e9chou\u00e9. Le code d'erreur \u00e9tait";
var install_cancel = "L'installation a \u00e9t\u00e9 annul\u00e9 avec l'erreur";
var need_write_perm = "Il semblerait que vous n'ayez pas de permissions en \u00e9criture dans le r\u00e9pertoire 'chrome' de Mozilla. Veuillez installer comme root / administrateur syst\u00e8me.";

fProgram = getFolder("Program");
logComment("fProgram: " + fProgram);

// searchplugins directory detection
fSearchPlugins = getFolder("Program", "searchplugins");
logComment("fSearchPlugins: " + fSearchPlugins);

if ((err == 0) && verifyDiskSpace(fProgram, srDest)) {
  // install search plugins first
  err = addDirectory("", "bin/searchplugins", fSearchPlugins, "");
  logComment("addDirectory() pour searchplugins a retourn\u00e9\u00a0: " + ErrWithCode(err));
  resetError();

  var chromeType = LOCALE;
  var tellRestart = 0;
// well, just try to do it right (tm) on unix as well for Mozilla 1.3 !!!  
//  if (platformNode == 'unix') {
    // DELAYED_CHROME is still needed on many unix systems for bug 109044; this needs a Mozilla restart!
//    logComment("d\u00e9tect\u00e9 un syst\u00e8me unix\u00a0: utilise DELAYED_CHROME pour registerChrome d\u00fb au bug 109044");
//    chromeType |= DELAYED_CHROME;
//    tellRestart = 1;
//  }
  err = addDirectory("", "bin/chrome", fProgram, "chrome");
  logComment("addDirectory() pour chrome a retourn\u00e9\u00a0: " + ErrWithCode(err));
  err = addDirectory("", "bin/defaults/messenger", fProgram, "defaults/messenger");
  logComment("addDirectory() pour defaults/messenger a retourn\u00e9\u00a0: " + ErrWithCode(err));
  err = addDirectory("", "bin/defaults/profile", fProgram, "defaults/profile");
  logComment("addDirectory() pour defaults/profile a retourn\u00e9\u00a0: " + ErrWithCode(err));
  if (platformNode == 'unix') {
    err = addDirectory("", "bin/defaults/isp", fProgram, "defaults/isp");
    logComment("addDirectory() pour defaults/isp a retourn\u00e9\u00a0: " + ErrWithCode(err));
  }
  err = addDirectory("", "bin/components", fProgram, "components");
  logComment("addDirectory() pour components a retourn\u00e9\u00a0: " + ErrWithCode(err));

  if (err != 0) {
    // return value 0 is SUCCESS
    logComment("addDirectory() pour " + fProgram + " a \u00e9chou\u00e9\u00a0!");
 
// well, just try to do it right (tm) on unix as well for Mozilla 1.3 !!!  
//    if (platformNode != 'unix') {
      // couldn't install globally, try installing to the profile (does only install chrome part, no defaults, no searchplugins)
      // does not work with DELAYED_CHROME !!! (see comment above - bug 109044)
      resetError();
      chromeType |= PROFILE_CHROME;
      profileInstall = 1;
      fProgram = getFolder("Profile");
      logComment("essaie l'installation dans le profil de l'utilisateur\u00a0: " + fProgram);
      err = addDirectory("", "bin/chrome", fProgram, "chrome");
      logComment("addDirectory() pour le profil chrome a retourn\u00e9\u00a0: " + ErrWithCode(err));
      err = addDirectory("", "bin/defaults/messenger", fProgram, "defaults/messenger");
      logComment("addDirectory() pour le profil chrome (defaults/messenger) a retourn\u00e9\u00a0: " + ErrWithCode(err));
      err = addDirectory("", "bin/defaults/profile", fProgram, "defaults/profile");
      logComment("addDirectory() pour le profil chrome (defaults/profile) a retourn\u00e9\u00a0: " + ErrWithCode(err));
      if (platformNode == 'unix') {
        err = addDirectory("", "bin/defaults/isp", fProgram, "defaults/isp");
        logComment("addDirectory() pour le profil chrome (defaults/isp) a retourn\u00e9\u00a0: " + ErrWithCode(err));
      }
      err = addDirectory("", "bin/components", fProgram, "components");
      logComment("addDirectory() pour le profil chrome (components) a retourn\u00e9\u00a0: " + ErrWithCode(err));
//    }
//    else {
//      logComment("ne peut pas utiliser le profil de l'utilisateur \u00e0 cause du bug 109044");
//    }
  }
 
  setPackageFolder(fProgram);
 
  // check return value: 0 is SUCCESS, 999 is REBOOT_NEEDED
  if ((err == 0) || (err == 999)) {
    var tellReboot = 0;
    if (err == 999) {
      if (platformNode == 'win') {
        tellRestart = 1;
      }
      else {
        tellReboot = 1;
      }
      resetError();
    }
    // register chrome
    var cf = getFolder(fProgram, "chrome/"+chromeName);
    var pf = getFolder(fProgram, "chrome/"+platformName);
    var rf = getFolder(fProgram, "chrome/"+regionFile);

    registerChrome(chromeType, cf, localeName + "autoconfig/");
    registerChrome(chromeType, cf, localeName + "chatzilla/");
    registerChrome(chromeType, cf, localeName + "communicator/");
    registerChrome(chromeType, cf, localeName + "content-packs/");
    registerChrome(chromeType, cf, localeName + "cookie/");
    registerChrome(chromeType, cf, localeName + "cview/");
    registerChrome(chromeType, cf, localeName + "editor/");
    registerChrome(chromeType, cf, localeName + "embed/");
    registerChrome(chromeType, cf, localeName + "global/");
    registerChrome(chromeType, cf, localeName + "help/");
    registerChrome(chromeType, cf, localeName + "inspector/");
    registerChrome(chromeType, cf, localeName + "layoutdebug/");
    registerChrome(chromeType, cf, localeName + "messenger/");
    registerChrome(chromeType, cf, localeName + "messenger-mdn/");
    registerChrome(chromeType, cf, localeName + "messenger-smime/");
    registerChrome(chromeType, cf, localeName + "mozldap/");
    registerChrome(chromeType, cf, localeName + "navigator/");
    registerChrome(chromeType, cf, localeName + "necko/");
    registerChrome(chromeType, cf, localeName + "p3p/");
    registerChrome(chromeType, cf, localeName + "pipnss/");
    registerChrome(chromeType, cf, localeName + "pippki/");
    registerChrome(chromeType, cf, localeName + "tasks/");
    registerChrome(chromeType, cf, localeName + "venkman/");
    registerChrome(chromeType, cf, localeName + "wallet/");

    registerChrome(chromeType, pf, localeName + "communicator-platform/");
    registerChrome(chromeType, pf, localeName + "global-platform/");
    registerChrome(chromeType, pf, localeName + "navigator-platform/");

    if (platformNode == 'win') {
      registerChrome(chromeType, pf, localeName + "messenger-mapi/");
    }

    registerChrome(chromeType, rf, regionName + "communicator-region/");
    registerChrome(chromeType, rf, regionName + "editor-region/");
    registerChrome(chromeType, rf, regionName + "global-region/");
    registerChrome(chromeType, rf, regionName + "messenger-region/");
    registerChrome(chromeType, rf, regionName + "navigator-region/");

    err = performInstall(); 
    logComment("performInstall() a retourn\u00e9\u00a0: " + ErrWithCode(err));
    if (err == 999) {
      if (platformNode == 'win') {
        tellRestart = 1;
      }
      else {
        tellReboot = 1;
      }
      resetError(); err = 0;
    }
    if (err == 0) {
      if (profileInstall == 1) {
        alertstring = install_successprofile;
      }
      else {
        alertstring = install_successglobal;
      }
      if (tellReboot == 1) {
        alertstring = alertstring + "\n\n" + tell_reboot;
        logComment("REBOOT_NEEDED (999): avertir l'utilisateur qu'il doit red\u00e9marrer son syst\u00e8me.");
        cancelInstall(REBOOT_NEEDED);
      }
      else {
        if (tellRestart == 1) {
          alertstring = alertstring + "\n\n" + tell_restart;
          logComment("on utilisait DELAYED_CHROME: avertir l'utilisateur qu'il doit red\u00e9marrer Mozilla.");
        }
      }
      alertstring = alertstring + "\n\n" + howto_switch;
    }
    else {
      alertstring = install_failed + " " + ErrWithCode(err) + ".";
      cancelInstall(err);
    }
  }
  else {
    cancelInstall(err);
    logComment("cancelInstall d\u00fb \u00e0 l'erreur\u00a0: " + ErrWithCode(err));
    alertstring = install_cancel + " " + ErrWithCode(err) + ".";
    if ((err == -202) || (err == -215)) {
      // -202 is ACCESS_DENIED, -215 is READ_ONLY
      alertstring = alertstring + "\n\n" + need_write_perm;
      if (err == -202) {
        logComment("ACCESS_DENIED (-202): avertir l'utilisateur qu'il n'a probablement pas les permissions en \u00e9criture \u00e0 chrome.");
      }
      else {
        logComment("READ_ONLY (-215): avertir l'utilisateur qu'il n'a probablement pas les permissions en \u00e9criture \u00e0 chrome.");
      }
    }
  }
  alert(alertstring);
}
else {
  if (err == 0)
    cancelInstall(INSUFFICIENT_DISK_SPACE);
  else
    cancelInstall(err);
}
