var _elementIDs = ["UseFrenchLocale"];
    
function init() {
  var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

  // initialize the default window values...
  for( var i = 0; i < _elementIDs.length; i++ ) {        
    var elementID = _elementIDs[i];
    var element = document.getElementById(elementID);
    if (!element) break;
    var eltType = element.localName;
    if (eltType == "radiogroup")
      element.selectedItem = element.childNodes[pref.getIntPref(element.getAttribute("prefstring"))];
    else if (eltType == "checkbox")
      element.checked = pref.getBoolPref(element.getAttribute("prefstring"));
    else if (eltType == "textbox")
      element.setAttribute("value", pref.getIntPref(element.getAttribute("prefstring")) );
  }
}

function savePrefs() {
  var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

  for( var i = 0; i < _elementIDs.length; i++ ) {
    var elementID = _elementIDs[i];
    
    var element = document.getElementById(elementID);
    if (!element) break;
    var eltType = element.localName;
    
    if (eltType == "radiogroup") {
      pref.setIntPref(element.getAttribute("prefstring"), parseInt(element.value));
    } else if (eltType == "checkbox") { 
      pref.setBoolPref(element.getAttribute("prefstring"), element.checked);
      
      if (elementID == "UseFrenchLocale") {
	if (element.checked) {
	  swl("fr-FR");
	} else {
	  swl("en-US");
	}
      }
    } else if (eltType == "textbox" && element.preftype == "int") {
      pref.setIntPref(element.getAttribute("prefstring"), parseInt(element.getAttribute("value")));
    }
  }
}

function swl(langcode) { // taken from http://localechanger.mozdev.org/
  var chromeRegistry = Components.classes["@mozilla.org/chrome/chrome-registry;1"].getService(Components.interfaces.nsIXULChromeRegistry);
  chromeRegistry.selectLocale(langcode, true);
}
