
/*
 * $Header: /cvsroot/mpdist/mpdist/mimep/mimep/mimep.c,v 1.1.1.1 2002/04/12 16:47:26 richbastard Exp $
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mimep.h"

static int _TRACE = 0;


int 
main(int narg, char **tabarg)
{
    char *inputfile, *outputfile, outputstr[MAXARRAY], boundarystr[MAXARRAY];
    char rulehstr[MAXARRAY], printerstr[MAXARRAY], comm_mm[MAXARRAY];
    char comm_latex[MAXARRAY], comm_dvips[MAXARRAY], comm_lpr[MAXARRAY];
    char *lastdir, *latexdir;

    argc = narg;
    argv = tabarg;
    toprinter = True;
    printername = NULL;

/*
 * If the MIMEPTMPDIR environment variable is set with a valid
 * directory name, mimep uses this directory to create its temporary files.
 */

    if (!(TMPDIR = getenv(MIMEPTMPDIR))) {
        TMPDIR = (char *) malloc(sizeof(char) * (strlen(DEFTMPDIR) + 1));
        STRCPY(TMPDIR, DEFTMPDIR);
    }
    Header();        /* mp */

/* Treats the X-resources and the options of the command line */

    treat_options();

/* Determines the input file and opens it */

    inputfile = inputfilename();
    if (!(fp_in = fopen(inputfile, "r"))) {
        FPRINTF(stderr, ERR1);
        usage(args, comments);
    }

/* Idem with the output file + removes the suffix of the file */

    outputfile = removesuffix(outputfilename());

    if (!(strcmp(outputfile, NOOUTPUTFILE))) {
        outputfile = tempnam(TMPDIR, TMPREFIX);
    }

/* Opens the output file which will contain the LaTeX document */

    if (!(fp_out = fopen(outputfile, "w"))) {
        FPRINTF(stderr, ERR3);
        exit(1);
    }

/*
 * Initializes the MIMEPOUT environment variable with the output file
 * name to communicate it to its collaborators (printmim ...)
 */

    STRCPY(outputstr, MIMEPOUT);
    STRCAT(outputstr, outputfile);
    PUTENV(outputstr);
    if (_TRACE) {
        FPRINTF(stderr, "MIMEPOUT: %s\n", outputstr);
    }

/*
 * Sets the MIMEPBOUND environment variable to default, non or to the
 * name of a PostScript file, depending of the boundary the user
 * wants between the bodyparts
 */

    STRCPY(boundarystr, MIMEPBOUND);

    if ((!boundary) || (!strcmp(boundary, DEFAULTB))) {
        STRCAT(boundarystr, DEFAULTB);  /* Simple horizontal line */
        STRCPY(rulehstr, MIMEPRULEH);   /* Sets the environment var. */
        STRCAT(rulehstr, RULEH);        /* which defines the height of */
        PUTENV(rulehstr);               /* this line. */
    } else {
        STRCAT(boundarystr, boundary);
    }

    PUTENV(boundarystr);

/*
 * Sets the MIMEPPRINT environment variable to the name of the printer the 
 * user wants mimep to print on. Interesting for shell scripts used by mimep.
 */

    if (printername) {
        STRCPY(printerstr, MIMEPPRINT);
        STRCAT(printerstr, printername);
        PUTENV(printerstr);
    }
    maxcarnb(typesize);

    if (_TRACE) {
        FPRINTF(stderr, "MIMEPBOUND: %s\n", boundarystr);
    }

/* Copy the LaTeX prologue to the LaTeX file */

    latex_header();

/*
 * Translates the RFC 822 headers to LaTeX and add it to the LaTeX
 * file, with a pretty presentation (you can modify...)
 */

    mk_headers();

/* Closes the LaTeX file */

    FCLOSE(fp_out);

/* Builds the metamail's call command line */

    STRCPY(comm_mm, METAMAIL);
    STRCAT(comm_mm, inputfilename());
    STRCAT(comm_mm, TONULL);
    if (_TRACE) {
        FPRINTF(stderr, "Commande: %s\n", comm_mm);
    }

/* Calls metamail */

    SYSTEM(comm_mm);

/* Opens the LaTeX output file to add the end of the document */

    if (!(fp_out = fopen(outputfile, "a"))) {
        FPRINTF(stderr, ERR3);
        exit(1);
    }

/* Adds the end of the document */

    latex_enddoc();

/* Flushes the output file's buffer then closes the file  */

    FFLUSH(fp_out);
    FCLOSE(fp_out);

/* Store the path of the current directory */

    if (!(lastdir = getcwd(NULL, MAXARRAY))) {
        FPRINTF(stderr, "%s %s", ERR4, lastdir);
    }

/* Chdir to the directory of the LaTeX file */

    if ((latexdir = getdir(outputfile))) {
        if ((chdir(latexdir)) == -1) {
            FPRINTF(stderr, "%s %s", ERR5, latexdir);
        }
    }

/* Builds the LaTeX's call command line */

    STRCPY(comm_latex, LATEX);
    STRCAT(comm_latex, outputfile);
    STRCAT(comm_latex, TONULL);

    if (_TRACE) {
        FPRINTF(stderr, "comm_latex: %s\n", comm_latex);
    }

/* Calls LaTeX on our LaTeX document */

    SYSTEM(comm_latex);

/* Returns to the original directory */

    if ((lastdir) && (latexdir)) {
        if ((chdir(lastdir)) == -1) {
            FPRINTF(stderr, ERR6);
        }
    }

/* Builds the dvips' call command line then calls dvips */

    STRCPY(comm_dvips, DVIPS);
    STRCAT(comm_dvips, outputfile);

    if (tofile) {
        STRCAT(comm_dvips, DVIPSO);
        STRCAT(comm_dvips, outputfile);
        STRCAT(comm_dvips, PSSUFFIX);
        SYSTEM(comm_dvips);    /* For an output to a file */
    }
    if (toprinter) {                  /* For an output to a printer */
        if (tofile) {
            STRCPY(comm_lpr, LPR);    /* Uses the lpr command ... */

            if (printername) {
                STRCAT(comm_lpr, LPRP);
                STRCAT(comm_lpr, printername);
            }
            if (!burstpage) {
                STRCAT(comm_lpr, LPRH);
            }
            STRCAT(comm_lpr, outputfile);
            STRCAT(comm_lpr, PSSUFFIX);
            SYSTEM(comm_lpr);
        } else {
            STRCAT(comm_dvips, DVIPSO);
            STRCAT(comm_dvips, TOPRINTER);
            if (!burstpage) {
                STRCAT(comm_dvips, LPRH);
            }
            if (printername) {
                STRCAT(comm_dvips, LPRP);
                STRCAT(comm_dvips, printername);
            }
            STRCAT(comm_dvips, ENDVIPSO);
            SYSTEM(comm_dvips);
        }
        if (_TRACE) {
            FPRINTF(stderr, "comm_lpr: %s\n", comm_lpr);
        }
    } else if (tostdout) {    /* For the standard output */
        STRCAT(comm_dvips, DVIPSF);
        SYSTEM(comm_dvips);
    }
    if (_TRACE) {
        FPRINTF(stderr, "comm_dvips: %s\n", comm_dvips);
    }

    clean();        /* Removes the temporary files */
    return(0);
}


/*         
 * Writes the LaTeX prologue in the LaTeX file. (paper size, characters'size
 * etc., beginning of the document ...)
 */

static void 
latex_header(void)
{
    FPRINTF(fp_out, "\\documentclass [%s,%dpt] {article}\n",
                   (paper_size == P_A4) ? A4PAPER : USPAPER, typesize);
    FP("\\usepackage[dvips]{graphics}");
    FP("\\usepackage{moreverb}");
    FP("\\usepackage[dvips]{color}");
    FP("\\usepackage{float}");
    FPRINTF(fp_out, "\\textwidth=%.2fpt\n", TEXTWIDTH);
    FPRINTF(fp_out, "\\oddsidemargin=%dpt\n", ODDSIDEMARGIN);
    FPRINTF(fp_out, "\\topmargin=%dpt\n", TOPMARGIN);
    FPRINTF(fp_out, "\\headheight=%dpt\n", HEADHEIGHT);
    FPRINTF(fp_out, "\\headsep=%dpt\n", HEADSEP);
    FPRINTF(fp_out, "\\footskip=%dpt\n", FOOTSKIP);
    FPRINTF(fp_out, "\\fboxsep=%dpt\n", FBOXSEP);
    FPRINTF(fp_out, "\\textheight=%dpt\n",
                    (paper_size == P_A4) ? A4TEXTHEIGHT : USTEXTHEIGHT);
    FP("\\newlength{\\boxlength}");
    FPRINTF(fp_out, "\\setlength{\\boxlength}{%.2fpt}\n", BOXLENGTH);
    FPRINTF(fp_out, "\\addtolength{\\boxlength}{-%dpt}\n", (2 * FBOXSEP - 6));
    FPRINTF(fp_out, "\\definecolor{linecolor}{gray}{%.2f}", BOXLINECOLOR);
    FPRINTF(fp_out, "\\definecolor{bckgrdcolor}{gray}{%.2f}", BOXBCKGRDCOLOR);
    FP("\\newcommand{\\titleh}[1]{%");
    FP("\\begin{flushleft}%");
    FP("\\fcolorbox{linecolor}{bckgrdcolor}{\\parbox{\\boxlength}{#1}}%");
    FP("\\end{flushleft}}");
    FP("\\newenvironment{ident}{\\begin{list}%");
    FP("{}{\\rightmargin=0mm}\\item[]}%");
    FP("{\\end{list}}");
    FP("\\newenvironment{indentright}{\\begin{list}%");
    FP("{}{\\rightmargin=\\leftmargin%");
    FP("\\leftmargin=0mm}\\item[]}%");
    FP("{\\end{list}}");
    FP("\\newenvironment{nofill}{\\parindent=0mm\\obeylines}{\\par}");
    if (!printpagenum) {
        FP("\\pagestyle{empty}");
    }
    FP("\\begin{document}");
}


/* Writes the end of the LaTeX document in the LaTeX file. */

static void 
latex_enddoc(void)
{
    FP("\\end{document}");
}


/*
 * Returns the name of the input file treated by the command.
 */

static char *
inputfilename(void)
{
    char *filename, car;
    FILE *fp;

    if ((argc > 1) && (!isoption(argv[1]))) {
        return(argv[1]);
    } else {

/*
 * If mimep uses the standard input, dumps the informations into a 
 * temporary file, then, returns the name of this file.
 */

        filename = tempnam(TMPDIR, TMPREFIX);
        if (!(fp = fopen(filename, "w"))) {
            FPRINTF(stderr, ERR1);
        }
        while (fscanf(stdin, "%c", &car) != EOF) {
            FPRINTF(fp, "%c", car);
        }
        FCLOSE(fp);
        return(filename);
    }
}


/*   
 * Add a banner to the LaTeX document with the name of the user who prints
 * the message, the correspondants' addresses, the subject and the date of
 * the message.
 */

static void 
mk_headers(void)
{
    char *ch, **to, **cc, titlefrom[MAXF];
    int i;
    struct stat buf;

    set_input(fp_in);
    readline();
    if (end_of_file()) {
        FPRINTF(stderr, ERR2);
        exit(1);
    }

/* Parses the headers */

    parse_headers(0);    /* from mp */
    init_setup();        /* from mp */

/*
 * Builds the banner box on top of the message with the RFC 822
 * headers, then adds them to the LaTeX file.
 */

    FP("\\begin{flushleft}");

    FPRINTF(fp_out, "\\Large{%s \\textbf{%s}}\n",
                    TITLEH_TO, (owner) ? text2latex(owner) : UNKNOWN);

    if ((ch = get_from_hdr())) {
        if ((MAXTFROM) && (strlen(ch) > MAXTFROM)) {
            STRNCPY(titlefrom, text2latex(ch), MAXTFROM);
            titlefrom[MAXTFROM] = EOS;
        } else {
            STRCPY(titlefrom, text2latex(ch));
        }
    }
    FPRINTF(fp_out, "\\titleh{\\large{\\begin{description}\\itemsep=%dpt\\item[\\textnormal{%s}] \\textbf{%s}%%\n",
                   ITEMSEP, TITLEH_FROM, (ch) ? titlefrom : NONE);

    FPRINTF(fp_out, "\\item[\\textnormal{%s}] \\textbf{%s}%%\n",
            TITLEH_SUBJECT, (ch = get_subject_hdr()) ? text2latex(ch) : NONE);

    FPRINTF(fp_out, 
            "\\item[\\textnormal{%s}] \\textbf{%s}\\end{description}}}\n",
            TITLEH_DATE, (ch = get_date_hdr()) ? text2latex(ch) : NONE);

    FPRINTF(fp_out, "\\vspace{%dpt}", SEP1);

/* Adds extra headers depending on the user's configuration */

    if (istoprint(FROMHDR)) {
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n",
                H_FROM, (ch = get_from_hdr()) ? text2latex(ch) : NONE);
    }

    if (istoprint(TOHDR)) {
        to = get_to_hdr();
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n", H_TO,
                (to[0]) ? text2latex(to[0]) : NONE);
        i = 1;
        while (to[i]) {
            FPRINTF(fp_out, "\\small{ %s}\\\\\n", text2latex(to[i]));
            i++;
        }
    }
    if (istoprint(SUBJECTHDR)) {
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n", H_SUBJECT,
                (ch = get_subject_hdr()) ? text2latex(ch) : NONE);
    }

    if (istoprint(DATEHDR)) {
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n", H_DATE,
                (ch = get_date_hdr()) ? text2latex(ch) : NONE);
    }

    if (istoprint(CCHDR)) {
        cc = get_cc_hdr();
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n", H_CC,
                (cc[0]) ? text2latex(cc[0]) : NONE);
        i = 1;
        while (cc[i]) {
            FPRINTF(fp_out, "\\small{ %s}\\\\\n", text2latex(cc[i]));
            i++;
        }
    }

    if (istoprint(APP_FROMHDR)) {
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n", H_APPFROM,
                (ch = get_appfrom_hdr()) ? text2latex(ch) : NONE);
    }

    if (istoprint(APP_TOHDR)) {
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n", H_APPTO,
                (ch = get_appto_hdr()) ? text2latex(ch) : NONE);
    }

    if (istoprint(REPLYHDR)) {
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n", H_REPLY,
                (ch = get_replyto_hdr()) ? text2latex(ch) : NONE);
    }

    if ((istoprint(NEWSGROUPSHDR)) || (istoprint(NEWSGROUPHDR))) {
        FPRINTF(fp_out, "\\small{{\\bf %s} %s}\\\\\n", H_NEWSGROUP,
                (ch = get_newsgroups_hdr()) ? text2latex(ch) : NONE);
    }

/* Adds a boundary. */

    if (boundary) {
        if (strcmp(boundary, NOB)) {
            FP("\\begin{center}");

            if (!strcmp(boundary, DEFAULTB)) {
                FPRINTF(fp_out, "\\rule{\\textwidth}{%spt}\n", RULEH);
            } else if (!stat(boundary, &buf)) {
                FPRINTF(fp_out, "\\includegraphics{%s}\n", boundary);
            }

            FP("\\end{center}");
        }
    }

    FPRINTF(fp_out, "\\vspace{%dpt}", SEP2);
    FP("\\end{flushleft}");
}


/* Returns the name of the output file. */

static char *
outputfilename(void)
{
    int nopt;

    if ((nopt = isopt("-o")) != 0 && (nopt + 1 < argc)) {
        return(argv[nopt + 1]);
    } else {
        return(NOOUTPUTFILE);     /* if the user doesn't want any */
    }
}


/*
 * If the RFC 822 header referenced by hdr is to print, returns True, else
 * False.
 */

static bool 
istoprint(char *hdr)
{
    if (((printable(hdr)) && ((!issubopt(isopt("-rmhdrs"), hdr)))) ||
        (issubopt(isopt("-addhdrs"), hdr)) || (isopt("-allheaders"))) {
        return(True);
    }

    return(False);
}


/* Removes the suffix of a file in a path. */

static char *
removesuffix(char *src_filename)
{
    int i;
    static char *tgt_filename;
    int nbcar = 0;

    for (i = 0; i < strlen(src_filename); i++) {
        if (src_filename[i] == SLASH) {
            nbcar = 0;
        }
        if (src_filename[i] == POINT) {
            nbcar = i;
        }
    }
    if (!nbcar) {
        return(src_filename);
    }

    tgt_filename = (char *) malloc(sizeof(char) * (nbcar + 1));

    STRNCPY(tgt_filename, src_filename, nbcar);
    tgt_filename[nbcar] = EOS;

    return(tgt_filename);
}


/*
 * Sets the MIMEPMAXCH environment variable to the maximum number of
 * characters in a line. (for the cutlines command for instance ...)
 */

static void 
maxcarnb(int typeSize)
{
    static char maxcarstr[16];

    STRCPY(maxcarstr, MIMEPMAXCH);
    STRCAT(maxcarstr, nbmaxcar[typeSize - 10]);
    PUTENV(maxcarstr);
}


/*
 * Converts a simple text line into LaTeX. (useful when there are some
 * special symbols in the text.)
 */

static char *
text2latex(char *src_str)
{
    char *tgt_str, carcour;
    int  i, k, length;
    bool trouve;

    if (!src_str) {
        return(NULL);
    }
    tgt_str = (char *) malloc(sizeof(char) * 1024);
    tgt_str[0] = EOS;

    for (i = 0; i < strlen(src_str); i++) {
        k = 0;
        trouve = False;
        carcour = src_str[i];

        while ((specar[k]) && (!trouve)) {
            if (((char) *specar[k] == carcour) && (specar[k + 1])) {
                STRCAT(tgt_str, specar[k + 1]);
                trouve = True;
            }
            if (!trouve) {
                k += 2;
            }
        }
        if (!trouve) {
            length = strlen(tgt_str);
            tgt_str[length] = carcour;
            tgt_str[length + 1] = EOS;
        }
    }

    return(tgt_str);
}


/* Returns the path to a file. */

static char *
getdir(char *path)
{
    static char *path_ret;
    char *pslash;

    path_ret = (char *) malloc(sizeof(char) * (strlen(path) + 1));
    STRCPY(path_ret, path);

    if ((pslash = rindex(path_ret, SLASH))) {
        *pslash = EOS;
        return(path_ret);
    }

    return(NULL);
}


/* Treats the X-resources and the options of the command line. */

static void 
treat_options(void)
{
    int optnum;
    char mailcapath[MAXARRAY];

    Option();                  /* mp */
    get_appname(argc, argv);   /* mp */
    read_resources();          /* mp */

/* Verifies wether the command line is coherent (with the usage) or not ... */

    if (!iscoherent_com_line(argc, argv, args, 0)) {
        usage(args, comments);
    }

/* Determines the name of the printer on which it can print */

    printername = str_opt_val(O_PR_NAME);
    if ((optnum = isopt("-printer"))) {
        printername = argv[optnum + 1];
    }

/* Determines if the output is to a file */

    if (isopt("-o")) {
        tofile = True;
        toprinter = False;
    } else {
        tofile = False;
    }

/* Do we have to print even if the -o option is set ? */

    if ((isopt("-fp")) || (isopt("-printer"))) {
        toprinter = True;
    }

/* Is the output the standard output ? */

    if (isopt("-f")) {
        toprinter = False;
        tofile = False;
        tostdout = True;
    } else {
        tostdout = False;
    }

/* Do we have to print the burst page ? */

    if (int_opt_val(O_BURSTPAGE)) {
        burstpage = True;
    } else {
        burstpage = False;
    }

    if (isopt("-noburstpage")) {
        burstpage = False;
    }

/* Determines the paper size. */

    if (paper_size == P_NONE) {
        paper_size = P_A4;
    }

    if (isopt("-a4")) {
        paper_size = P_A4;
    } else if (isopt("-us")) {
        paper_size = P_US;
    }

/* Same with type size (characters) */

    if ((optnum = isopt("-typesize")) != 0 && (optnum + 1 < argc)) {
        typesize = atoi(argv[optnum + 1]);
    }

    if (typesize < MINTSIZE) {
        typesize = MINTSIZE;
    } else if (typesize > MAXTSIZE) {
        typesize = MAXTSIZE;
    }

/* Do we have to print the page numbers ? */

    if (!int_opt_val(O_PAGIN)) {
        printpagenum = False;
    } else {
        printpagenum = True;
    }

    if (isopt("-nopagenum")) {
        printpagenum = False;
    }

/* Sets the path of the mailcap file if the user specified one. */

    if ((optnum = isopt("-mailcap"))) {
        STRCPY(mailcapath, MIMEPMAILCAP);
        STRCAT(mailcapath, argv[optnum + 1]);
        PUTENV(mailcapath);
    }
    if (_TRACE) {
        FPRINTF(stderr, "paperSize: %s\n", (paper_size == P_A4) ? "A4" : "US");
        FPRINTF(stderr, "boundary:  %s\n", (boundary) ? boundary : "");
        FPRINTF(stderr, "typeSize:  %d\n", typesize);
        FPRINTF(stderr, "paginate:  %s\n", (printpagenum) ? "True" : "False");
    }
}


/* Removes the temporary files. */

static void 
clean(void)
{
    char comm_rm[MAXARRAY];

    STRCPY(comm_rm, RM);
    STRCAT(comm_rm, TMPDIR);
    STRCAT(comm_rm, SLASHSTR);
    STRCAT(comm_rm, TMPREFIX);
    STRCAT(comm_rm, STAR);
    SYSTEM(comm_rm);

    STRCPY(comm_rm, RM);
    STRCAT(comm_rm, TMPDIR);
    STRCAT(comm_rm, SLASHSTR);
    STRCAT(comm_rm, MMPREFIX);
    STRCAT(comm_rm, STAR);
    SYSTEM(comm_rm);
}
