/***************************************************************************
                          connectinfo.cpp  -  description
                             -------------------
    begin                : Sat Aug 11 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>

#include <iostream.h>

#include "connectinfo.h"
#include "utils.h"

ConnectInfo::ConnectInfo(QWidget* parent, const char* name)
     : QDialog (parent, name, true)
{
     initDialog();
     setOptions();

     connect (butok, SIGNAL(clicked()), SLOT (slotbutok()));
     connect (butcancel, SIGNAL(clicked()), SLOT (slotbutcancel()));
}

ConnectInfo::~ConnectInfo(){
}


void ConnectInfo::initDialog()
{
     setCaption(i18n("Error Connecting DataBase"));

     QGridLayout* grid = new QGridLayout (this,2,3,8,20);

     QGroupBox* group = new QGroupBox (this);
     group->setTitle(i18n("DataBase Info"));
     grid->addMultiCellWidget(group, 0, 0, 0, 2);

     QGridLayout* grid1 = new QGridLayout (group, 4, 2, 18, 4);

     QLabel *lhost= new QLabel(i18n("Host"), group);
     grid1->addWidget(lhost, 0,0);
     host = new QLineEdit(group);
     grid1->addWidget(host,0,1);

      QLabel *luser= new QLabel(i18n("User"), group);
     grid1->addWidget(luser, 1,0);
     user = new QLineEdit(group);
     grid1->addWidget(user,1,1);

     QLabel *lpassword= new QLabel(i18n("Password"), group);
     grid1->addWidget(lpassword, 2,0);
     password = new QLineEdit(group);
     password->setEchoMode(QLineEdit::Password);
     grid1->addWidget(password,2,1);

     QLabel *ldatabase= new QLabel(i18n("DataBase"), group);
     grid1->addWidget(ldatabase, 3,0);
     database = new QLineEdit(group);
     grid1->addWidget(database,3,1);

     butok = new QPushButton (this, "Push_OK");
     butok->resize (butok->sizeHint() );
     butok->setText( i18n("Ok") );
     grid->addWidget (butok, 1,0);

     butcancel = new QPushButton( this, "Push_Cancel" );
     grid->addWidget(butcancel,1,2);
     butcancel->resize (butcancel->sizeHint() );
     butcancel->setText( i18n("Cancel") );

     host->setFocus();
     resize (310, 210);
}

void ConnectInfo::setOptions()
{
  KConfig *config;
  config = kapp->config();

  config->setGroup("DataBase");

  host->setText(config->readEntry("Host", "localhost"));
  user->setText(config->readEntry("User", "mp3kult"));
  password->setText(Utils::decryptStr(config->readEntry("Password", Utils::encryptStr("mp3kult"))));
  database->setText(config->readEntry("DB", "Mp3Kult"));
}

void ConnectInfo::slotbutok()
{
    done (0);

}

void ConnectInfo::slotbutcancel()
{
    done(1);
}



#include "connectinfo.moc"

