/***************************************************************************
                          mp3kult.cpp  -  description
                             -------------------
    begin                : Tue Feb 13 15:23:55 /etc/localtime 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qfont.h>
#include <qfileinfo.h>
#include <qlist.h>
#include <qvaluelist.h>
#include <qheader.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <kstdaccel.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kpopupmenu.h>
#include <kprocess.h>
#include <kguiitem.h>
#include <kstatusbar.h>

#include <iostream.h>

// application specific includes
#include "mp3kult.h"
#include "mp3kultview.h"
#include "newvolume.h"
#include "preferences.h"
#include "addcd.h"
#include "delvolume.h"
#include "updatevol.h"
#include "addmp3.h"
#include "plview.h"
#include "item.h"
#include "edittag.h"
#include "connectinfo.h"
#include "utils.h"
#include "rename.h"
#include "createdb.h"
#include "../config.h"
#include <stdlib.h>

#define ID_STATUS_MSG 1
#define ID_TOTAL_MP3 2


Mp3KultApp::Mp3KultApp(QWidget* , const char* name):KDockMainWindow(0, name)
{
  config=kapp->config();
  kapp->setMainWidget(this);
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  //initDataBase();
	//db = new MyDb();
	initAll = false;
  bool dbConnect = initDataBase();
	checkVersion();
  initStatusBar();
  initView();
  initActions();
  initFind();
  readOptions();


  connect (find, SIGNAL(search(QString, bool)), view, SLOT(slotsearch(QString, bool)));
  connect (find, SIGNAL(advsearch(QString, bool, const bool*)), view, SLOT(slotadvsearch(QString, bool, const bool*)));
  connect (view->getListView(), SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT(slotPopupMenu ( QListViewItem *, const QPoint &, int )));
  connect (plview->getListView(), SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT(slotPLPopupMenu ( QListViewItem *, const QPoint &, int )));
  connect (view->getListView(), SIGNAL(doubleClicked ( QListViewItem *)), this, SLOT(slotPlaySong ( QListViewItem *)));
	connect (view->getListView(), SIGNAL(returnPressed ( QListViewItem *)), this, SLOT(slotPlaySong ( QListViewItem *)));
	connect (plview->getListView(), SIGNAL(doubleClicked ( QListViewItem *)), this, SLOT(slotPLPlaySong ( QListViewItem *)));
  connect (plview->playPL, SIGNAL(clicked()), this, SLOT(slotPopupPLPlayAllSong()));
  connect (pldock, SIGNAL(headerCloseButtonClicked ()), this, SLOT(slotHeaderCloseButton()));
	connect (viewToggleTreeView, SIGNAL(toggled(bool)), this, SLOT(slotViewTreeOptions(bool)));

  if (hidePL)
  {
    // If I don't write this function twice, pldock doesn't hide, why ?
    pldock->changeHideShowState();
    pldock->changeHideShowState();

    // If Playlist is hided, its actions are disabled
    dePLActions();
  }

  if (!dbConnect)
  {
		show();
		insertInfoDB();
		cerr << "Show Info DB" << endl;
  }
	initAll = true;
  plview->viewPL();
  view->viewallmp3(this);
}

Mp3KultApp::~Mp3KultApp()
{

}

void Mp3KultApp::initActions()
{

  fileEraseDb = new KAction(i18n("Erase DB"), "eraser", 0, this, SLOT(slotEraseDb()), actionCollection(), "erase_db");
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection(), "file_quit");
  fileRefreshList = new KAction (i18n("Refresh List"), "reload", KStdAccel::key(KStdAccel::Reload), this, SLOT(slotFileRefresh()), actionCollection(), "file_refresh_list");
  fileExport = new KAction(i18n("Export"), CTRL+Key_E, view, SLOT(slotExport()), actionCollection(), "file_export");
  fileExportSelected = new KAction(i18n("Export Selected"), CTRL+Key_W, view, SLOT(slotExportSelected()), actionCollection(), "file_export_selected");
  plDel = new KAction(i18n("Delete"),"pl_del", 0, plview, SLOT(slotDelete()), actionCollection(), "pl_delete");
  plNew = new KAction(i18n("New"),"pl_new", CTRL+Key_L, plview, SLOT(slotNew()), actionCollection(), "pl_new");
  plSave =  new KAction(i18n("Save"),"pl_save", CTRL+Key_S, plview, SLOT(slotSave()), actionCollection(), "pl_save");
  plLocal =  new KAction(i18n("Make local playlist"), 0, plview, SLOT(slotLocalPL()), actionCollection(), "pl_local");
  plRefreshStatus = new KAction(i18n("Refresh playlist status"), Key_F6, plview, SLOT(slotRefreshStatus()), actionCollection(), "pl_refresh_status");
  plExport = new KAction(i18n("Write M3u"), CTRL+Key_M, plview, SLOT(slotExport()), actionCollection(), "pl_export");
  plImport = new KAction(i18n("Import M3u"), 0, plview, SLOT(slotImport()), actionCollection(), "pl_import");
	plRename = new KAction(i18n("Rename PlayList"), 0, plview, SLOT(slotRename()), actionCollection(), "pl_rename");
	searchFind = new KAction (i18n("Find"), "find", KStdAccel::key(KStdAccel::Find), this, SLOT(slotFind()), actionCollection(), "find");
  searchFindNext = new KAction (i18n("Find Next"), "next", KStdAccel::key(KStdAccel::FindNext), this, SLOT(slotFindNext()), actionCollection(), "find_next");
  settingsPreferences = new KAction (i18n("Preferences"), "configure", 0, this, SLOT(slotPreferences()), actionCollection(), "preferences");
	viewToggleTreeView = new KToggleAction (i18n("Tree View"), 0, view, SLOT(slotToggleTreeView()), actionCollection(), "view_toggle_tree_view");
	viewToggleFindInAllTree = new KToggleAction (i18n("Find in Closed"), 0, view, SLOT(slotToggleFindInAllTree()), actionCollection(), "view_toggle_find_in_all_tree");
	viewTreeOpenAll = new KAction (i18n("Open All"), 0, view, SLOT(slotTreeOpenAll()), actionCollection(), "view_tree_open_all");
	viewTreeCloseAll = new KAction (i18n("Close All"), 0, view, SLOT(slotTreeCloseAll()), actionCollection(), "view_tree_close_all");
	volumeAdd = new KAction(i18n("Add Volume"), "add_volume", CTRL+Key_N, this, SLOT(slotVolumeAdd()), actionCollection(), "volume_add");
  volumeAddCd = new KAction(i18n("Add Cd-Rom"), "add_cd", CTRL+Key_R, this, SLOT(slotVolumeAddCd()), actionCollection(), "volume_add_cd");
  volumeDel = new KAction (i18n("Remove Volume"), "eraser", CTRL+Key_D, this, SLOT(slotVolumeDel()), actionCollection(), "volume_del");
  volumeUpdate = new KAction (i18n("Update Volume"), CTRL+Key_U, this, SLOT(slotVolumeUpdate()), actionCollection(), "volume_update");
  volumeAddMp3 = new KAction (i18n("Add Mp3/Ogg to Volume"), 0, this, SLOT(slotVolumeAddMp3()), actionCollection(), "volume_add_mp3");
	volumeRename = new KAction (i18n("Rename Volume"), 0, this, SLOT(slotVolumeRename()), actionCollection(), "volume_rename");
	viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
  viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());

  togglePL = new KAction(i18n("Hide/View PlayLists editor"), "hide_view_pl", 0, this, SLOT(slotTogglePL()), actionCollection(), "toggle_pl");
  popupAddSongsPL = new KAction(i18n("Add Songs to PlayList"), 0, this, SLOT(slotPopupAddSongsPL()), actionCollection(), "popup_add_songs_pl");
  //popupAddSelected = new KAction(i18n("Add Selected to Playlist"), 0, this, SLOT(slotPopupAddSelected()), actionCollection(), "popup_add_selected");
  popupDelMp3 = new KAction(i18n("Remove Entries"), 0, this, SLOT(slotPopupDelMp3()), actionCollection(), "popup_del_mp3");
  popupPlaySongs = new KAction(i18n("Play songs"), 0, this, SLOT(slotPopupPlaySongs()), actionCollection(), "popup_play_songs");
	popupEnqueueSongs = new KAction(i18n("Enqueue songs"), 0, this, SLOT(slotPopupEnqueueSongs()), actionCollection(), "popup_enqueue_songs");
	popupEditTag =  new KAction(i18n("Edit Tag"), 0, this, SLOT(slotPopupEditTag()), actionCollection(), "popup_edit_tag");

  popupPLPlaySongs = new KAction(i18n("Play songs"), 0, this, SLOT(slotPopupPLPlaySongs()), actionCollection(), "popup_pl_play_songs");
	popupPLEnqueueSongs = new KAction(i18n("Enqueue songs"), 0, this, SLOT(slotPopupPLEnqueueSongs()), actionCollection(), "popup_pl_enqueue_songs");
	popupPLRemoveSongs = new KAction(i18n("Remove songs"), 0, plview, SLOT(slotRemoveSongs()), actionCollection(), "popup_pl_remove_songs");
  //popupPLRemoveSelected = new KAction(i18n("Remove Selected songs"), 0, plview, SLOT(slotRemoveSelected()), actionCollection(), "popup_pl_remove_selected");
  popupPLPlayAllSong = new KAction(i18n("Play all songs"), 0, this, SLOT(slotPopupPLPlayAllSong()), actionCollection(), "popup_pl_play_all_song");

  fileQuit->setStatusText(i18n("Quits the application"));
  plDel->setStatusText(i18n("Deletes current playlist"));
  plNew->setStatusText(i18n("Creates a new playlist"));
  plSave->setStatusText(i18n("Saves current playlist"));
  plLocal->setStatusText(i18n("Creates a local copy of songs in current playlist"));
  volumeAdd->setStatusText(i18n("Adds a new volume to DataBase"));
  volumeAddCd->setStatusText(i18n("Adds a new Cd-Rom to DataBase"));
  volumeDel->setStatusText(i18n("Removes a volume from DataBase"));
  volumeUpdate->setStatusText(i18n("Rescans all directories of a volume"));
  volumeAddMp3->setStatusText(i18n("Adds a Mp3 to an existing volume"));
  viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
  viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

  // use the absolute path to your mp3kultui.rc file for testing purpose in createGUI();
  createGUI();

}

void Mp3KultApp::connectToDB()
{
	if (!(initDataBase()))
	{
		insertInfoDB();
	}
}

bool Mp3KultApp::initDataBase()
{
  db = new MyDb();
  config->setGroup("DataBase");
  bool conn;
	//cerr << " password : " << Utils::decryptStr("") << endl;
  conn = db->dbConnect(config->readEntry("Host", "localhost"),
                      config->readEntry("User", "mp3kult"),
                      Utils::decryptStr(config->readEntry("Password", Utils::encryptStr("mp3kult"))),
                      config->readEntry("DB", "Mp3KultB"));

  if (!conn)
    cerr << "Error Connecting to DataBase" << endl;

  return conn;


}


void Mp3KultApp::insertInfoDB()
{
	bool conn = false;
	while (!conn)
	{
		KGuiItem butCreate(i18n("Create")), butConfig(i18n("Config"));

		int res = KMessageBox::warningYesNoCancel (this, i18n("Error connecting to DataBase\n"
                                        "If it's your first start of Mp3Kult,\n"
																				"click on Create to create the DataBase !\n"
																				"Otherwise click on Config to change \n"
																				"the configuration of DataBase"),
								i18n("Error!") , butCreate, butConfig);
      /*int res = KMessageBox::questionYesNo(this, i18n("Error connecting to\n"
                                                      "DataBase\n"
                                                      "Do you want to change\n"
                                                      "its configuration ? "),
                                        i18n("Error!"));*/
		if (res == 4)
		{
			ConnectInfo infoConn(this);

			if (infoConn.exec() == 0)
			{
				//cerr << "Tento connessione" << endl;
				if ((db->dbConnect(infoConn.getHost(),infoConn.getUser(), infoConn.getPassword(),
                            infoConn.getDataBase())))
				{
					config->setGroup("DataBase");
					//cerr << "Connessione avvenuta, salvo opzioni" << endl;
					conn = true;
					config->writeEntry("Host",infoConn.getHost());
					config->writeEntry("User",infoConn.getUser());
					config->writeEntry("Password", Utils::encryptStr(infoConn.getPassword()));
					config->writeEntry("DB", infoConn.getDataBase());
				}
				else
					KMessageBox::error(this, i18n("DataBase Connection Failed !\n"
																					"Error connecting to DataBase\n"
																					"Please, reinsert data"),
                                        i18n("DataBase Creation Failed !"));
			}
			else
			{
				cerr << "Configuration Not Changed " << endl;
				continue;
			}
		}
		else if(res == 3)
		{
			CreateDB createdb(this);
			if (createdb.exec() == 0)
			{
				//cerr << "Tento connessione" << endl;
				if ((db->dbCreate (createdb.getHost(),createdb.getUser(),createdb.getPassword(),
								createdb.getDataBase(), createdb.getAdminPass(), createdb.getAdminUser())))
				{
					if ((db->dbConnect(createdb.getHost(),createdb.getUser(), createdb.getPassword(),
                            createdb.getDataBase())))
					{
						config->setGroup("DataBase");
						//cerr << "Connessione avvenuta, salvo opzioni" << endl;
						conn = true;
						config->writeEntry("Host",createdb.getHost());
						config->writeEntry("User",createdb.getUser());
						config->writeEntry("Password", Utils::encryptStr(createdb.getPassword()));
						config->writeEntry("DB", createdb.getDataBase());
					}
				}
				else
					KMessageBox::error(this, i18n("DataBase Creation Failed!  \n"
																					"Admin User or Admin Password or Host\n"
																					"could be incorrect !"),
                                        i18n("DataBase Creation Failed !"));
			}
			else
			{
				cerr << "Database Not Created" << endl;
				continue;
			}
		}
		else
		{
			cerr << "Not Change" << endl;
			exit(0);
		}
	}
}

void Mp3KultApp::checkVersion()
{
	QString version;
	config->setGroup("OPTIONS");
	version = config->readEntry("Version");

	if (version != VERSION)
	{
		config->writeEntry ("Version", VERSION);
	}
	cerr << "Version: "<< VERSION << endl;
}



void Mp3KultApp::initFind()
{
     find = new Mp3Find();
}

void Mp3KultApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
  statusBar()->insertItem(i18n("Total Mp3s : "), ID_TOTAL_MP3);
  progressBar = new KProgress(statusBar(), "progressBar");

  progressBar->setFixedWidth( 200 );
  progressBar->setFixedHeight(progressBar->sizeHint().height() - 4 );
  statusBar()->addWidget(progressBar,0 , true);

  cerr << "StatusBar initialized" << endl;
}

void Mp3KultApp::initView()
{
  maindock = createDockWidget( "Mp3List", 0 );
  setView(maindock);
  setMainDockWidget( maindock );
  maindock->setEnableDocking( KDockWidget::DockNone);

  pldock=createDockWidget( "PlayList", 0, 0L,
                              i18n("PlayList"));


  if (config->hasGroup("dock_setting_default"))
  {
		// use the last placements
    readDockConfig(config);
  }
  else
  {
    pldock->manualDock(maindock, KDockWidget::DockRight, 70);
  }

  // PlayList DockWidget can't be put out of window

  pldock->setEnableDocking( KDockWidget::DockCorner);
  pldock->setDockSite( KDockWidget::DockCorner);



  view = new Mp3KultView(db, maindock);
  connect (view, SIGNAL (viewallmp3Total(int)), this, SLOT (slotTotalMp3Msg(int)));

  plview = new PLView(db, pldock);

  maindock->setWidget(view);
  pldock->setWidget(plview);

  plview->setMp3KultView(view);
 // kapp->setMainWidget(maindock);
  /*
	view = new Mp3KultView(db, this);
	splitter = new QSplitter(view);
  connect (view, SIGNAL (viewallmp3Total(int)), this, SLOT (slotTotalMp3Msg(int)));
	setView(view);
  plview = new PLView(db, splitter);*/
  cerr << "View Initialized" << endl;
}

void Mp3KultApp::dePLActions()
{
     if (hidePL)
     {
          plDel->setEnabled(false);
          plSave->setEnabled(false);
          plNew->setEnabled(false);
          plLocal->setEnabled(false);
          plExport->setEnabled(false);
          plRefreshStatus->setEnabled(false);
          popupAddSongsPL->setEnabled(false);
          //popupAddSelected->setEnabled(false);
     }
     else
     {
         plDel->setEnabled(true);
         plSave->setEnabled(true);
         plNew->setEnabled(true);
         plLocal->setEnabled(true);
         plExport->setEnabled(true);
         plRefreshStatus->setEnabled(true);
         popupAddSongsPL->setEnabled(true);
         //popupAddSelected->setEnabled(true);
     }
}


void Mp3KultApp::saveOptions()
{
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  cerr << "Write Geometry\n";
  config->writeEntry("Show Toolbar", viewToolBar->isChecked());
  cerr << "Write Toolbar\n";
  config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
  cerr << "Write Statusbar \n";
  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
  cerr << "Write Toolbarpos \n";

  if(!hidePL)
  {
     writeDockConfig(config);
     cerr << "Write DockConfig \n";
  }

  config->setGroup("DockConfig");
     config->writeEntry("HidePL", hidePL);
     cerr << "Write HidePL \n";

}


void Mp3KultApp::readOptions()
{
     QFont font;

  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();


  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);


  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }
  else
  {
     resize(700, 400);
  }

  config->setGroup("OPTIONS");
  filetype = config->readNumEntry("FileType", 0);

  config->setGroup("Font");
     font.setFamily(config->readEntry("Family","Helvetica"));
     font.setPointSize(config->readNumEntry("Size",12));
     font.setWeight(config->readNumEntry("Weight",50));
     font.setItalic(config->readBoolEntry("Italic",false));
     view->setFont(font);
     plview->setFont(font);
  config->setGroup("DockConfig");
     hidePL = config->readBoolEntry("HidePL", true);

  config->setGroup("Player");
     playerExe = config->readEntry ("PlayerExe", "");

     if (playerExe.contains("xmms"))
          playerOpt = "-e";
     else if (playerExe.contains("gqmpeg"))
          playerOpt = "-pladd";
     else
          playerOpt = "";

	config->setGroup("View");
		viewToggleTreeView->setChecked(config->readBoolEntry("TreeView", false));
		slotViewTreeOptions(config->readBoolEntry("TreeView", false));
		viewToggleFindInAllTree->setChecked(config->readBoolEntry ("FindAll", false));
  cerr << "Options read" << endl;
}


bool Mp3KultApp::queryExit()
{
  cerr << "Exiting .... " << endl;
  if (initAll) {
  	if(!plview->getSaved())
  	{
       	if((KMessageBox::warningYesNo(this,
                    i18n("This PlayList has been modified \n"
                         "Would you like to save it ?")))== 3)
               plview->slotSave();
  	}
  	saveOptions();
	view->saveOptions();
  }
  return true;
}

void Mp3KultApp::initProgBar(int max)
{
     progressBar->setTextEnabled(true);
     progressBar->setRange(0, max);
}

void Mp3KultApp::advProgBar(int val)
{
     progressBar->advance(val);
}

void Mp3KultApp::resetProgBar()
{
     progressBar->setTextEnabled(false);
     progressBar->setValue(0);
}

void Mp3KultApp::setCursorBusy(bool b)
{
  if(b) kapp->setOverrideCursor(waitCursor);
  else  kapp->restoreOverrideCursor();
}
/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void Mp3KultApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }

  slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  //cerr << "Escooooooooooo" << endl;
  /*saveOptions();*/
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
 /* KMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
     cerr << "Close Window \n";
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
	break;
    }
  }
  slotStatusMsg(i18n("Ready."));
  cerr << "write slot status message \n";  */
  close();
}


void Mp3KultApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggling toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if(!viewToolBar->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }

  slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!viewStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }

  slotStatusMsg(i18n("Ready."));
}


void Mp3KultApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}

void Mp3KultApp::slotTotalMp3Msg(const int total)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  char buf[96];;

  sprintf (buf, "%d", total);
  statusBar()->clear();
  statusBar()->changeItem(i18n("Total Mp3s : ") + buf + " ", ID_TOTAL_MP3);
  cerr << "Total mp3s: " << total << endl;
}

 /*
void Mp3KultApp::slotTotalPLLength(const QString length)
{

  statusBar()->clear();
  cerr << "totale" << length << '\n';
  statusBar()->changeItem(i18n("Total Length: ") + length, ID_TOTAL_PL_LENGTH);
} */

void Mp3KultApp::slotFileRefresh()
{
     view->viewallmp3();
}

void Mp3KultApp::slotVolumeAdd()
{

  NewVolume newvol(db, this) ;
  slotStatusMsg(i18n("Adding Volume..."));
  if (newvol.exec()==0)
  {
     // MyDb* db= new MyDb();
     setCursorBusy(true);
     db->addVolume(newvol.getDirBase(), newvol.getRecursive(), newvol.getVolName(), filetype);
		 cerr << "Volume Added" << endl;
     view->viewVolume(newvol.getVolName());
     setCursorBusy(false);
  }
  slotStatusMsg(i18n("Ready."));

}

void Mp3KultApp::slotEraseDb()
{
     int response;

     slotStatusMsg(i18n("Deleting DB..."));

     response=KMessageBox::questionYesNo(this, i18n("Do you want to \n"
                                           "ERASE your DataBase \n"
                                           "permanently ? \n"),
                                        i18n("DB erasing confirmation"));
     if (response==3)
     {
          // MyDb* db=new MyDb();
          setCursorBusy(true);
          db->delAll();
          view->viewallmp3();
          setCursorBusy(false);
     }

     slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotFind()
{
	int centreX, centreY;
     slotStatusMsg(i18n("Finding..."));
	centreX = this->x() + (this->width()/2);
	centreY = this->y() + (this->height()/2);
	find->move(centreX - (find->width()/2), centreY - (find->height()/2));
     find->show();
     slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotFindNext()
{
     find->findnext();
}

void Mp3KultApp::slotPreferences()
{
     Preferences pref(this);

     slotStatusMsg(i18n("Setting Preferences..."));

     if (pref.exec())
     {
         /* KConfig config;
          config = kapp->config();   */
          config->setGroup("OPTIONS");
          filetype = config->readNumEntry("FileType", 0);
          view->setFont(pref.getFont());
          plview->setFont(pref.getFont());
          playerExe = pref.getPlayerExe();

          if (playerExe.contains("xmms"))
               playerOpt = "-e";
          else if (playerExe.contains("gqmpeg"))
               playerOpt = "-pladd";
          else
               playerOpt = "";
       /*   playerPath = pref.getPlayerPath();*/

       // View - Hide Columns code
        QValueList<int> lst,lst2;
        QHeader *h = view->getListView()->header();
        config->setGroup("View");
        lst = config->readIntListEntry("ColumnsVis");
        lst2 = config->readIntListEntry("ColumnsWidth");
            if (lst.count()==NUMCOL)
            {
                QValueList<int>::Iterator it = lst.begin();
                for (int i= 0; i<NUMCOL; i++)
                {
                    // hide all columns that have lst bit set  0
                    if (!(*it))
                    {
                        h->setResizeEnabled(false,i);
                        h->resizeSection(i, 0);
                       // find->disableItem(i);
                    }
                    // if a column has lst bit set 1 and his width
                    // is 0, has to change column status hide -> visible
                    else if ((view->getListView()->columnWidth(i))== 0)
                    {
                        // if into config file there ColumnWidth entry
                        // mp3kult can set column to old width
                        if ( !(lst2.isEmpty()))
                        {
                            view->getListView()->setColumnWidth(i, lst2[i]);
                           // find->enableItem(i);
                        }
                        // if config file doesn't have a ColumnsWidth entry
                        // mp3kult set column width to a default value
                        else
                        {

                            view->getListView()->setColumnWidth(i, 90);
                            //find->enableItem(i);
                        }
                        // Column is visible then is resizable
                        h->setResizeEnabled(true,i);
                    }
                    ++it;
                }
            }

     }
     slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotVolumeAddCd()
{
  config->setGroup("OPTIONS");
  if (((config->readEntry ("Cdpath", "")).isEmpty()))
  {
     KMessageBox::error( this, i18n("Set Cd-Rom Mount Path  \n"
                                     "in configuration menu! \n"  ));
      return;
  }

  AddCd addcdrom(db, this) ;

  slotStatusMsg(i18n("Adding Cd-Rom..."));

  if (addcdrom.exec()==0)
  {
     setCursorBusy(true);
     addcdrom.adding(filetype);
		 cerr << "CdRom Added" << endl;
     view->viewVolume(addcdrom.getVolName());
     setCursorBusy(false);
  }

  slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotVolumeDel()
{
     DelVolume delvol(db, this);

     slotStatusMsg(i18n("Removing Volume..."));
     if (delvol.exec()==0)
     {
        int num;

          setCursorBusy(true);
          num = delvol.deleting();
          cerr << "Delete : " << num << endl;
          view->remViewVolume(delvol.getVolName(), num);
          setCursorBusy(false);
      }
     slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotVolumeUpdate()
{
     UpdateVolume upvol(db, this);

     slotStatusMsg(i18n("Updating Volume..."));
     if (upvol.exec()==0)
     {
          int del;
          setCursorBusy(true);
          del = upvol.updating(filetype);
          // cerr<< "del: " << del << endl;
          view->updateViewVolume(del, upvol.getVolName());
          setCursorBusy(false);
      }
     slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotVolumeAddMp3()
{
     //MYSQL_RES* res;
     AddMp3 addmp3(db, this);

     slotStatusMsg(i18n("Adding Mp3..."));
     if (addmp3.exec()==0)
     {
          // MyDb* db = new MyDb();
          if((db->addEntry(addmp3.getFilePath(), addmp3.getVolName(), filetype)))
          {
               db->getLastInsert();
               view->viewmp3(db->getRow());
               db->freeRes();
          }
          else
          {
               KMessageBox::error( this, i18n("Error reading this mp3"));
               return;
          }

     }
     slotStatusMsg(i18n("Ready."));
}

void Mp3KultApp::slotVolumeRename()
{
	Rename rename(db, this, 0, "Volume");

	if (rename.exec() == 0)
	{
		int renamed = db->renameVolume(rename.getNewName(), rename.getOldName());
		view->updateRenamed(renamed, rename.getOldName(), rename.getNewName());
		cerr << "Volume renamed: " << rename.getOldName() << endl;
	}
}

void Mp3KultApp::slotPopupMenu ( QListViewItem *, const QPoint &pos, int )
{

//   cerr << "Step 1"<< endl;
   QPopupMenu *pop = (QPopupMenu *)factory()->container("popup_menu", this);
//   cerr << "Step 2" <<  endl;
   pop->popup(pos);
//   cerr << "Step 3" << endl;
}


void Mp3KultApp::slotPLPopupMenu( QListViewItem *, const QPoint &pos, int )
{

//   cerr << "Step 1"<< endl;
   QPopupMenu *pop = (QPopupMenu *)factory()->container("popup_menu_pl", this);
//   cerr << "Step 2" <<  endl;
   pop->popup(pos);
//   cerr << "Step 3" << endl;
}


void Mp3KultApp::slotTogglePL()
{
     if(hidePL)
     {
         // cerr << "Change hidePL from " << hidePL << "To ";
          hidePL=false;
          dePLActions();
        //  cerr << hidePL << endl;
     }
     else
     {
         // cerr << "Change hidePL from " << hidePL << "To ";
          hidePL=true;
          dePLActions();
          //cerr << hidePL << endl;
     }
     pldock->changeHideShowState();
}

void Mp3KultApp::slotHeaderCloseButton()
{
     if(hidePL)
     {
          // cerr << "Change hidePL from " << hidePL << "To ";
          hidePL=false;
          dePLActions();
        //  cerr << hidePL << '\n';
     }
     else
     {
          // cerr << "Change hidePL from " << hidePL << "To ";
          hidePL=true;
          dePLActions();
         // cerr << hidePL << '\n';
     }
}


void Mp3KultApp::slotPopupEditTag()
{
     QListView* list;
     Mp3ListItem* item;
     QString mp3, ext;

     list=view->getListView();
     item = (Mp3ListItem*) list->currentItem();
     mp3= (item->text(ID_PATH))+"/"+item->text(ID_FNAME);

     QFileInfo file(mp3);
	cerr << "QFileInfo" << endl;


     if (!file.exists())
     {
          KMessageBox::error (this, i18n("File " +  item->text(ID_FNAME) + "\n"
                                        "doesn't exist"), i18n("File not found"));
          return;
     }

	ext = file.extension(false);

	if (ext.contains("mp3", false) < 1)
	{
		KMessageBox::error (this, i18n("Tag editor for ogg file\n"
																	"isn't implemented (for now)"), i18n("Ogg"));
		return;
	}
     if(!file.isWritable())
     {
          KMessageBox::error (this, i18n("File " +  item->text(ID_FNAME) + "\n"
                                        "is not writable !"),
                                        i18n("File not writable"));
          return;
     }

     EditTag edit(this, mp3);
     //slotStatusMsg(i18n("Editing Tag..."));
     if (edit.exec()==0)
     {
        //MyDb db;
        //MYSQL_RES* res;

        db->updateTag(mp3, item->getMp3id(), filetype);
        // cerr << "Tag Writed" << endl;
        db->getMp3(item->getMp3id());
         cerr << "Mp3 id: " << item->getMp3id() << " found" << endl;
        //list->takeItem(item);
				delete item;
         cerr << "Mp3 removed" << endl;
        view->decTotalMp3(1);
        view->viewmp3(db->getRow());
        db->freeRes();
         cerr << "Mp3 displaied" << endl;
     }
     //slotStatusMsg(i18n("Ready."));
}

/*void Mp3KultApp::slotPopupAddSongPL()
{
     QListView* list;
     Mp3ListItem* item;

     list=view->getListView();
     item = (Mp3ListItem*) list->currentItem();
     plview->addSong (item);
}*/

void Mp3KultApp::slotPopupAddSongsPL()
{

	Mp3List* list;
	//Mp3ListItem* item;

	list=view->getListView();
   /*  item = (Mp3ListItem*) list->currentItem();

     while ((item->itemAbove())!=NULL && (item->itemAbove()->isSelected()))
          item = item->itemAbove();

     while ((item != NULL) && (item->isSelected()))
     {
          plview->addSong(item);
          item = item->itemBelow();
     }*/
	QList<QListViewItem> itemList(list->selectedItems());
	QListIterator<QListViewItem> itemIt(itemList);

	while (itemIt.current())
	{
		//cerr << "pinser" << endl;
		plview->addSong((Mp3ListItem*)itemIt.current());
		++itemIt;
	}

}

void Mp3KultApp::slotPopupPLPlaySongs()
{
	playPLSongs(false);
}

void Mp3KultApp::slotPopupPLEnqueueSongs()
{
	playPLSongs(true);
}

void Mp3KultApp::playPLSongs(bool enqueue)
{

//PLListItem* plitem;
     QString mp3;

if (playerExe.isEmpty())
	{
		KMessageBox::error (this, i18n("Select a player in the Preferences"),
			i18n("Player not found"));
		//  cerr << "Player: " << playerExe << "\n";
		return;
	}

	/*plitem=(PLListItem*) plview->getListView()->currentItem();

	while ((plitem->itemAbove())!=NULL && (plitem->itemAbove()->isSelected()))
		plitem = plitem->itemAbove();*/

	KProcess p;

	p << playerExe;

	if (enqueue)
	{
		p << playerOpt;
	}
	else
	{
		if (playerExe.contains("gqmpeg"))
			p << "-pl";
	}

	QList<QListViewItem> itemList(plview->getListView()->selectedItems());
	QListIterator<QListViewItem> itemIt(itemList);

	while (/*(plitem != NULL) && (plitem->isSelected())*/itemIt.current())
	{
          //mp3= plitem->getFileN();
					mp3 =((PLListItem*)itemIt.current())->getFileN();

          QFileInfo file(mp3);

          if (!file.exists())
          {
               /*KMessageBox::error (this, i18n("File " +  mp3 + "\n"
                                        "doesn't exist"), i18n("File not found"));*/
               //plitem = plitem->itemBelow();
								++itemIt;
               continue;
          }
          p << mp3;
					/*toplay++;
					if (toplay%10 == 0)
					{
						cerr << "Play songs : " << toplay << endl;
						p.start( KProcess::DontCare);
						p.clearArguments();
						p.detach();
						p << playerExe << playerOpt;
					}*/
         /* plitem = plitem->itemBelow();*/++itemIt;
     }
     p.start( KProcess::DontCare);

}

void Mp3KultApp::slotPopupPLPlayAllSong()
{
	PLListItem* plitem;
	QString mp3;
	bool done = false;

	if (playerExe.isEmpty())
	{
		KMessageBox::error (this, i18n("Select a player in the Preferences"),
			i18n("Player not found"));
		//  cerr << "Player: " << playerExe << "\n";
		return;
	}

	KProcess p;
	plitem=(PLListItem*) plview->getListView()->firstChild();

	p << playerExe;

	if (playerExe.contains("gqmpeg"))
		p << "-pl";

	while (plitem)
	{
		mp3= plitem->getFileN();
		QFileInfo file(mp3);

		if (!file.exists())
		{
			/*KMessageBox::error (this, i18n("File " +  mp3 + "\n"
                                        "doesn't exist"), i18n("File not found"));*/
			plitem = plitem->itemBelow();
			continue;
		}
		done = true;
		p << mp3;
		plitem = plitem->itemBelow();
	}

	if (done)
		p.start( KProcess::DontCare);
	else
		KMessageBox::error (this, i18n("No files found"), i18n("Files not found"));
}

void Mp3KultApp::slotPlaySong(QListViewItem* item)
{
     QString mp3;

	if (item->text(ID_FNAME).isEmpty())
		return;

	if (playerExe.isEmpty())
	{
		KMessageBox::error (this, i18n("Select a player in the Preferences"),
			i18n("Player not found"));
		//  cerr << "Player: " << playerExe << "\n";
		return;
	}

	mp3= (item->text(ID_PATH))+"/"+item->text(ID_FNAME);

	QFileInfo file(mp3);

	if (!file.exists())
	{
		KMessageBox::error (this, i18n("File " +  item->text(ID_FNAME) + "\n"
                                        "doesn't exist"), i18n("File not found"));
		return;
	}
	KProcess p;

	if (!playerOpt.isEmpty())
		p << playerExe << playerOpt << mp3;
	else
		p << playerExe  << mp3;

	p.start( KProcess::DontCare);
}

void Mp3KultApp::slotPLPlaySong( QListViewItem* item)
{
     QString mp3;
     PLListItem* plitem;

	if (playerExe.isEmpty())
	{
		KMessageBox::error (this, i18n("Select a player in the Preferences"),
			i18n("Player not found"));
		//  cerr << "Player: " << playerExe << "\n";
		return;
	}

     plitem = (PLListItem*) item;

     mp3= plitem->getFileN();

     QFileInfo file(mp3);

     if (!file.exists())
     {
          KMessageBox::error (this, i18n("File " +  mp3 + "\n"
                                        "doesn't exist"), i18n("File not found"));
          return;
     }

     KProcess p;

     if (!playerOpt.isEmpty())
          p << playerExe << playerOpt << mp3;
     else
         p << playerExe  << mp3;

    p.start( KProcess::DontCare);
}

void Mp3KultApp::slotPopupPlaySongs()
{
	playSongs(false);
}

void Mp3KultApp::slotPopupEnqueueSongs()
{
	playSongs(true);
}

void Mp3KultApp::playSongs(bool enqueue)
{

	Mp3List* list;
	Mp3ListItem* item;
	QString mp3;
	bool done = false;

	if (playerExe.isEmpty())
	{
		KMessageBox::error (this, i18n("Select a player in the Preferences"),
			i18n("Player not found"));
		//  cerr << "Player: " << playerExe << "\n";
		return;
	}

	list=view->getListView();
	/*item = (Mp3ListItem*) list->currentItem();

	while ((item->itemAbove())!=NULL && (item->itemAbove()->isSelected()))
		item = item->itemAbove();*/

	KProcess p;
	p << playerExe;

	if (enqueue)
	{
		p << playerOpt;
	}
	else
	{
		if (playerExe.contains("gqmpeg"))
			p << "-pl";
	}

	QList<QListViewItem> itemList(list->selectedItems());
	QListIterator<QListViewItem> itemIt(itemList);

	while (/*(item != NULL) && (item->isSelected())*/itemIt.current())
	{
		item = (Mp3ListItem*) itemIt.current();
		mp3= (item->text(ID_PATH))+"/"+item->text(ID_FNAME);

		QFileInfo file(mp3);

		if (!file.exists())
		{
			/*KMessageBox::error (this, i18n("File " +  item->text(ID_FNAME) + "\n"
                                        "doesn't exist"), i18n("File not found"));*/
			//item = item->itemBelow();
			++itemIt;
			continue;
		}
		done = true;
		p << mp3;
		++itemIt;
		//item = item->itemBelow();
	}
	if (done)
		p.start( KProcess::DontCare);
	else
		KMessageBox::error (this, i18n("Selected files not found"), i18n("Files not found"));
}

void Mp3KultApp::slotPopupDelMp3()
{
     int response;
     Mp3ListItem* item;
     Mp3List* list;

     list=view->getListView();
   //  item=view->getListView()->currentItem();

	QList<QListViewItem> itemList(list->selectedItems());
	QListIterator<QListViewItem> itemIt(itemList);

     response=KMessageBox::questionYesNo(this, i18n("Do you want to remove\n"
                                           "selected entries ?"),
                                        i18n("DB erasing confirmation"));
     if (response == 3)
     {
	 			while (/*(item != NULL) && (item->isSelected())*/itemIt.current())
				{
				item = (Mp3ListItem*) itemIt.current();
          //MyDb* db = new MyDb();
          db->delMp3(item->text(ID_FNAME), item->text(ID_PATH),
                     item->text(ID_SIZE).toInt());
					cerr << "Mp3 Removed from database" << endl;
          //list->takeItem(item);
					delete item;
					cerr << "View Updated" << endl;
         /* view->decTotalMp3(1);
					cerr << "Updated mp3 number" << endl;*/
					++itemIt;
				}
				view->decTotalMp3(itemList.count());
				cerr << "Updated mp3 number, removed: " << itemList.count() << endl;
     }
}

void Mp3KultApp::slotViewTreeOptions(bool tree)
{
	if (tree)
	{
		viewTreeCloseAll->setEnabled(true);
		viewTreeOpenAll->setEnabled(true);
		viewToggleFindInAllTree->setEnabled(true);
	}
	else
	{
		viewTreeCloseAll->setEnabled(false);
		viewTreeOpenAll->setEnabled(false);
		viewToggleFindInAllTree->setEnabled(false);
	}
}

#include "mp3kult.moc"
