/***************************************************************************
                          ogg.h  -  description
                             -------------------
    begin                : Sat Feb 9 2002
    copyright            : (C) 2002 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OGGINFO_H
#define OGGINFO_H

#include <vorbis/codec.h>
#include <vorbis/vorbisfile.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "fileinfo.h"

class OggInfo : public FileInfo {
	public:
		OggInfo(const char* filein);
		~OggInfo();

	int getBitrateNominal();
	int getBitrateUpper();
	int getBitrateLower();
	int getSamplerate();
	int getMode();
	static const char* getMode(int mode);
	int getLength();
	const char* getLengthChar();
	const char* getTitle();
	const char* getArtist();
	const char* getAlbum();
	const char* getYear();
	const char* getTrack();
	const char* getComment();
	int getGenre();
	static const char* getGenre(int numgen);
	const char* getGenreC();
	bool getResult (){return success;};
	const char* getName();
const char* getPath();
int getSize();
int getBitrate();
bool getVbr(){return false;};

	private:

	char* get_current_charset(void);
	char* convert_string(const char *string, char *from, char *to);
	char* convert_to_utf8(const char *string);
	char* convert_from_utf8(const char *string);

	typedef struct {
		int version;
    int channels;
    long rate;
    long bitrate_upper;
    long bitrate_nominal;
    long bitrate_lower;
    double duration;
	} vorbis_header;

	typedef struct {
		char* artist;
		char* title;
		char* album;
		char* comment;
		char* year;
		int genre;
		char* track;
	} ogg_tag;

	vorbis_comment *vc;
	OggVorbis_File vf;
 vorbis_info *vi;
 FILE *file;
 bool success;
 char* fileglob;
};

#endif

