FUNCTION fitfunc, p, x=x, y=y, err=err
  gauss = p[0]+p[1]*exp(-(x-p[2])^2/(2*p[3]^2))
  return, (y - gauss)/err
END
PRO test_mpfit
  x = findgen(101)
  err = replicate(3.0,101) ; error estimate
  y = 25.*exp(-(x-32.)^2/(2*5.^2))+12.0+err*randomn(33,101)
  start_params = [12.,10.,45.,10.]
  functargs = {x:x, y:y, err:err}
  params = mpfit("fitfunc",start_params,functargs=functargs)
  ref = [12.032, 24.0875, 32.2197, 5.096]
  print, params, ref
  w=where(abs(params-ref) gt 0.5, count)
  if (count gt 0)  then exit, status=1
  exit, status=0
END
