/*
 * Decompiled with CFR 0.152.
 */
package old_base.drawable;

import javax.swing.JTree;
import old_base.drawable.DrawnBox;

public class DrawnBoxSet {
    private JTree tree_view;
    private DrawnBox[] last_arrow_pos;
    private DrawnBox[] last_state_pos;
    private DrawnBox[] last_event_pos;
    private int num_rows;

    public DrawnBoxSet(JTree jTree) {
        this.tree_view = jTree;
        this.last_arrow_pos = null;
        this.last_state_pos = null;
        this.last_event_pos = null;
        this.num_rows = 0;
    }

    public void initialize() {
        this.num_rows = this.tree_view.getRowCount();
        this.last_arrow_pos = new DrawnBox[this.num_rows * this.num_rows];
        this.last_state_pos = new DrawnBox[this.num_rows];
        this.last_event_pos = new DrawnBox[this.num_rows];
        int n = -1;
        for (int i = 0; i < this.num_rows; ++i) {
            if (!this.tree_view.isExpanded(i)) {
                this.last_state_pos[i] = new DrawnBox();
                this.last_event_pos[i] = new DrawnBox();
            } else {
                this.last_state_pos[i] = null;
                this.last_event_pos[i] = null;
            }
            for (int j = 0; j < this.num_rows; ++j) {
                this.last_arrow_pos[++n] = !this.tree_view.isExpanded(i) && !this.tree_view.isExpanded(j) ? new DrawnBox() : null;
            }
        }
    }

    public void reset() {
        int n = -1;
        for (int i = 0; i < this.num_rows; ++i) {
            if (this.last_state_pos[i] != null) {
                this.last_state_pos[i].reset();
                this.last_event_pos[i].reset();
            }
            for (int j = 0; j < this.num_rows; ++j) {
                if (this.last_arrow_pos[++n] == null) continue;
                this.last_arrow_pos[n].reset();
            }
        }
    }

    public void finalize() {
        int n = -1;
        for (int i = 0; i < this.num_rows; ++i) {
            if (this.last_state_pos[i] != null) {
                this.last_state_pos[i] = null;
                this.last_event_pos[i] = null;
            }
            for (int j = 0; j < this.num_rows; ++j) {
                if (this.last_arrow_pos[++n] == null) continue;
                this.last_arrow_pos[n] = null;
            }
        }
    }

    public DrawnBox getLastArrowPos(int n, int n2) {
        return this.last_arrow_pos[this.num_rows * n + n2];
    }

    public DrawnBox getLastStatePos(int n) {
        return this.last_state_pos[n];
    }

    public DrawnBox getLastEventPos(int n) {
        return this.last_event_pos[n];
    }
}

