/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.util.Iterator;
import logformat.slog2.BufForObjects;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.input.InputLog;
import logformat.slog2.input.TreeFloor;
import logformat.slog2.input.TreeFloorList;
import logformat.slog2.input.TreeNode;

public class TreeTrunk
extends TreeFloorList {
    public static final int TIMEBOX_DISJOINTED = -1;
    public static final int TIMEBOX_EQUAL = 0;
    public static final int TIMEBOX_SCROLLING = 1;
    public static final int TIMEBOX_ZOOMING = 2;
    private static boolean isDebugging = false;
    private static TimeBoundingBox timeframe_root;
    private short depth_root;
    private short depth_init;
    private short iZoom_level;
    private double duration_root;
    private double tZoomFactor;
    private double logZoomFactor;
    private InputLog slog_ins;
    private Drawable.Order node_dobj_order;
    private static final double TOLERANCE = (double)0.01f;

    public TreeTrunk(InputLog inputLog, Drawable.Order order) {
        super(order);
        this.slog_ins = inputLog;
        timeframe_root = null;
        this.node_dobj_order = order.isStartTimeOrdered() ? null : Drawable.INCRE_FINALTIME_ORDER;
    }

    public void initFromTreeTop() {
        FileBlockPtr fileBlockPtr = this.slog_ins.getFileBlockPtrToTreeRoot();
        if (fileBlockPtr.isNULL()) {
            return;
        }
        TreeNode treeNode = this.slog_ins.readTreeNode(fileBlockPtr);
        if (treeNode == null) {
            return;
        }
        if (this.node_dobj_order != null) {
            treeNode.reorderDrawables(this.node_dobj_order);
        }
        this.depth_root = treeNode.getTreeNodeID().depth;
        timeframe_root = new TimeBoundingBox(treeNode);
        this.duration_root = timeframe_root.getDuration();
        this.depth_init = this.depth_root;
        this.iZoom_level = 0;
        this.tZoomFactor = this.slog_ins.getNumChildrenPerNode();
        this.logZoomFactor = Math.log(this.tZoomFactor);
        super.init(this.depth_root);
        super.put(treeNode, treeNode);
    }

    public void setTimeZoomFactor(double d) {
        this.tZoomFactor = d;
        this.logZoomFactor = Math.log(this.tZoomFactor);
    }

    public double getTimeZoomFactor() {
        return this.tZoomFactor;
    }

    public TreeNode getTreeRoot() {
        return (TreeNode)super.getRoot();
    }

    public void growInTreeWindow(TreeNode treeNode, short s, TimeBoundingBox timeBoundingBox) {
        this.depth_init = s;
        this.growChildren(treeNode, this.depth_init, timeBoundingBox);
        super.updateLowestDepth();
    }

    private void growChildren(TreeNode treeNode, short s, TimeBoundingBox timeBoundingBox) {
        if (treeNode != null && treeNode.getTreeNodeID().depth > s) {
            if (treeNode.overlaps(timeBoundingBox)) {
                BufForObjects[] bufForObjectsArray = treeNode.getChildStubs();
                for (int i = 0; i < bufForObjectsArray.length; ++i) {
                    BufForObjects bufForObjects = bufForObjectsArray[i];
                    TreeNode treeNode2 = super.get(bufForObjects);
                    if (bufForObjects.overlaps(timeBoundingBox)) {
                        if (treeNode2 == null) {
                            FileBlockPtr fileBlockPtr = bufForObjects.getFileBlockPtr();
                            treeNode2 = this.slog_ins.readTreeNode(fileBlockPtr);
                            if (this.node_dobj_order != null) {
                                treeNode2.reorderDrawables(this.node_dobj_order);
                            }
                            super.put(bufForObjects, treeNode2);
                        }
                        this.growChildren(treeNode2, s, timeBoundingBox);
                        continue;
                    }
                    if (treeNode2 == null) continue;
                    this.removeChildren(treeNode2, s);
                    if (isDebugging) {
                        TreeTrunk.debug_println("TreeTrunk.growChildren(): remove(" + bufForObjects.getTreeNodeID() + ")");
                    }
                    super.remove(bufForObjects);
                }
            } else {
                String string = "TreeTrunk.growChildren(): ERROR!\n\t treenode.overlaps( time_win ) != true\n\t " + treeNode.getTreeNodeID() + "does NOT overlap with " + timeBoundingBox;
                throw new IllegalStateException(string);
            }
        }
    }

    private void removeChildren(TreeNode treeNode, short s) {
        if (treeNode != null && treeNode.getTreeNodeID().depth > s) {
            BufForObjects[] bufForObjectsArray = treeNode.getChildStubs();
            for (int i = 0; i < bufForObjectsArray.length; ++i) {
                BufForObjects bufForObjects = bufForObjectsArray[i];
                TreeNode treeNode2 = super.get(bufForObjects);
                if (treeNode2 == null) continue;
                this.removeChildren(treeNode2, s);
                if (isDebugging) {
                    TreeTrunk.debug_println("TreeTrunk.removeChildren(): remove(" + bufForObjects.getTreeNodeID() + ")");
                }
                super.remove(bufForObjects);
            }
        }
    }

    public void setNumOfViewsPerUpdate(int n) {
        this.duration_root *= (double)n;
    }

    private short getZoomLevel(TimeBoundingBox timeBoundingBox) {
        return (short)Math.round(Math.log(this.duration_root / timeBoundingBox.getDuration()) / this.logZoomFactor);
    }

    public void zoomTimeWindowTo(TimeBoundingBox timeBoundingBox) {
        if (isDebugging) {
            TreeTrunk.debug_println("zoomTimeWindowTo( " + timeBoundingBox + " )");
        }
        this.iZoom_level = this.getZoomLevel(timeBoundingBox);
        TreeFloor treeFloor = super.getLowestFloor();
        TreeFloor treeFloor2 = super.getCoveringFloor(timeBoundingBox);
        short s = treeFloor2.getDepth();
        short s2 = treeFloor.getDepth();
        short s3 = (short)(this.depth_init - this.iZoom_level);
        if (s3 < 0) {
            s3 = 0;
        }
        if (s3 > this.depth_root) {
            s3 = this.depth_root;
        }
        if (isDebugging) {
            TreeTrunk.debug_println("coverer_depth = " + s);
            TreeTrunk.debug_println("lowester_depth = " + s2);
            TreeTrunk.debug_println("iZoom_level = " + this.iZoom_level);
            TreeTrunk.debug_println("next_depth = " + s3);
        }
        if (s3 < s) {
            Iterator iterator = treeFloor2.values().iterator();
            while (iterator.hasNext()) {
                TreeNode treeNode = (TreeNode)iterator.next();
                if (treeNode.overlaps(timeBoundingBox)) {
                    this.growChildren(treeNode, s3, timeBoundingBox);
                    continue;
                }
                this.removeChildren(treeNode, s3);
                if (isDebugging) {
                    TreeTrunk.debug_println("TreeTrunk.zoomTimeWindowTo(): remove(" + treeNode.getTreeNodeID() + ")");
                }
                iterator.remove();
            }
            super.removeAllChildFloorsBelow(s3);
        }
        if (isDebugging) {
            TreeTrunk.debug_println(super.toStubString());
        }
    }

    public void scrollTimeWindowTo(TimeBoundingBox timeBoundingBox) {
        TreeFloor treeFloor;
        if (isDebugging) {
            TreeTrunk.debug_println("scrollTimeWindowTo( " + timeBoundingBox + " )");
        }
        if (!(treeFloor = super.getLowestFloor()).covers(timeBoundingBox)) {
            short s;
            TreeFloor treeFloor2 = super.getCoveringFloor(timeBoundingBox);
            short s2 = treeFloor2.getDepth();
            short s3 = s = treeFloor.getDepth();
            if (isDebugging) {
                TreeTrunk.debug_println("coverer_depth = " + s2);
                TreeTrunk.debug_println("lowester_depth = " + s);
                TreeTrunk.debug_println("iZoom_level = " + this.iZoom_level);
                TreeTrunk.debug_println("next_depth = " + s3);
            }
            if (s3 < s2) {
                Iterator iterator = treeFloor2.values().iterator();
                while (iterator.hasNext()) {
                    TreeNode treeNode = (TreeNode)iterator.next();
                    if (treeNode.overlaps(timeBoundingBox)) {
                        this.growChildren(treeNode, s3, timeBoundingBox);
                        continue;
                    }
                    this.removeChildren(treeNode, s3);
                    if (isDebugging) {
                        TreeTrunk.debug_println("TreeTrunk.scrollTimeWindowTo(): remove(" + treeNode.getTreeNodeID() + ")");
                    }
                    iterator.remove();
                }
                super.removeAllChildFloorsBelow(s3);
            }
        }
        if (isDebugging) {
            TreeTrunk.debug_println(super.toStubString());
        }
    }

    public int updateTimeWindow(TimeBoundingBox timeBoundingBox, TimeBoundingBox timeBoundingBox2) {
        if (timeframe_root.overlaps(timeBoundingBox2)) {
            if (!timeBoundingBox.equals(timeBoundingBox2)) {
                double d = timeBoundingBox2.getDuration() / timeBoundingBox.getDuration();
                if (Math.abs(d - 1.0) <= (double)0.01f) {
                    this.scrollTimeWindowTo(timeBoundingBox2);
                    return 1;
                }
                this.zoomTimeWindowTo(timeBoundingBox2);
                return 2;
            }
            return 0;
        }
        if (isDebugging) {
            TreeTrunk.debug_println("TreeTrunk.updateTimeWindow(): ERROR!\n\t TimeWindow disjoints from TimeFrame@TreeRoot.\n\t TimeWin@TreeRoot = " + timeframe_root + "\n" + "\t TimeWin_old      = " + timeBoundingBox + "\n" + "\t TimeWin_new      = " + timeBoundingBox2 + "\n");
        }
        return -1;
    }

    public void setDebuggingEnabled(boolean bl) {
        isDebugging = bl;
    }

    public boolean isDebugging() {
        return isDebugging;
    }

    private static void debug_println(String string) {
        System.out.println(string);
    }
}

