/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.util.Iterator;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.input.InputLog;

public class PrintSerially {
    private static String in_filename;
    private static Drawable.Order dobj_order;
    private static int itrTopoLevel;
    private static double time_init_ftr;
    private static double time_final_ftr;
    private static boolean printCategoryMap;
    private static boolean printTreeDir;
    private static boolean printLineIDMaps;
    private static boolean printDrawables;
    private static String help_msg;

    public static final void main(String[] stringArray) {
        String string;
        PrintSerially.parseCmdLineArgs(stringArray);
        InputLog inputLog = new InputLog(in_filename);
        if (inputLog == null) {
            System.err.println("Null input logfile!");
            System.exit(1);
        }
        if (!inputLog.isSLOG2()) {
            System.err.println(in_filename + " is NOT SLOG-2 file!.");
            System.exit(1);
        }
        if ((string = inputLog.getCompatibleHeader()) != null) {
            System.err.print(string);
            InputLog.stdoutConfirmation();
        }
        inputLog.initialize();
        System.out.println(inputLog.toString(printCategoryMap, printTreeDir, printLineIDMaps));
        if (!printDrawables) {
            inputLog.close();
            System.exit(0);
        }
        TreeDir treeDir = inputLog.getTreeDir();
        TreeDirValue treeDirValue = (TreeDirValue)treeDir.get(treeDir.firstKey());
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox(treeDirValue.getTimeBoundingBox());
        PrintSerially.scaleTimeBounds(timeBoundingBox);
        boolean bl = dobj_order.isStartTimeOrdered();
        boolean bl2 = dobj_order.isIncreasingTimeOrdered();
        double d = bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        int n = 0;
        Iterator iterator = inputLog.iteratorOfRealDrawables(timeBoundingBox, dobj_order, itrTopoLevel);
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            double d2 = drawable.getBorderTime(bl);
            if (bl2) {
                if (d > d2) {
                    System.out.print("  *****  ");
                }
            } else if (d < d2) {
                System.out.print("  *****  ");
            }
            System.out.println(++n + ": " + drawable);
            d = d2;
        }
        inputLog.close();
    }

    private static void scaleTimeBounds(TimeBoundingBox timeBoundingBox) {
        double d = timeBoundingBox.getEarliestTime();
        double d2 = timeBoundingBox.getLatestTime();
        double d3 = d2 - d;
        timeBoundingBox.setEarliestTime(d + time_init_ftr * d3);
        timeBoundingBox.setLatestTime(d + time_final_ftr * d3);
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    String string;
                    if (stringArray[n].equals("-h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (stringArray[n].equals("-c") || stringArray[n].equals("-category")) {
                        printCategoryMap = true;
                        printTreeDir = false;
                        printLineIDMaps = false;
                        printDrawables = false;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-d") || stringArray[n].equals("-directory")) {
                        printCategoryMap = false;
                        printTreeDir = true;
                        printLineIDMaps = false;
                        printDrawables = false;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-y") || stringArray[n].equals("-ycoordmap")) {
                        printCategoryMap = false;
                        printTreeDir = false;
                        printLineIDMaps = true;
                        printDrawables = false;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-is") || stringArray[n].equals("-incre_starttime")) {
                        dobj_order = Drawable.INCRE_STARTTIME_ORDER;
                        printDrawables = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ds") || stringArray[n].equals("-decre_starttime")) {
                        dobj_order = Drawable.DECRE_STARTTIME_ORDER;
                        printDrawables = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ie") || stringArray[n].equals("-incre_endtime")) {
                        dobj_order = Drawable.INCRE_FINALTIME_ORDER;
                        printDrawables = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-de") || stringArray[n].equals("-decre_endtime")) {
                        dobj_order = Drawable.DECRE_FINALTIME_ORDER;
                        printDrawables = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-s") || stringArray[n].equals("-state")) {
                        itrTopoLevel = 2;
                        printDrawables = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-a") || stringArray[n].equals("-arrow")) {
                        itrTopoLevel = 1;
                        printDrawables = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ts")) {
                        string = stringArray[++n];
                        time_init_ftr = Double.parseDouble(string);
                        stringBuffer.append("\n time_start_factor = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-tf")) {
                        string = stringArray[++n];
                        time_final_ftr = Double.parseDouble(string);
                        stringBuffer.append("\n time_final_factor = " + string);
                        ++n;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + PrintSerially.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = stringArray[n];
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + PrintSerially.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
        if (time_init_ftr > time_final_ftr || time_init_ftr < 0.0 || time_final_ftr > 1.0) {
            System.err.println("Invalid time_init_factor and time_final_factor!");
            System.err.println("time_init_factor = " + time_init_ftr);
            System.err.println("time_final_factor = " + time_final_ftr);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        dobj_order = Drawable.INCRE_STARTTIME_ORDER;
        itrTopoLevel = 0;
        time_init_ftr = 0.0;
        time_final_ftr = 1.0;
        printCategoryMap = true;
        printTreeDir = true;
        printLineIDMaps = true;
        printDrawables = true;
        help_msg = "Usage: java slog2.input.PrintSerially [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]           \t Display this message.\n\t [-c|-category] DEF          \t Print category map only.\n\t [-d|-directory] DEF         \t Print directory tree only.\n\t [-y|-ycoordmap] DEF         \t Print Y-coord. map only.\n\t [-s|-state] DEF             \t Print states only.\n\t [-a|-arrow] DEF             \t Print arrows only.\n\t [-is|-incre_starttime] DEF  \t Print in increasing starttime order.\n\t [-ds|-decre_starttime]      \t Print in decreasing starttime order.\n\t [-ie|-incre_endtime]        \t Print in increasing endtime order.\n\t [-de|-decre_endtime]        \t Print in decreasing endtime order.\n\t [-ts time_start_factor]     \t Default value is 0.0 (min).\n\t [-tf time_final_factor]     \t Default value is 1.0 (max).\n*** The options marked by DEF are enabled by default.\n";
    }
}

